package com.jshx.rfxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmfshxxDao;
import com.jshx.rfxm.entity.Rfxmfshxx;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author: Danfoen
 * @Description:
 * @Date: Created in 14:17 2019/5/23
 * @Modifird by:
 */
@Component("rfxmfshxxDao")
public class RfxmfshxxDaoImpl  extends BaseDaoImpl implements RfxmfshxxDao {

    /**
     * 分页查询
     * @param page 分页信息
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
    {
        return this.findPageByHqlId("findRfxmfshxxByMap", paraMap, page);
    }

    /**
     * 查询所有记录
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    @Override
    public List findRfxmfshxx(Map<String, Object> paraMap) {
        return this.findListByHqlId("findRfxmfshxxByMap", paraMap);
    }

    /**
     * 根据主键ID查询信息
     * @param id 主键ID
     * @return 主键ID对应的信息
     */
    @Override
    public Rfxmfshxx getById(String id) {
        return (Rfxmfshxx) this.getObjectById(Rfxmfshxx.class, id);
    }

    /**
     * 保存信息
     * @param rfxmfshxx 信息
     */
    @Override
    public void save(Rfxmfshxx rfxmfshxx) {
        rfxmfshxx.setId(null);
        this.saveOrUpdateObject(rfxmfshxx);
    }

    /**
     * 修改信息
     * @param rfxmfshxx 信息
     */
    @Override
    public void update(Rfxmfshxx rfxmfshxx) {
        this.saveOrUpdateObject(rfxmfshxx);
    }

    /**
     * 物理删除信息
     * @param id 主键ID
     */
    @Override
    public void delete(String id) {
        this.removeObjectById(Rfxmfshxx.class, id);
    }

    /**
     * 逻辑删除信息
     * @param id 主键ID
     */
    @Override
    public void deleteWithFlag(String id) {
        Rfxmfshxx rfxmfshxx = (Rfxmfshxx)this.getObjectById(Rfxmfshxx.class, id);
        rfxmfshxx.setDelFlag(1);
        this.saveObject(rfxmfshxx);
    }
}
