package com.jshx.qtfymx.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jmmx.entity.Jmmx;
import com.jshx.qtfymx.dao.QtfymxDao;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.qtfymx.service.QtfymxService;

@Service("qtfymxService")
public class QtfymxServiceImpl extends BaseServiceImpl implements QtfymxService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("qtfymxDao")
	private QtfymxDao qtfymxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return qtfymxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Qtfymx getById(String id)
	{
		return qtfymxDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Qtfymx qtfymx)
	{
		qtfymxDao.save(qtfymx);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Qtfymx qtfymx)
	{
		qtfymxDao.update(qtfymx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=qtfymxDao.findQtfymx(paraMap);
		
		qtfymxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    qtfymxDao.deleteWithFlag(id);
			}
		}
	}

	@Transactional
	public String savelist(List<Qtfymx> list) throws Exception {
		String message="0";
        try{
        	for (Qtfymx jmmx : list) {
            	qtfymxDao.save(jmmx);
    		}	
        }catch(Exception ex){
        	message="1";
        	TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        	
        }
        return message;
	}

	@Override
	public List<Qtfymx> findall(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return qtfymxDao.findQtfymx(paraMap);
	}
}
