package com.jshx.paymentItemHis.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.module.admin.entity.User;
import com.jshx.xmxxb.entity.Xmxxb;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="PAYMENT_ITEM_HIS")
public class PaymentItemHis extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 项目表主键
	 */
	private String xmbzj;
	
	private Xmxxb xmxxb;

	/**
	 * 受理编号
	 */
	private String slbh;

	/**
	 * 单位名称
	 */
	private String dwmc;

	/**
	 * 项目名称
	 */
	private String xmmc;

	/**
	 * 面积依据
	 */
	private String mjyj;

	/**
	 * 抵扣项目受理号
	 */
	private String dkxmslh;

	/**
	 * 执收单位
	 */
	private String zsdw;
	
	/**
	 * 单位代码
	 */
	private String dwdm;

	/**
	 * 抵扣面积
	 */
	private String dkmj;

	/**
	 * 测算面积
	 */
	private String csmj;

	/**
	 * 配套费应缴面积
	 */
	private String ptyjmj;

	/**
	 * 配套费应缴金额
	 */
	private String ptyjje;

	/**
	 * 配套费应免金额
	 */
	private String ptymje;

	/**
	 * 配套费应免面积
	 */
	private String ptymmj;

	/**
	 * 人防应缴面积
	 */
	private String rfyjmj;

	/**
	 * 人防应缴金额
	 */
	private String rfyjje;

	/**
	 * 人防应免面积
	 */
	private String rfymmj;

	/**
	 * 人防应免金额
	 */
	private String rfymje;
	
	/**
	 * 人防发票编号
	 */
	private String rffpbh;

	/**
	 * 新墙应缴金额
	 */
	private String xqyjje;

	/**
	 * 新墙应免面积
	 */
	private String xqymmj;

	/**
	 * 新墙应免金额
	 */
	private String xqymje;

	/**
	 * 新墙应缴面积
	 */
	private String xqyjmj;
	
	/**
	 * 新墙发票编号
	 */
	private String xqfpbh;

	/**
	 * 白蚁应缴面积
	 */
	private String byyjmj;

	/**
	 * 白蚁应缴金额
	 */
	private String byyjje;

	/**
	 * 白蚁应免面积
	 */
	private String byymmj;

	/**
	 * 白蚁应免金额
	 */
	private String byymje;
	
	/**
	 * 白蚁发票编号
	 */
	private String byfpbh;
	
	/**
	 * 总应免金额
	 */
	private String zymje;

	/**
	 * 总应缴金额
	 */
	private String zyjje;
	
	/**
	 * 是否允许打印一般缴款书
	 */
	private String printFlag;
	
	/**
	 * 电子监管号
	 */
	private String ECN;
	
	/**
	 * 征收联系单编号
	 */
	private String zslxdbh;
	
	/**
	 * 是否打印过缴费凭证 (0:未打印 1:已打印)
	 */
	private String isPrintJfpz;

	/**
	 * 相关银行缴费记录
	 */
	private String accountbankId;
	
	/**
	 * 催缴标识
	 */
	private String warnFlag;
	
	/**
	 * 项目解锁标识 0：解锁 1：上锁
	 */
	private String lockFlag;
	
	/**
	 * 非税状态   0：可上传 1：不可上传
	 */
	private String nonTaxStatus;
	/**
	 * 人防开票时间
	 */
	private Date rfkpsj;
	/**
	 * 白蚁开票时间
	 */
	private Date bykpsj;
	/**
	 * 新墙体开票时间
	 */
	private Date xqtkpsj;
	
	/**
	 * 经办人用户id
	 */
	private String operatorId;

	/**
	 * 经办人
	 */
	private String jbr;
	
	private User operator;
	
	/**
	 * 经办日期
	 */
	private Date operateDate;
	/**
	 * 解锁经办意见
	 */
	private String operatorComment;
	
	/**
	 * 是否发送短信  1是已发送
	 * 
	 */
       private String isfdx;

       //是否一站式
	private Integer yzsFlag;

	/**
	 * 是否生成缴费凭证 (0:未生成 1:已生成)
	 */
	private String isCreateJfpz;

	/**
	 * 是否财务用章
	 */
	private String isCwyz;
	
	public PaymentItemHis(){
	}
	
	public PaymentItemHis(Integer yzsFlag, String id, String slbh, String dwmc, String xmmc, String mjyj, String dkxmslh, String zsdw, String dkmj, String csmj, String ptyjmj, String ptyjje, String ptymje, String ptymmj, String rfyjmj, String rfyjje, String rfymmj, String rfymje, String xqyjje, String xqymmj, String xqymje, String xqyjmj, String byyjmj, String byyjje, String byymmj, String byymje, String zyjje, String zymje, String warnFlag, String accountbankId){
		this.yzsFlag = yzsFlag;

		this.id = id;
		
		this.slbh = slbh;
		
		this.dwmc = dwmc;
		
		this.xmmc = xmmc;
		
		this.mjyj = mjyj;
		
		this.dkxmslh = dkxmslh;
		
		this.zsdw = zsdw;
		
		this.dkmj = dkmj;
		
		this.csmj = csmj;
		
		this.ptyjmj = ptyjmj;
		
		this.ptyjje = ptyjje;
		
		this.ptymje = ptymje;
		
		this.ptymmj = ptymmj;
		
		this.rfyjmj = rfyjmj;
		
		this.rfyjje = rfyjje;
		
		this.rfymmj = rfymmj;
		
		this.rfymje = rfymje;
		
		this.xqyjje = xqyjje;
		
		this.xqymmj = xqymmj;
		
		this.xqymje = xqymje;
		
		this.xqyjmj = xqyjmj;
		
		this.byyjmj = byyjmj;
		
		this.byyjje = byyjje;
		
		this.byymmj = byymmj;
		
		this.byymje = byymje;
		
		this.zyjje = zyjje;
		
		this.zymje = zymje;
		
		this.warnFlag = warnFlag;
		
		this.accountbankId = accountbankId;
	}

	@Override
	public String toString() {
		return "PaymentItemHis{" +
				"deptId='" + deptId + '\'' +
				", delFlag=" + delFlag +
				", xmbzj='" + xmbzj + '\'' +
				", xmxxb=" + xmxxb +
				", slbh='" + slbh + '\'' +
				", dwmc='" + dwmc + '\'' +
				", xmmc='" + xmmc + '\'' +
				", mjyj='" + mjyj + '\'' +
				", dkxmslh='" + dkxmslh + '\'' +
				", zsdw='" + zsdw + '\'' +
				", dwdm='" + dwdm + '\'' +
				", dkmj='" + dkmj + '\'' +
				", csmj='" + csmj + '\'' +
				", ptyjmj='" + ptyjmj + '\'' +
				", ptyjje='" + ptyjje + '\'' +
				", ptymje='" + ptymje + '\'' +
				", ptymmj='" + ptymmj + '\'' +
				", rfyjmj='" + rfyjmj + '\'' +
				", rfyjje='" + rfyjje + '\'' +
				", rfymmj='" + rfymmj + '\'' +
				", rfymje='" + rfymje + '\'' +
				", rffpbh='" + rffpbh + '\'' +
				", xqyjje='" + xqyjje + '\'' +
				", xqymmj='" + xqymmj + '\'' +
				", xqymje='" + xqymje + '\'' +
				", xqyjmj='" + xqyjmj + '\'' +
				", xqfpbh='" + xqfpbh + '\'' +
				", byyjmj='" + byyjmj + '\'' +
				", byyjje='" + byyjje + '\'' +
				", byymmj='" + byymmj + '\'' +
				", byymje='" + byymje + '\'' +
				", byfpbh='" + byfpbh + '\'' +
				", zymje='" + zymje + '\'' +
				", zyjje='" + zyjje + '\'' +
				", printFlag='" + printFlag + '\'' +
				", ECN='" + ECN + '\'' +
				", zslxdbh='" + zslxdbh + '\'' +
				", isPrintJfpz='" + isPrintJfpz + '\'' +
				", accountbankId='" + accountbankId + '\'' +
				", warnFlag='" + warnFlag + '\'' +
				", lockFlag='" + lockFlag + '\'' +
				", nonTaxStatus='" + nonTaxStatus + '\'' +
				", rfkpsj=" + rfkpsj +
				", bykpsj=" + bykpsj +
				", xqtkpsj=" + xqtkpsj +
				", operatorId='" + operatorId + '\'' +
				", operator=" + operator +
				", operateDate=" + operateDate +
				", operatorComment='" + operatorComment + '\'' +
				", isfdx='" + isfdx + '\'' +
				", yzsFlag='" + yzsFlag + '\'' +
				'}';
	}

	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="XMBZJ")
	public String getXmbzj()
	{
		return this.xmbzj;
	}

	public void setXmbzj(String xmbzj)
	{
		this.xmbzj = xmbzj;
	}

	@ManyToOne(fetch = FetchType.EAGER, targetEntity=Xmxxb.class)
	@JoinColumn(name = "XMBZJ",updatable=false,insertable=false)
	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	@Column(name="SLBH")
	public String getSlbh()
	{
		return this.slbh;
	}

	public void setSlbh(String slbh)
	{
		this.slbh = slbh;
	}

	@Column(name="DWMC")
	public String getDwmc()
	{
		return this.dwmc;
	}

	public void setDwmc(String dwmc)
	{
		this.dwmc = dwmc;
	}

	@Column(name="XMMC")
	public String getXmmc()
	{
		return this.xmmc;
	}

	public void setXmmc(String xmmc)
	{
		this.xmmc = xmmc;
	}

	@Column(name="MJYJ")
	public String getMjyj()
	{
		return this.mjyj;
	}

	public void setMjyj(String mjyj)
	{
		this.mjyj = mjyj;
	}

	@Column(name="DKXMSLH")
	public String getDkxmslh()
	{
		return this.dkxmslh;
	}

	public void setDkxmslh(String dkxmslh)
	{
		this.dkxmslh = dkxmslh;
	}

	@Column(name="ZSDW")
	public String getZsdw()
	{
		return this.zsdw;
	}

	public void setZsdw(String zsdw)
	{
		this.zsdw = zsdw;
	}

	@Column(name="DKMJ")
	public String getDkmj()
	{
		return this.dkmj;
	}

	public void setDkmj(String dkmj)
	{
		this.dkmj = dkmj;
	}

	@Column(name="CSMJ")
	public String getCsmj()
	{
		return this.csmj;
	}

	public void setCsmj(String csmj)
	{
		this.csmj = csmj;
	}

	@Column(name="PTYJMJ")
	public String getPtyjmj()
	{
		return this.ptyjmj;
	}

	public void setPtyjmj(String ptyjmj)
	{
		this.ptyjmj = ptyjmj;
	}

	@Column(name="PTYJJE")
	public String getPtyjje()
	{
		return this.ptyjje;
	}

	public void setPtyjje(String ptyjje)
	{
		this.ptyjje = ptyjje;
	}

	@Column(name="PTYMJE")
	public String getPtymje()
	{
		return this.ptymje;
	}

	public void setPtymje(String ptymje)
	{
		this.ptymje = ptymje;
	}

	@Column(name="PTYMMJ")
	public String getPtymmj()
	{
		return this.ptymmj;
	}

	public void setPtymmj(String ptymmj)
	{
		this.ptymmj = ptymmj;
	}

	@Column(name="RFYJMJ")
	public String getRfyjmj()
	{
		return this.rfyjmj;
	}

	public void setRfyjmj(String rfyjmj)
	{
		this.rfyjmj = rfyjmj;
	}

	@Column(name="RFYJJE")
	public String getRfyjje()
	{
		return this.rfyjje;
	}

	public void setRfyjje(String rfyjje)
	{
		this.rfyjje = rfyjje;
	}

	@Column(name="RFYMMJ")
	public String getRfymmj()
	{
		return this.rfymmj;
	}

	public void setRfymmj(String rfymmj)
	{
		this.rfymmj = rfymmj;
	}

	@Column(name="RFYMJE")
	public String getRfymje()
	{
		return this.rfymje;
	}

	public void setRfymje(String rfymje)
	{
		this.rfymje = rfymje;
	}

	@Column(name="RFFPBH")
	public String getRffpbh() {
		return rffpbh;
	}

	public void setRffpbh(String rffpbh) {
		this.rffpbh = rffpbh;
	}

	@Column(name="XQYJJE")
	public String getXqyjje()
	{
		return this.xqyjje;
	}

	public void setXqyjje(String xqyjje)
	{
		this.xqyjje = xqyjje;
	}

	@Column(name="XQYMMJ")
	public String getXqymmj()
	{
		return this.xqymmj;
	}

	public void setXqymmj(String xqymmj)
	{
		this.xqymmj = xqymmj;
	}

	@Column(name="XQYMJE")
	public String getXqymje()
	{
		return this.xqymje;
	}

	public void setXqymje(String xqymje)
	{
		this.xqymje = xqymje;
	}

	@Column(name="XQYJMJ")
	public String getXqyjmj()
	{
		return this.xqyjmj;
	}

	public void setXqyjmj(String xqyjmj)
	{
		this.xqyjmj = xqyjmj;
	}

	@Column(name="XQFPBH")
	public String getXqfpbh() {
		return xqfpbh;
	}

	public void setXqfpbh(String xqfpbh) {
		this.xqfpbh = xqfpbh;
	}

	@Column(name="BYYJMJ")
	public String getByyjmj()
	{
		return this.byyjmj;
	}

	public void setByyjmj(String byyjmj)
	{
		this.byyjmj = byyjmj;
	}

	@Column(name="BYYJJE")
	public String getByyjje()
	{
		return this.byyjje;
	}

	public void setByyjje(String byyjje)
	{
		this.byyjje = byyjje;
	}

	@Column(name="BYYMMJ")
	public String getByymmj()
	{
		return this.byymmj;
	}

	public void setByymmj(String byymmj)
	{
		this.byymmj = byymmj;
	}

	@Column(name="BYYMJE")
	public String getByymje()
	{
		return this.byymje;
	}

	public void setByymje(String byymje)
	{
		this.byymje = byymje;
	}

	@Column(name="BYFPBH")
	public String getByfpbh() {
		return byfpbh;
	}

	public void setByfpbh(String byfpbh) {
		this.byfpbh = byfpbh;
	}

	@Column(name="ACCOUNTBANK_ID")
	public String getAccountbankId()
	{
		return this.accountbankId;
	}

	public void setAccountbankId(String accountbankId)
	{
		this.accountbankId = accountbankId;
	}
	
	@Column(name="WARN_FLAG")
	public String getWarnFlag()
	{
		return this.warnFlag;
	}

	public void setWarnFlag(String warnFlag)
	{
		this.warnFlag = warnFlag;
	}
	
	@Column(name="PRINTFLAG")
	public String getPrintFlag() {
		return printFlag;
	}

	public void setPrintFlag(String printFlag) {
		this.printFlag = printFlag;
	}
	
	@Column(name="ECN")
	public String getECN() {
		return ECN;
	}
	
	public void setECN(String eCN) {
		ECN = eCN;
	}

	@Column(name="ZSLXDBH")
	public String getZslxdbh() {
		return zslxdbh;
	}

	public void setZslxdbh(String zslxdbh) {
		this.zslxdbh = zslxdbh;
	}

	@Column(name="IS_PRINTJFPZ")
	public String getIsPrintJfpz() {
		return isPrintJfpz;
	}

	public void setIsPrintJfpz(String isPrintJfpz) {
		this.isPrintJfpz = isPrintJfpz;
	}

	@Column(name="ZYMJE")
	public String getZymje()
	{
		return this.zymje;
	}

	public void setZymje(String zymje)
	{
		this.zymje = zymje;
	}

	@Column(name="ZYJJE")
	public String getZyjje()
	{
		return this.zyjje;
	}

	public void setZyjje(String zyjje)
	{
		this.zyjje = zyjje;
	}

	@Column(name="DWDM")
	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}

	@Column(name="LOCK_FLAG")
	public String getLockFlag() {
		return lockFlag;
	}

	public void setLockFlag(String lockFlag) {
		this.lockFlag = lockFlag;
	}

	@Column(name="NONTAX_STATUS")
	public String getNonTaxStatus() {
		return nonTaxStatus;
	}

	public void setNonTaxStatus(String nonTaxStatus) {
		this.nonTaxStatus = nonTaxStatus;
	}
    
	@Column(name="RFKPSJ")
	public Date getRfkpsj() {
		return rfkpsj;
	}

	public void setRfkpsj(Date rfkpsj) {
		this.rfkpsj = rfkpsj;
	}
    
	@Column(name="BYKPSJ")
	public Date getBykpsj() {
		return bykpsj;
	}

	public void setBykpsj(Date bykpsj) {
		this.bykpsj = bykpsj;
	}
    
	@Column(name="XQTKPSJ")
	public Date getXqtkpsj() {
		return xqtkpsj;
	}

	public void setXqtkpsj(Date xqtkpsj) {
		this.xqtkpsj = xqtkpsj;
	}
	
	@Column(name="OPERATOR_ID")
	public String getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}

	@ManyToOne(fetch = FetchType.EAGER, targetEntity=User.class)
	@JoinColumn(name = "OPERATOR_ID",updatable=false,insertable=false)
	public User getOperator() {
		return operator;
	}

	public void setOperator(User operator) {
		this.operator = operator;
	}

	@Column(name="OPERATE_DATE")
	public Date getOperateDate() {
		return operateDate;
	}

	public void setOperateDate(Date operateDate) {
		this.operateDate = operateDate;
	}

	@Column(name="OPERATOR_COMMENT")
	public String getOperatorComment() {
		return operatorComment;
	}

	public void setOperatorComment(String operatorComment) {
		this.operatorComment = operatorComment;
	}
	@Column(name="ISFDX")
    public String getIsfdx() {
        return isfdx;
    }

    public void setIsfdx(String isfdx) {
        this.isfdx = isfdx;
    }

    @Column(name = "YZS_FLAG")
	public Integer getYzsFlag() {
		return yzsFlag;
	}

	public void setYzsFlag(Integer yzsFlag) {
		this.yzsFlag = yzsFlag;
	}

	@Column(name="IS_CREATEJFPZ")
	public String getIsCreateJfpz() {
		return isCreateJfpz;
	}

	public void setIsCreateJfpz(String isCreateJfpz) {
		this.isCreateJfpz = isCreateJfpz;
	}
	@Column(name="IS_CWYZ")
	public String getIsCwyz() {
		return isCwyz;
	}

	public void setIsCwyz(String isCwyz) {
		this.isCwyz = isCwyz;
	}

	public String getJbr() {
		return jbr;
	}

	public void setJbr(String jbr) {
		this.jbr = jbr;
	}
}
