package com.jshx.lsfc.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.lsfc.entity.Lsfc;
import com.jshx.lsfc.dao.LsfcDao;

@Component("lsfcDao")
public class LsfcDaoImpl extends BaseDaoImpl implements LsfcDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findLsfcByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findLsfc(Map<String, Object> paraMap){
		return this.findListByHqlId("findLsfcByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Lsfc getById(String id)
	{
		return (Lsfc)this.getObjectById(Lsfc.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Lsfc lsfc)
	{
		lsfc.setId(null);
		this.saveOrUpdateObject(lsfc);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Lsfc lsfc)
	{
		this.saveOrUpdateObject(lsfc);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Lsfc.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Lsfc lsfc = (Lsfc)this.getObjectById(Lsfc.class, id);
		lsfc.setDelFlag(1);
		this.saveObject(lsfc);
	}
}
