package com.jshx.jkfsjlb.web;

import com.alibaba.fastjson.JSONObject;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.jkfsjlb.entity.Jkfsjlb;
import com.jshx.jkfsjlb.service.JkfsjlbService;

import com.jshx.tbshxk.entity.Tbshxk;
import com.jshx.tbshxk.service.TbshxkService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
public class Jkfsdsrw {

    @Autowired
    private JkfsjlbService jkfsjlbService;
    @Autowired
    private TbshxkService tbshxkService;
    /**
     * 定时任务，每个小时执行一次
     */
    @Scheduled(cron= "0 0 * * * ?")
    public void reSendJk()
    {
        Map<String ,Object> paramMap = new HashMap<>();
        paramMap.put("fszt",1L);
        List<Jkfsjlb> jkfsjlbs = jkfsjlbService.findJkfsjl(paramMap);
        if(CollectionUtils.isNotEmpty(jkfsjlbs))
        {
            for(Jkfsjlb jkfsjlb : jkfsjlbs)
            {
//               String url = jkfsjlb.getJkdz();
//                String way = jkfsjlb.getFsfs();
                Long times = jkfsjlb.getCfcs();
                Long maxTimes = Long.valueOf(SysPropertiesUtil.getProperty("maxReSendTimes"));
                //重发次数限制，只重发一个月
                if(null != times && times>maxTimes)
                {
                    continue;
                }
                String param = jkfsjlb.getFscs();
                Map json = (Map) JSONObject.parse(param);
                com.jshx.module.admin.web.action.CommonAction.send2ww(json,jkfsjlb);
            }
        }

        Map<String ,Object> paramMap1 = new HashMap<>();
        paramMap.put("fszt","1");
        List<Tbshxk> tbshxks = tbshxkService.findByPage(new Pagination(1,0),paramMap).getListOfObject();
        if(CollectionUtils.isNotEmpty(tbshxks))
        {
            for(Tbshxk tbshxk : tbshxks)
            {
                Long times = tbshxk.getCfcs();
                Long maxTimes = Long.valueOf(SysPropertiesUtil.getProperty("maxReSendTimes"));
                //重发次数限制，只重发一个月
                if(null != times && times>maxTimes)
                {
                    continue;
                }
                com.jshx.module.admin.web.action.CommonAction.send2wwSGXK(null,tbshxk,null,null);
            }
        }

        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        System.err.println("接口重发定时任务在："+dateFormat.format(new Date())+"已执行完毕。");
    }
}