package com.jshx.jizihao.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jizihao.entity.Jizihao;
import com.jshx.jizihao.dao.JizihaoDao;

@Component("jizihaoDao")
public class JizihaoDaoImpl extends BaseDaoImpl implements JizihaoDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJizihaoByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findJizihao(Map<String, Object> paraMap){
		return this.findListByHqlId("findJizihaoByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jizihao getById(String id)
	{
		return (Jizihao)this.getObjectById(Jizihao.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Jizihao jizihao)
	{
		jizihao.setId(null);
		this.saveOrUpdateObject(jizihao);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Jizihao jizihao)
	{
		this.saveOrUpdateObject(jizihao);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Jizihao.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Jizihao jizihao = (Jizihao)this.getObjectById(Jizihao.class, id);
		jizihao.setDelFlag(1);
		this.saveObject(jizihao);
	}
}
