package com.jshx.jfzm.web;

import com.google.gson.Gson;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.Struts2Util;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.service.RfxmService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.neusoft.egov.utils.TextUtils;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JfzmAction extends BaseAction {



    @Autowired
    RfxmService rfxmService;
    @Autowired
    XmxxbService xmxxbService;
    @Autowired
    PaymentItemHisService paymentItemHisService;

    @Autowired
    private ZsdwService zsdwService;

    /**
     * 分页信息
     */
    private Pagination pagination;

    String ghxkzbh;
    String jfpzbh;
    String xxbbh;
    String ghxmbh;
    String jsdwmc;
    String gcxmmc;
    String jfhj;
    String hczt;
    String id;

    Rfxm rfxm = new Rfxm();
    Xmxxb xmxxb = new Xmxxb();
    PaymentItemHis paymentItemHis = new PaymentItemHis();



    /**
     * 缴费证明列表
     * @throws Exception
     */
    public void list() throws Exception{
        Map<String, Object> paraMap = new HashMap<String, Object>();

        if(pagination==null)
            pagination = new Pagination(this.getRequest());

        if (!TextUtils.isEmpty(ghxkzbh)){
            paraMap.put("xkzh", "%" + ghxkzbh + "%");
        }

        if(!TextUtils.isEmpty(jfpzbh)) {
            paraMap.put("zslxdbh", "%" + jfpzbh + "%");
        }

        if (!TextUtils.isEmpty(xxbbh)){
            paraMap.put("xxbbh", "%" + xxbbh + "%");
        }

        if (!TextUtils.isEmpty(ghxmbh)){
            paraMap.put("xmbh", "%" + ghxmbh + "%");
        }

        if (!TextUtils.isEmpty(jsdwmc)){
            paraMap.put("jsdw", "%" + jsdwmc + "%");
        }

        if (!TextUtils.isEmpty(gcxmmc)){
            paraMap.put("jsdd", "%" + gcxmmc + "%");
        }

        //TODO 缴费环节、核查状态筛选

        if(!this.getLoginUser().getIsSuperAdmin()){
            String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
            paraMap.put("dwdm", dwdm);
        }

        JsonConfig config = new JsonConfig();
        config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
        Map<String, String> codeMap = new HashMap<String, String>();
        //此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

        config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
//        final String filter = "isCwyz|id|slbh|isfdx|dwmc|xmmc|mjyj|dkxmslh|zsdw|dkmj|csmj|ptyjmj|ptyjje|ptymje|ptymmj|rfyjmj|rfyjje|rfymmj|rfymje|xqyjje|xqymmj|xqymje|xqyjmj|byyjmj|byyjje|byymmj|byymje|zyjje|zymje|warnFlag|accountbankId|lockFlag|xmbzj|zslxdbh|ECN|xmxxb|xmxxb.xxylb|xmxxb.";
//        if (filter != null && filter.length() > 1) {
//            config.setJsonPropertyFilter(new PropertyFilter() {
//                public boolean apply(Object source, String name, Object value) {
//                    if (filter.indexOf(name + "|") != -1)
//                        return false;
//                    else
//                        return true;
//                }
//            });
//        }
        pagination = rfxmService.findByPage(pagination, paraMap);

        convObjectToJson(pagination, config);
    }

    /**
     * 同步缴费证明
     */
    public void sync() {

    }

    /**
     * 打印缴费证明时，查询所需要的数据
     */
    public void queryDetail() {
        rfxm = rfxmService.getById(id);
        xmxxb = xmxxbService.getById(rfxm.getXmxxbId());
        paymentItemHis = paymentItemHisService.getById(rfxm.getPaymentHisId());
        JSONObject jo = new JSONObject();
        jo.put("rfxm",rfxm);
        jo.put("xmxxb",xmxxb);
        jo.put("paymentItemHis",paymentItemHis);
        try {
            this.getResponse().getWriter().write(jo.toString());
            this.getResponse().getWriter().flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Pagination getPagination() {
        return pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public String getGhxkzbh() {
        return ghxkzbh;
    }

    public void setGhxkzbh(String ghxkzbh) {
        this.ghxkzbh = ghxkzbh;
    }

    public String getJfpzbh() {
        return jfpzbh;
    }

    public void setJfpzbh(String jfpzbh) {
        this.jfpzbh = jfpzbh;
    }

    public String getXxbbh() {
        return xxbbh;
    }

    public void setXxbbh(String xxbbh) {
        this.xxbbh = xxbbh;
    }

    public String getGhxmbh() {
        return ghxmbh;
    }

    public void setGhxmbh(String ghxmbh) {
        this.ghxmbh = ghxmbh;
    }

    public String getJsdwmc() {
        return jsdwmc;
    }

    public void setJsdwmc(String jsdwmc) {
        this.jsdwmc = jsdwmc;
    }

    public String getGcxmmc() {
        return gcxmmc;
    }

    public void setGcxmmc(String gcxmmc) {
        this.gcxmmc = gcxmmc;
    }

    public String getJfhj() {
        return jfhj;
    }

    public void setJfhj(String jfhj) {
        this.jfhj = jfhj;
    }

    public String getHczt() {
        return hczt;
    }

    public void setHczt(String hczt) {
        this.hczt = hczt;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Rfxm getRfxm() {
        return rfxm;
    }

    public void setRfxm(Rfxm rfxm) {
        this.rfxm = rfxm;
    }

    public Xmxxb getXmxxb() {
        return xmxxb;
    }

    public void setXmxxb(Xmxxb xmxxb) {
        this.xmxxb = xmxxb;
    }

    public PaymentItemHis getPaymentItemHis() {
        return paymentItemHis;
    }

    public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
        this.paymentItemHis = paymentItemHis;
    }
}
