package com.jshx.hissfhjkb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hissfhjkb.entity.Hissfhjkb;
import com.jshx.hissfhjkb.dao.HissfhjkbDao;

@Component("hissfhjkbDao")
public class HissfhjkbDaoImpl extends BaseDaoImpl implements HissfhjkbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHissfhjkbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHissfhjkb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHissfhjkbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hissfhjkb getById(String id)
	{
		return (Hissfhjkb)this.getObjectById(Hissfhjkb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hissfhjkb hissfhjkb)
	{
		hissfhjkb.setId(null);
		this.saveOrUpdateObject(hissfhjkb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hissfhjkb hissfhjkb)
	{
		this.saveOrUpdateObject(hissfhjkb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hissfhjkb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hissfhjkb hissfhjkb = (Hissfhjkb)this.getObjectById(Hissfhjkb.class, id);
		hissfhjkb.setDelFlag(1);
		this.saveObject(hissfhjkb);
	}
}
