package com.jshx.hishxsfxxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxsfxxb.entity.Hishxsfxxb;
import com.jshx.hishxsfxxb.dao.HishxsfxxbDao;

@Component("hishxsfxxbDao")
public class HishxsfxxbDaoImpl extends BaseDaoImpl implements HishxsfxxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHishxsfxxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHishxsfxxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHishxsfxxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxsfxxb getById(String id)
	{
		return (Hishxsfxxb)this.getObjectById(Hishxsfxxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hishxsfxxb hishxsfxxb)
	{
		hishxsfxxb.setId(null);
		this.saveOrUpdateObject(hishxsfxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hishxsfxxb hishxsfxxb)
	{
		this.saveOrUpdateObject(hishxsfxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hishxsfxxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hishxsfxxb hishxsfxxb = (Hishxsfxxb)this.getObjectById(Hishxsfxxb.class, id);
		hishxsfxxb.setDelFlag(1);
		this.saveObject(hishxsfxxb);
	}

	@Override
	public List<String> findcd(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return this.findListBySqlId("findcd", paraMap);
	}
}
