package com.jshx.fawen.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.dao.FawenAttachDao;
import com.jshx.fawen.entity.FawenAttach;


@Component("fawenAttachDao")
public class FawenAttachDaoImpl extends BaseDaoImpl implements FawenAttachDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findOaAttachByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findOaAttach(Map<String, Object> paraMap){
		return this.findListByHqlId("findOaAttachByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public FawenAttach getById(String id)
	{
		return (FawenAttach)this.getObjectById(FawenAttach.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(FawenAttach oaAttach)
	{
		oaAttach.setId(null);
		//此处处理Blob对象（Blob对象不能直接insert）
		this.saveOrUpdateObject(oaAttach);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(FawenAttach oaAttach)
	{
		this.saveOrUpdateObject(oaAttach);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(FawenAttach.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		FawenAttach oaAttach = (FawenAttach)this.getObjectById(FawenAttach.class, id);
		oaAttach.setDelFlag(1);
		this.saveObject(oaAttach);
	}

	
	/**
	 * 根据模板ID取相应的附件
	 * @param paramsMap
	 * @return
	 */
	
	@Override
	public List<FawenAttach> queryAttachListByTempleId(
			Map<String, String> paramsMap) {
		// TODO Auto-generated method stub
		return this.findListByHqlId("OaAttachDao_queryAttachListByTempleId", paramsMap);
	}
	
	/**
	 * 根据模板ID取相应的附件,及上传人姓名
	 * @param paramsMap
	 * @return
	 */
	
	@Override
	public List<FawenAttach> queryFawenAttachListByTempleId(
			Map<String, String> paramsMap) {
		// TODO Auto-generated method stub
		return this.findListBySqlId("OaAttachDao_queryFawenAttachListByTempleId", paramsMap);
	}
	
	/**
	 * 根据模板ID取相应的附件,及上传人姓名
	 * @param paramsMap
	 * @return
	 */
	
	@Override
	public List<FawenAttach> queryShouwenAttachListByTempleId(
			Map<String, String> paramsMap) {
		// TODO Auto-generated method stub
		return this.findListBySqlId("OaAttachDao_queryShouwenAttachListByTempleId", paramsMap);
	}
	
	
}
