package com.jshx.common.web;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.module.admin.entity.Department;

public class CommonAction extends BaseAction {

	@Autowired() 
	@Qualifier("deptModuleRelService")
//	private DeptModuleRelService deptModuleRelService;
	
	private String currModuleCode;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String excel_Name ;
	
	/**
	 * 模板下载
	 */
	public void downloadTemplate()
	 {
		 String excelName = getExcelNameFromProperty(excel_Name);
	     try
	     {
	         excelName = new String(excelName.getBytes("GBK"), "ISO8859-1");
	     }
	     catch (UnsupportedEncodingException e)
	     {
	         excelName = excel_Name;
	     }
	     getResponse().setContentType("application/csv");
	     getResponse().setCharacterEncoding("UTF-8");
	     getResponse().addHeader("Content-Disposition", "attachment;filename=" + excelName);
	     String dir = this.getRequest().getRealPath("") + File.separator + "WEB-INF" + File.separator + "download"
	             + File.separator + excel_Name;
	     java.io.FileInputStream in = null;
	     OutputStream out = null;
	     try
	     {
	         in = new java.io.FileInputStream(dir);
	         out = this.getResponse().getOutputStream();
	         int t = in.read();
	         while (t != -1)
	         {
	             out.write(t);
	             t = in.read();
	         }
	         in.close();
	         out.flush();
	         out.close();
	     }
	     catch (Exception e)
	     {
	    	 e.printStackTrace();
	     }
	     finally
	     {
	         if (null != in)
	         {
	             try
	             {
	                 in.close();
	             }
	             catch (IOException e)
	             {
	            	 e.printStackTrace();
	             }
	         }
	         if (null != out)
	         {
	             try
	             {
	                 out.close();
	             }
	             catch (IOException e)
	             {
	            	 e.printStackTrace();
	             }
	         }
	     }
	 }
	
	public String getExcelNameFromProperty(String excel_Name) {
		Properties prop = new Properties();
		try {
			// 读取属性文件a.properties
			InputStream in = this.getClass().getClassLoader().getResourceAsStream("com/jshx/common/conf/excel.properties");
			InputStreamReader reader = new InputStreamReader(in,"UTF-8");
			prop.load(reader); // /加载属性列表
			Iterator<String> it = prop.stringPropertyNames().iterator();
			while (it.hasNext()) {
				String key=it.next();
				if(excel_Name.equals(key)){
					return (String)prop.getProperty(key);
				}
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return excel_Name;
	}
	

	public String getExcel_Name() {
		return excel_Name;
	}

	public void setExcel_Name(String excel_Name) {
		this.excel_Name = excel_Name;
	}

	public String getCurrModuleCode() {
		return currModuleCode;
	}

	public void setCurrModuleCode(String currModuleCode) {
		this.currModuleCode = currModuleCode;
	}

	
}
