package com.jshx.cjjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.cjjlb.entity.Cjjlb;
import com.jshx.cjjlb.dao.CjjlbDao;

@Component("cjjlbDao")
public class CjjlbDaoImpl extends BaseDaoImpl implements CjjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findCjjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findCjjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findCjjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Cjjlb getById(String id)
	{
		return (Cjjlb)this.getObjectById(Cjjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Cjjlb cjjlb)
	{
		cjjlb.setId(null);
		this.saveOrUpdateObject(cjjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Cjjlb cjjlb)
	{
		this.saveOrUpdateObject(cjjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Cjjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Cjjlb cjjlb = (Cjjlb)this.getObjectById(Cjjlb.class, id);
		cjjlb.setDelFlag(1);
		this.saveObject(cjjlb);
	}
}
