package com.jshx.account.paymentVoucherHis.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="PAYMENT_VOUCHER_HIS")
public class PaymentVoucherHis extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	/**
	 * 单位代码
	 */
	private String dwdm;
	
	
	/**
	 * 受理编号
	 */
	private String orderId;
	
	/**
	 * 项目名称
	 */
	private String xmmc;
	
	/**
	 * 开票日期
	 */
	private Date printDate;

	/**
	 * 经办人
	 */
	private String operator;

	/**
	 * 使用状态  0:使用 1:作废 2:上传失败
	 */
	private String applyStatus;
	
	/**
	 * 缴销状态 0:未缴销 1：已缴销
	 */
	private String destroyStatus;
	
	/**
	 * 接口返回信息
	 */
	private String message;
	
	/**
	 * 类型 	0：非缓缴项目  1：缓缴项目
	 */
	private String type;

	/**
	 * 票据编码
	 */
	private String voucherCode;

	/**
	 * 缴款人全称
	 */
	private String payerName;
	
	/**
	 * 四位校验码
	 */
	private String validCode;
	
	/**
	 * 关联ID
	 */
	private String relateId;
	
	/**
	 * 执收单位
	 */
	private String zsdw;
	
	/**
	 * 执收单位编码
	 */
	private String zsdwbm;
	
	/**
	 * 缴款类型  0：直接解缴 1：集中汇缴
	 */
	private String payType;
	
	/**
	 * 付款方式 0：现金 1：转账
	 */
	private String payMethod;
	
	/**
	 * 区划码
	 */
	private String qhm;
	
	/**
	 * 收款人全称
	 */
	private String skrqc;
	
	/**
	 * 收款人账户
	 */
	private String skrzh;
	
	/**
	 * 收款人开户行
	 */
	private String skrkhh;
	
	/**
	 * 项目编码
	 */
	private String xmbm;
	
	/**
	 * 收入项目名称
	 */
	private String srxmmc;
	
	/**
	 * 面积
	 */
	private String area;
	
	/**
	 * 金额
	 */
	private String amount;
	
	/**
	 * 备注
	 */
	private String beizhu;
	
	public PaymentVoucherHis(){
	}
	
	public PaymentVoucherHis(String id, String orderId, String amount, Date printDate, String operator, String applyStatus, String voucherCode, String payerName){
this.id = id;

this.orderId = orderId;

this.amount = amount;

this.printDate = printDate;

this.operator = operator;

this.applyStatus = applyStatus;

this.voucherCode = voucherCode;

this.payerName = payerName;
}


	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}
	
	@Column(name="DWDM")
	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}
	
	@Column(name="ORDER_ID")
	public String getOrderId()
	{
		return this.orderId;
	}

	public void setOrderId(String orderId)
	{
		this.orderId = orderId;
	}
	
	@Column(name="XMMC")
	public String getXmmc() {
		return xmmc;
	}

	public void setXmmc(String xmmc) {
		this.xmmc = xmmc;
	}

	@Column(name="AREA")
	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	@Column(name="AMOUNT")
	public String getAmount()
	{
		return this.amount;
	}

	public void setAmount(String amount)
	{
		this.amount = amount;
	}

	@Column(name="PRINT_DATE")
	public Date getPrintDate()
	{
		return this.printDate;
	}

	public void setPrintDate(Date printDate)
	{
		this.printDate = printDate;
	}

	@Column(name="OPERATOR")
	public String getOperator()
	{
		return this.operator;
	}

	public void setOperator(String operator)
	{
		this.operator = operator;
	}

	@Column(name="APPLY_STATUS")
	public String getApplyStatus()
	{
		return this.applyStatus;
	}

	public void setApplyStatus(String applyStatus)
	{
		this.applyStatus = applyStatus;
	}

	@Column(name="DESTROY_STATUS")
	public String getDestroyStatus() {
		return destroyStatus;
	}

	public void setDestroyStatus(String destroyStatus) {
		this.destroyStatus = destroyStatus;
	}

	@Column(name="MESSAGE")
	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Column(name="VOUCHER_CODE")
	public String getVoucherCode()
	{
		return this.voucherCode;
	}

	public void setVoucherCode(String voucherCode)
	{
		this.voucherCode = voucherCode;
	}

	@Column(name="PAYER_NAME")
	public String getPayerName()
	{
		return this.payerName;
	}

	public void setPayerName(String payerName)
	{
		this.payerName = payerName;
	}

	@Column(name="VALID_CODE")
	public String getValidCode() {
		return validCode;
	}

	public void setValidCode(String validCode) {
		this.validCode = validCode;
	}

	@Column(name="RELATE_ID")
	public String getRelateId() {
		return relateId;
	}

	public void setRelateId(String relateId) {
		this.relateId = relateId;
	}

	@Column(name="ZSDW")
	public String getZsdw() {
		return zsdw;
	}

	public void setZsdw(String zsdw) {
		this.zsdw = zsdw;
	}

	@Column(name="ZSDWBM")
	public String getZsdwbm() {
		return zsdwbm;
	}

	public void setZsdwbm(String zsdwbm) {
		this.zsdwbm = zsdwbm;
	}

	@Column(name="QHM")
	public String getQhm() {
		return qhm;
	}

	public void setQhm(String qhm) {
		this.qhm = qhm;
	}

	@Column(name="SKRQC")
	public String getSkrqc() {
		return skrqc;
	}

	public void setSkrqc(String skrqc) {
		this.skrqc = skrqc;
	}

	@Column(name="SKRZH")
	public String getSkrzh() {
		return skrzh;
	}

	public void setSkrzh(String skrzh) {
		this.skrzh = skrzh;
	}

	@Column(name="SKRKHH")
	public String getSkrkhh() {
		return skrkhh;
	}

	public void setSkrkhh(String skrkhh) {
		this.skrkhh = skrkhh;
	}

	@Column(name="TYPE")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name="PAY_TYPE")
	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	@Column(name="PAY_METHOD")
	public String getPayMethod() {
		return payMethod;
	}

	public void setPayMethod(String payMethod) {
		this.payMethod = payMethod;
	}

	@Column(name="XMBM")
	public String getXmbm() {
		return xmbm;
	}

	public void setXmbm(String xmbm) {
		this.xmbm = xmbm;
	}

	@Column(name="SRXMMC")
	public String getSrxmmc() {
		return srxmmc;
	}

	public void setSrxmmc(String srxmmc) {
		this.srxmmc = srxmmc;
	}

	@Column(name="BEIZHU")
	public String getBeizhu() {
		return beizhu;
	}

	public void setBeizhu(String beizhu) {
		this.beizhu = beizhu;
	}


}
