package com.jshx.account.paymentVoucher.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import com.jshx.cktzs.dao.CktzsDao;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.paymentItemPending.dao.PaymentItemPendingDao;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.xmxxb.dao.XmxxbDao;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.yzsjfhc.dao.PaymentVerificationDao;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.paymentItemDelayHis.dao.PaymentItemDelayHisDao;
import com.jshx.paymentItemDelayHis.entity.PaymentItemDelayHis;
import com.jshx.paymentItemHis.dao.PaymentItemHisDao;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.account.paymentVoucher.dao.PaymentVoucherDao;
import com.jshx.account.paymentVoucher.entity.PaymentVoucher;
import com.jshx.account.paymentVoucher.service.PaymentVoucherService;
import com.jshx.account.paymentVoucherHis.dao.PaymentVoucherHisDao;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.billManager.dao.BillManagerDao;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.common.utils.Constant;

@Service("paymentVoucherService")
public class PaymentVoucherServiceImpl extends BaseServiceImpl implements PaymentVoucherService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("xmxxbDao")
	private XmxxbDao xmxxbDao;

	@Autowired() 
	@Qualifier("paymentVoucherDao")
	private PaymentVoucherDao paymentVoucherDao;
	
	@Autowired() 
	private PaymentItemDelayHisDao paymentItemDelayHisDao;
	
	@Autowired() 
	private PaymentItemHisDao paymentItemHisDao;

	@Autowired()
	private PaymentItemPendingDao paymentItemPendingDao;
	
	@Autowired() 
	private PaymentVoucherHisDao paymentVoucherHisDao;

	@Autowired()
	private BillManagerDao billManagerDao;

	@Autowired()
	private CktzsDao cktzsDao;

	@Autowired
	private PaymentVerificationDao paymentVerificationDao;
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentVoucherDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentVoucher getById(String id)
	{
		return paymentVoucherDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentVoucher paymentVoucher)
	{
		paymentVoucherDao.save(paymentVoucher);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentVoucher paymentVoucher)
	{
		paymentVoucherDao.update(paymentVoucher);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentVoucherDao.findPaymentVoucher(paraMap);
		
		paymentVoucherDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    paymentVoucherDao.deleteWithFlag(id);
			}
		}
	}
	
	@Transactional
	public void add(PaymentVoucherHis paymentVoucherHis, String response,  String isDelay, String id)
	{
		if("0".equals(isDelay)){//是否缓缴项目
			PaymentItemDelayHis paymentItemDelayHis = paymentItemDelayHisDao.getById(id);
			if(null == paymentItemDelayHis){
				throw new BasalException(BasalException.ERROR, "缓缴项目信息不存在！");
			}else{
				paymentItemDelayHis.setNonTaxStatus(Constant.NON_TAX_STATUS_1);
				paymentItemDelayHisDao.update(paymentItemDelayHis);//更新此缓缴项目票据状态
				paymentVoucherHis.setDwdm(paymentItemDelayHis.getDwdm());
				paymentVoucherHis.setOrderId(paymentItemDelayHis.getSlbh());
				paymentVoucherHis.setRelateId(paymentItemDelayHis.getId());
				paymentVoucherHis.setType("1");
			}
		}else{
			PaymentItemHis paymentItemHis = paymentItemHisDao.getById(id);
			if(null == paymentItemHis){
				throw new BasalException(BasalException.ERROR, "项目信息不存在！");
			}else{
				paymentItemHis.setNonTaxStatus(Constant.NON_TAX_STATUS_1);
				paymentItemHisDao.update(paymentItemHis);//更新此项目票据状态
				paymentVoucherHis.setDwdm(paymentItemHis.getDwdm());
				paymentVoucherHis.setOrderId(paymentItemHis.getSlbh());
				paymentVoucherHis.setRelateId(paymentItemHis.getId());
				paymentVoucherHis.setType("0");
			}
		}
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("no", paymentVoucherHis.getVoucherCode());
		Indeticur indeticur = billManagerDao.findIndeticurByNo(paraMap);
		indeticur.setIsprint(Constant.VOUCHER_USED_STATUS_1);
//		indeticur.setPjbz(pjbz);
		billManagerDao.update(indeticur);//更新票据状态
		paymentVoucherHisDao.save(paymentVoucherHis);
	}
	@Transactional
	public void addtb(PaymentVoucherHis paymentVoucherHis, String response,  String isDelay, String id,String pjbz)
	{
			PaymentItemHis paymentItemHis = paymentItemHisDao.getById(id);
			PaymentVoucherHis pay=new PaymentVoucherHis();
			pay.setAmount(paymentVoucherHis.getAmount());
			pay.setApplyStatus(paymentVoucherHis.getApplyStatus());
			pay.setArea(paymentVoucherHis.getArea());
			pay.setCreateTime(paymentVoucherHis.getCreateTime());
			pay.setCreateUserID(paymentVoucherHis.getCreateUserID());
			pay.setDelFlag(paymentVoucherHis.getDelFlag());
			pay.setDeptId(paymentVoucherHis.getDeptId());
			pay.setDestroyStatus(paymentVoucherHis.getDestroyStatus());
			pay.setDwdm(paymentVoucherHis.getDwdm());
			pay.setId(paymentVoucherHis.getId());
			pay.setMessage(paymentVoucherHis.getMessage());
			pay.setOperator(paymentVoucherHis.getOperator());
			pay.setOrderId(paymentVoucherHis.getOrderId());
            pay.setPayerName(paymentVoucherHis.getPayerName());
			pay.setPayMethod(paymentVoucherHis.getPayMethod());
			pay.setPayType(paymentVoucherHis.getPayType());
			pay.setPrintDate(paymentVoucherHis.getPrintDate());
			pay.setQhm(paymentVoucherHis.getQhm());
			pay.setRelateId(paymentVoucherHis.getRelateId());
			pay.setSkrkhh(paymentVoucherHis.getSkrkhh());
            pay.setSkrqc(paymentVoucherHis.getSkrqc());
            pay.setSkrzh(paymentVoucherHis.getSkrzh());
            pay.setSrxmmc(paymentVoucherHis.getSrxmmc());
            pay.setType(paymentVoucherHis.getType());
            pay.setValidCode(paymentVoucherHis.getValidCode());
            pay.setVoucherCode(paymentVoucherHis.getVoucherCode());
            pay.setXmbm(paymentVoucherHis.getXmbm());
            pay.setXmmc(paymentVoucherHis.getXmmc());
            pay.setZsdw(paymentVoucherHis.getZsdw());
            pay.setZsdwbm(paymentVoucherHis.getZsdwbm());
			
			if(null == paymentItemHis){
				throw new BasalException(BasalException.ERROR, "项目信息不存在！");
			}else{
				paymentItemHis.setNonTaxStatus(Constant.NON_TAX_STATUS_1);
				paymentItemHisDao.update(paymentItemHis);//更新此项目票据状态
				pay.setDwdm(paymentItemHis.getDwdm());
				pay.setOrderId(paymentItemHis.getSlbh());
				pay.setRelateId(paymentItemHis.getId());
				pay.setType("0");
			}
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("no", pay.getVoucherCode());
		Indeticur indeticur = billManagerDao.findIndeticurByNo(paraMap);
		indeticur.setIsprint(Constant.VOUCHER_USED_STATUS_1);
		indeticur.setPjbz(pjbz);
		billManagerDao.update(indeticur);//更新票据状态`
		paymentVoucherHisDao.save(pay);

	}

	@Transactional
	public void addYzstb(PaymentVoucherHis paymentVoucherHis, String response, String isDelay, String slbh, String pjbz, PaymentItemPending paymentItemPending,Xmxxb xmxxb1)
	{
		try {
			//更新项目信息表
			xmxxbDao.update(xmxxb1);

			//更新催款通知书表
			Cktzs cktzs = new Cktzs();
			Map<String,Object> paramMap1 = new HashMap<>();
			paramMap1.put("slbh",slbh);
			List<Cktzs> cktzsList = cktzsDao.findCktzs(paramMap1);
			if(CollectionUtils.isNotEmpty(cktzsList)){
				cktzs = cktzsList.get(0);
				cktzs.setIsjk("1");
			}

			//插入已缴款库
			Map<String, Object> paramMap = new HashMap<>();
			PaymentItemHis paymentItemHis1 = new PaymentItemHis();
			paramMap.put("slbh", slbh);
			List<PaymentItemHis> paymentItemHisList = paymentItemHisDao.findPaymentItemHis(paramMap);
			if (CollectionUtils.isNotEmpty(paymentItemHisList)) {
				paymentItemHis1 = paymentItemHisList.get(0);
			}
			PaymentVoucherHis pay = new PaymentVoucherHis();
			pay.setAmount(paymentVoucherHis.getAmount());
			pay.setApplyStatus(paymentVoucherHis.getApplyStatus());
			pay.setArea(paymentVoucherHis.getArea());
			pay.setCreateTime(paymentVoucherHis.getCreateTime());
			pay.setCreateUserID(paymentVoucherHis.getCreateUserID());
			pay.setDelFlag(paymentVoucherHis.getDelFlag());
			pay.setDeptId(paymentVoucherHis.getDeptId());
			pay.setDestroyStatus(paymentVoucherHis.getDestroyStatus());
			pay.setDwdm(paymentVoucherHis.getDwdm());
			pay.setId(paymentVoucherHis.getId());
			pay.setMessage(paymentVoucherHis.getMessage());
			pay.setOperator(paymentVoucherHis.getOperator());
			pay.setOrderId(paymentVoucherHis.getOrderId());
			pay.setPayerName(paymentVoucherHis.getPayerName());
			pay.setPayMethod(paymentVoucherHis.getPayMethod());
			pay.setPayType(paymentVoucherHis.getPayType());
			pay.setPrintDate(paymentVoucherHis.getPrintDate());
			pay.setQhm(paymentVoucherHis.getQhm());
			pay.setRelateId(paymentVoucherHis.getRelateId());
			pay.setSkrkhh(paymentVoucherHis.getSkrkhh());
			pay.setSkrqc(paymentVoucherHis.getSkrqc());
			pay.setSkrzh(paymentVoucherHis.getSkrzh());
			pay.setSrxmmc(paymentVoucherHis.getSrxmmc());
			pay.setType(paymentVoucherHis.getType());
			pay.setValidCode(paymentVoucherHis.getValidCode());
			pay.setVoucherCode(paymentVoucherHis.getVoucherCode());
			pay.setXmbm(paymentVoucherHis.getXmbm());
			pay.setXmmc(paymentVoucherHis.getXmmc());
			pay.setZsdw(paymentVoucherHis.getZsdw());
			pay.setZsdwbm(paymentVoucherHis.getZsdwbm());

			if (null == paymentItemHis1) {
				throw new BasalException(BasalException.ERROR, "项目信息不存在！");
			} else {
				paymentItemHis1.setNonTaxStatus(Constant.NON_TAX_STATUS_1);
				paymentItemHisDao.update(paymentItemHis1);//更新此项目票据状态
				pay.setDwdm(paymentItemHis1.getDwdm());
				pay.setOrderId(paymentItemHis1.getSlbh());
				pay.setRelateId(paymentItemHis1.getId());
				pay.setType("0");
			}
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("no",pay.getVoucherCode());
			Indeticur indeticur = billManagerDao.findIndeticurByNo(paraMap);
			indeticur.setIsprint(Constant.VOUCHER_USED_STATUS_1);
			indeticur.setPjbz(pjbz);
			indeticur.setZsdw(paymentVoucherHis.getZsdw());
			billManagerDao.update(indeticur);//更新票据状态
			paymentVoucherHisDao.save(pay);
			//从代缴款库中移除该项目
			paymentItemPendingDao.delete(paymentItemPending.getId());
			cktzsDao.update(cktzs);
		}catch(Exception e){
			e.printStackTrace();
		}

	}
	
	@Transactional
	public void disable(PaymentVoucherHis paymentVoucherHis, String response)
	{
		if("1".equals(response)){//作废成功后可重新上传发票数据
			if("0".equals(paymentVoucherHis.getType())){
				PaymentItemHis paymentItemHis = paymentItemHisDao.getById(paymentVoucherHis.getRelateId());
				paymentItemHis.setNonTaxStatus(Constant.NON_TAX_STATUS_0);
				paymentItemHisDao.update(paymentItemHis);
			}else if("1".equals(paymentVoucherHis.getType())){
				PaymentItemDelayHis paymentItemDelayHis = paymentItemDelayHisDao.getById(paymentVoucherHis.getRelateId());
				paymentItemDelayHis.setNonTaxStatus(Constant.NON_TAX_STATUS_0);
				paymentItemDelayHisDao.update(paymentItemDelayHis);
			}
		}
		paymentVoucherHisDao.update(paymentVoucherHis);
	}
	
	@Transactional
	public void reUpload(PaymentVoucherHis paymentVoucherHis, String response)
	{
		if("1".equals(response)){
			if("0".equals(paymentVoucherHis.getType())){
				PaymentItemHis paymentItemHis = paymentItemHisDao.getById(paymentVoucherHis.getRelateId());
				paymentItemHis.setNonTaxStatus(Constant.NON_TAX_STATUS_1);
				paymentItemHisDao.update(paymentItemHis);
			}else if("1".equals(paymentVoucherHis.getType())){
				PaymentItemDelayHis paymentItemDelayHis = paymentItemDelayHisDao.getById(paymentVoucherHis.getRelateId());
				paymentItemDelayHis.setNonTaxStatus(Constant.NON_TAX_STATUS_1);
				paymentItemDelayHisDao.update(paymentItemDelayHis);
			}
		}
		paymentVoucherHisDao.update(paymentVoucherHis);
	}
}
