/**
 * 
 */
package com.jshx.activiti.delay;

import org.activiti.bpmn.model.DelayProperty;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.activiti.engine.task.Task;

import com.jshx.activiti.service.ActivitiService;
import com.jshx.activiti.service.NotificationService;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.utils.SpringContextHolder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 超时告警功能的实现
 * 超时告警功能需要设置dueDate属性，且该属性应当采用时间周期表达方式，如P1Y3M6DT9H3M16S
 * 
 * @author chensy
 * @version 2016年6月23日 上午11:18:03
 */
@Component
@Lazy(false)
public class DelayReport extends BaseAction {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1953541342002056956L;

	private static final String WARNINGBEFORE = "超时前告警";
	private static final String WARNINGAFTER = "超时后通知";

	@Autowired
	protected transient TaskService taskService;

	@Autowired
	protected transient ActivitiService activitiService;
	
	@Autowired
    protected transient RepositoryService repositoryService;
	  @Autowired
	    protected RuntimeService runtimeService;

	private static final Logger delaySacnnerLogger = LoggerFactory.getLogger(DelayReport.class);

	private long currentTime = 0;
	private ArrayList<DelayProperty> delayProperties;
	private ArrayList<String> delayTaskProcIds;
	private ArrayList<Date> taskDueDates;
	//private ArrayList<Long> taskCreatTimes;
	private ArrayList<String> taskIds;

	private void sendMessage(DelayInfo di) {
       System.out.println("超时");
       System.out.println(di.getTaskInstanceId()+" "+di.getTaskId());
       Task task  = taskService.createTaskQuery().taskId(di.getTaskId()).singleResult();
       task.getName();
       ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
       processInstance.getProcessDefinitionName();
       System.out.println( task.getName()+" "+processInstance.getProcessDefinitionName());
//       taskService.
//       repositoryService.createProcessDefinitionQuery().processDefinitionId(di.getTaskId().getProcessDefinitionId()).singleResult().getName());
		//NotificationService notificationService = SpringContextHolder.getBean("activitiMailService");
//		NotificationService notificationService = SpringContextHolder.getBean(di.getdImpClass());
//		if (notificationService != null) {
//			delaySacnnerLogger.warn(
//					new Date() + ": 发送超时告警邮件：流程定义{" + di.getTaskInstanceId() + "},超时任务：{" + di.getTaskId() + "};");
//			notificationService.sendNotification(di.getTaskInstanceId(), di.getTaskId(), null);
//		}

	}

	private void sendMessageBefore(DelayInfo di, long dueDate, long currentTime) {

		//long compareTime = dueDate - di.getdTime() - currentTime;
		long compareTime = currentTime - dueDate + di.getdTime();

		for (int i = 0; i < di.getdRound(); i++) {
			if (compareTime >= i * di.getdCycle() && compareTime < i * di.getdCycle() + 600000) {
				sendMessage(di);
			}
		}

	}

	private void sendMessageAfter(DelayInfo di, long dueDate, long currentTime) {

		long compareTime = currentTime - di.getdTime() - dueDate;

		for (int i = 0; i < di.getdRound(); i++) {
			if (compareTime >= i * di.getdCycle() && compareTime < i * di.getdCycle() + 600000) {
				sendMessage(di);
			}
		}

	}

	/**
	 * 定时扫描UserTask的超时属性，若超时则发送超时信息
	 * 
	 * @return doJob()
	 * @throws Exception 
	 */
	//@Scheduled(cron = "0 0/2 * * * ?")
	public void doJob() throws Exception{

		currentTime = System.currentTimeMillis();
		//currentTime = currentTime - (currentTime % 120000);
		currentTime = currentTime - (currentTime % 600000);// 取最接近当前时间的整十分钟时间（与调度间隔时间相隔）

		List<Task> taskList = taskService.createTaskQuery().list();

		delayProperties = new ArrayList<>();
		delayTaskProcIds = new ArrayList<>();
		taskDueDates = new ArrayList<>();
		taskIds = new ArrayList<>();

		for (Task task : taskList) {
			String processInstanceId = task.getProcessInstanceId();
			String taskDefKey = task.getTaskDefinitionKey();
			List<DelayProperty> taskDelayProperties = activitiService.getTaskDelayProperty(processInstanceId,
					taskDefKey);
			for (DelayProperty taskDP : taskDelayProperties) {
				//如果没有签收，则不将任务计入已开始任务;如果没有设置dueDate则不计入超时告警任务
				if( task.getAssignee()==null || task.getAssignee().isEmpty() || null == task.getDueDate())
					continue;
				delayProperties.add(taskDP);
				delayTaskProcIds.add(processInstanceId);
				taskIds.add(task.getId());
				taskDueDates.add(task.getDueDate());				
			}
		}

		for (int i = 0; i < delayProperties.size(); i++) {
			DelayInfo di = new DelayInfo(delayProperties.get(i));
			
			if (taskDueDates.get(i) == null) {
				delaySacnnerLogger.warn(new Date() + "无法发送超时告警邮件，未设置dueDate属性;");
				continue;
			}			

			if (di.getdType().equals(WARNINGBEFORE) && di.isCorrectInfo()) {
				di.setTaskInstanceId(delayTaskProcIds.get(i));
				di.setTaskId(taskIds.get(i));
				sendMessageBefore(di, taskDueDates.get(i).getTime(), currentTime);
			} else if (di.getdType().equals(WARNINGAFTER) && di.isCorrectInfo()) {
				di.setTaskInstanceId(delayTaskProcIds.get(i));
				di.setTaskId(taskIds.get(i));
				sendMessageAfter(di, taskDueDates.get(i).getTime(), currentTime);
			}
		}

	}

}
