<%@page language="java" pageEncoding="UTF-8" isELIgnored="false" %>
<%@include file="/common/header.jsp" %>
<%@taglib prefix="activiti" uri="/activiti/tags" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>台账复核</title>
    <%@include file="/common/jsLib.jsp" %>
    <script>
        function submitTask(outcome) {
            $.ajax({
                url: "submit_tzfh.action",
                type: 'post',
                dataType: 'json',
                async: false,
                data: {
                	outcome : outcome,
                	comment : $("#comment").val(),
                    taskId : "${taskId}"
                },
                error: function () {
                    $.messager.alert('错误', '提交出错！');
                },
                success: function (data) {
                    if (data.result) {
                        $.messager.alert('提示', '办理成功！', "info", function(){
                        	 top.refreshTab("待办任务");
                             top.closeCurrTab1('台账处理工作流');
                             top.closeCurrTab();
                        });
                        $('.panel-tool-close').hide();
                    } else {
                        $.messager.alert('错误', '办理时出错！');
                    }
                }
            });

        }
    </script>

</head>

<body validform="true">
<div class="page_dialog">
    <div class="inner6px">
        <div class="cell">
            <table width="100%">
                <tr>
					<td colspan="6" height="100px" style="text-align:center">项目信息</td>
				</tr>
            	<tr>
            		<th width="15%">建筑单位名称</th>
					<td colspan="3">${paymentItemDelay.dwmc}</td>
				</tr>
				<tr>
					<th width="15%">工程项目名称</th>
					<td colspan="3">${paymentItemDelay.xmmc}</td>
				</tr>
				<tr>
					<th width="15%">受理编号/档案号</th>
					<td width="35%">${paymentItemDelay.slbh}</td>
					<th width="15%">总建筑面积</th>
					<td width="35%">${paymentItemDelay.csmj}</td>
				</tr>
				<tr>
					<th width="15%">缓缴款初始余额（元）</th>
					<td width="35%"><fmt:formatNumber value="${paymentItemDelay.hjje}" pattern="#,##0.00#"/></td>
					<th width="15%">缓缴余额（元）</th>
					<td width="35%"><fmt:formatNumber value="${paymentItemDelay.hjye}" pattern="#,##0.00#"/></td>
				</tr>
				<tr>
					<td colspan="6" height="100px" style="text-align:center">办理信息</td>
				</tr>
				<tr>
					<th width="15%">本次核销金额（元）</th>
					<td width="35%"><fmt:formatNumber value="${paymentItemDelayFree.freeAmount}" pattern="#,##0.00#"/></td>
					<th width="15%">登记文号</th>
					<td width="35%">${paymentItemDelayFree.registNo}</td>
				</tr>
				<tr>
					<th width="15%">经办人</th>
					<td width="35%">${paymentItemDelayFree.dealUser.displayName}</td>
					<th width="15%">经办时间</th>
					<td width="35%"><fmt:formatDate type='both' value='${paymentItemDelayFree.createTime}' /></td>
				</tr>
				<tr>
					<th width="15%">经办意见</th>
					<td colspan="3">${paymentItemDelayFree.operatorComment}</td>
				</tr>
				<tr>
					<th width="15%">核销依据</th>
					<td colspan="3">${paymentItemDelayFree.remark}</td>
				</tr>
            </table>
            <div style="padding-top: 1%">
               <table width="100%">
                   <tr>
                       <th width="15%">复核意见</th>
                       <td width="35%"><textarea id="comment" style="width: 80%"></textarea></td>
                   </tr>
                   <tr>
                       <td colspan="2" height="100px" style="text-align:center">
                           <a href="javascript:submitTask('通过')" class="btn_01"><b></b>办理</a>&nbsp;
                           <a href="javascript:submitTask('驳回')" class="btn_01"><b></b>退回</a>&nbsp;
                           <%-- <s:if test="#outcomeList!=null && #outcomeList.size()>0">
                               <s:iterator value="#outcomeList">
                                   <a href="javascript:submitTask('<s:property/>')" class="btn_01"
                                     ><s:property/><b></b></a>&nbsp;
                               </s:iterator>
                           </s:if> --%>
                       </td>
                   </tr>
               </table>
            </div>
        </div>
    </div>
</div>
</body>
</html>
