<%@page language="java" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/common/header.jsp"%>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>银行到账管理</title>
    <%@include file="/common/jsLib.jsp"%>
	<script>
        function addNew(){
        	var dt=new Date();
            createSimpleWindow("win_accountBank","添加银行到账","${ctx}/jsp/accountBank/accountBankInitEdit.action?flag=add&dt="+dt.getTime(),800,250);
        }
        function edit(row_Id){
        	var dt=new Date();
            createSimpleWindow("win_accountBank","附件后补","${ctx}/jsp/accountBank/accountBankInitEdit.action?flag=mod&accountBank.id="+row_Id+"&dt="+dt.getTime(),500,200);
        	
        }
        function view(row_Id){
        	var dt=new Date();
            createSimpleWindow("win_accountBank","查看银行到账","${ctx}/jsp/accountBank/accountBankView.action?accountBank.id="+row_Id+"&dt="+dt.getTime(),800,250);
        	
        }
        function reloadDate(){
            $('#pagination').datagrid('clearSelections');
        	search_accountBank();
        }
        function del(id_selected){
        	// var rows = $('#pagination').datagrid('getSelections');
            // var ids = "";
			// for(var i=0;i<rows.length;i++){
			// 	ids += rows[i].id+"|";
			// }
			// if(rows.length<1){
			//     $.messager.alert('提示','至少选择一项删除！');
			// }else{
			    $.messager.confirm("删除","确定要删除吗?",function(result){
			        if(result){
		                $.ajax({
		                	url : "accountBankDel.action",
		                	type: 'post',
		                    dataType: 'json',
		                    async : false,
		                    data:{ 
		                    	ids : id_selected
		                    },
		                    error: function(){
		                    	$.messager.alert('错误','删除时出错！');
		                    },
		                    success: function(data){
		                        if(data.result){
		                        	$.messager.alert('提示','删除成功！');
		                        	search_accountBank();
		                        }else{
		                        	$.messager.alert('错误','删除时出错！');
		                        }
		                    }
		                });
			        }
			    });
			// }
        }
        function search_accountBank(){
        	var queryParams = {
				"accountBank.developUnit": $("#developUnit").val(),
				"queryArrivalTimeStart": $("#queryArrivalTimeStart").val(),
				"queryArrivalTimeEnd": $("#queryArrivalTimeEnd").val(),
				"accountBank.hasInvoice":$("#hasInvoice").val(),
				"accountBank.status":$("#status").val()
			};        	
        	$('#pagination').datagrid('options').queryParams = queryParams;
        	$('#pagination').datagrid('clearSelections');
        	$("#pagination").datagrid('load'); 
        }
        
        $(function(){
        	$('#pagination').datagrid($.extend(window.dg_cm_pp,{
				title:'银行到账列表',
				url:'accountBankQuery.action',
				queryParams:{
					"accountBank.developUnit": $("#developUnit").val(),
					"queryArrivalTimeStart": $("#queryArrivalTimeStart").val(),
					"queryArrivalTimeEnd": $("#queryArrivalTimeEnd").val(),
					"accountBank.hasInvoice":$("#hasInvoice").val(),
					"accountBank.status":$("#status").val()
				},
				// frozenColumns:[[
				//     {field:'id',checkbox:true}
				// ]],
				singleSelect: true,
				columns:[[
					{field:'op',title:'操作',width:100,formatter:function(value,rec){
                            if('1'==rec.status)
							{
                                if("1"==rec.hasInvoice)
                                    return "<a class='btn_01_mini' onclick=view('"+rec.id+"') >查看<b></b></a>&nbsp;<a class='btn_01_mini' onclick=edit('"+rec.id+"')>附件后补<b></b></a>&nbsp;"
                                else
                                    return "<a class='btn_01_mini' onclick=view('"+rec.id+"') >查看<b></b></a>&nbsp;"
							}
                            else if('0'==rec.status)
							{
                                if("1"==rec.hasInvoice)
                                    return "<a class='btn_01_mini' onclick=view('"+rec.id+"') >查看<b></b></a>&nbsp;<a class='btn_01_mini' onclick=edit('"+rec.id+"')>附件后补<b></b></a>&nbsp;<a class='btn_01_mini' onclick=del('"+rec.id+"')>删除<b></b></a>&nbsp;"
                                else
                                    return "<a class='btn_01_mini' onclick=view('"+rec.id+"') >查看<b></b></a>&nbsp;<a class='btn_01_mini' onclick=del('"+rec.id+"')>删除<b></b></a>&nbsp;"
							}


					}},
				    {field:'developUnit',title:'建设单位',width:100},
					{field:'amount',title:'金额',width:100,formatter: function (value, row, index){
						   if (row != null) {
					           return (parseFloat(value).toFixed(2) + '').replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,');
					     }
						
					}},
					{field:'arrivalTime',title:'到账时间',width:100},
					{field:'hasInvoice',title:'有无凭证',width:100,formatter:function(value,rec){
						if('0'==rec.hasInvoice)
							return "有";
						else if('1'==rec.hasInvoice)
							return "无";
					}},
					{field:'status',title:'确认状态',width:100,formatter:function(value,rec){
						if('0'==rec.status)
							return "未确认";
						else if('1'==rec.status)
							return "已确认";
					}}
				]],
				toolbar:[{
					id:'btnadd',
					text:'添加',
					iconCls:'icon-add',
					handler:function(){
						addNew();
					}
				}
                    // ,{
                    //     id:'btncut',
                    //     text:'删除',
                    //     iconCls:'icon-remove',
                    //     handler:function(){
                    //         del();
                    //     }
                    // }
				]
			}));
		});

        
    </script>
</head>
<body>
    <div class="page_content">
	
	    <div class="box_01 submitdata">
		<div class="inner12px">
			<div class="cell boxBmargin12">
			<table width="100%">
				<tr>
					<th width="15%">建设单位</th>
					<td width="35%">
						<input name="accountBank.developUnit" id="developUnit" value="${accountBank.developUnit}" type="text">
					</td>
					<th width="15%">到账时间</th>
					<td width="35%">
						<input name="queryArrivalTimeStart" id="queryArrivalTimeStart" style="width: 140px"
							value="<fmt:formatDate type='both' value='${queryArrivalTimeStart}' />"
							type="text" class="Wdate"
							onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})">
						至
						<input name="queryArrivalTimeEnd" id="queryArrivalTimeEnd" style="width: 140px"
							value="<fmt:formatDate type='both' value='${queryArrivalTimeEnd}' />"
							type="text" class="Wdate"
							onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})">
					</td>
				</tr>
				<tr>
					<th width="15%">有无凭证</th>
					<td width="35% ">
						<cus:SelectOneTag property="accountBank.hasInvoice" id="hasInvoice" defaultText='请选择' codeName="有无凭证" value="${accountBank.hasInvoice}" style="width: 136px;" />
					</td>
					<th width="15%">确认状态</th>
					<td width="35%">
						<cus:SelectOneTag property="accountBank.status" id="status" codeName="财务确认状态" value="${accountBank.status}" style="width: 136px;" />
					</td>
				</tr>
				<tr>
					<td colspan="4" align="center">
						<a href="###" class="btn_01" onclick="search_accountBank()" >查询<b></b></a>&nbsp;
						<a href="###" class="btn_01" onclick="clear_form(document.myform);" >清空<b></b></a>&nbsp;				
					</td>
				</tr>
			</table>
		</div>
		
		<div id="pagination" >
		</div>
		</div>
		</div>
	</div>
</body>
</html>
