(function(){module("公式解析",{setUp:function(){},teardown:function(){}});test("公式调用FunctionCall",function(){var fc=new FR.FunctionCall("abs",[12.3],new FR.CAL());equal(fc.eval(),new FR.FunctionCall("ABS",[12.3],new FR.CAL()).eval(),"公式名不区分大小写");equal(fc.eval(),new FR.FunctionCall("abs",[-12.3]).eval(),"没有指定Cal的话new一个")});test("表达式-AddExpression",function(){var ca=new FR.CAL();equal(new FR.AddExpression(["+"],[3,4,5],ca).eval(),FR.WE.ERROR_NAME,"参数个数不正确时返回错误值");equal(new FR.AddExpression(["+","+"],[3,4,5],ca).eval(),12,"计算正确");
equal(new FR.AddExpression(["+","-"],[3,4,5],ca).eval(),2,"减号计算正确");equal(new FR.AddExpression(["+","+"],[3,4,-5],ca).eval(),2,"负数计算正确")});test("表达式-MultiExpression",function(){var ca=new FR.CAL();equal(new FR.MultiExpression(["*","*"],[3,4,5],ca).eval(),60,"计算正确");equal(new FR.MultiExpression(["*","/"],[3,4,5],ca).eval(),2.4,"除号计算正确");equal(new FR.MultiExpression(["*","*"],[3,4,-5],ca).eval(),-60,"负数计算正确")});test("表达式-PowerExpression",function(){var ca=new FR.CAL();equal(new FR.PowerExpression(["^"],[2,3],ca).eval(),8,"计算正确");
equal(new FR.PowerExpression(["^"],[2,-3],ca).eval(),0.125,"计算正确")});test("表达式-RelationExpression",function(){var ca=new FR.CAL();equal(new FR.RelationExpression([">"],[2,1],ca).eval(),true,"计算正确");equal(new FR.RelationExpression(["="],[2,2],ca).eval(),true,"单等号计算正确");equal(new FR.RelationExpression(["="],[2,2],ca).eval(),true,"双等号计算正确");equal(new FR.RelationExpression(["!="],[2,3],ca).eval(),true,"不等号计算正确")});test("表达式-ConditionalOrExpression",function(){var ca=new FR.CAL();equal(new FR.ConditionalOrExpression(["||"],[false,true],ca).eval(),true,"计算正确")
});test("表达式-ConditionalAndExpression",function(){var ca=new FR.CAL();equal(new FR.ConditionalAndExpression(["&&"],[false,true],ca).eval(),false,"计算正确")});test("表达式节点-NumberNode",function(){var ca=new FR.CAL();equal(new FR.NumberNode("2").eval(),2,"计算正确");equal(new FR.NumberNode("2.3").eval(),2.3,"计算正确")});test("表达式节点-StringNode",function(){var ca=new FR.CAL();equal(new FR.StringNode("2").eval(),"2","计算正确");equal(new FR.StringNode("'str'").eval(),"str","计算正确");equal(new FR.StringNode('"str"').eval(),"str","计算正确")
});test("表达式节点-ParameterNode",function(){var ca=new FR.CAL();ca.setParameter("p1","华东");equal(new FR.ParameterNode("p1",ca).eval(),"华东","计算正确")});test("表达式节点-ColumnRowNode",function(){var ca=new FR.CAL();ca.setColumnRowValue("A1",2);ca.setColumnRowValue("b2","sdf");equal(new FR.ColumnRowNode("A1",ca).eval(),2,"计算正确");equal(new FR.ColumnRowNode("B2",ca).eval(),"sdf","兼容大小写写法")});test("表达式节点-ArrayNode",function(){var ca=new FR.CAL();ok(FR.equals(new FR.ArrayNode("1,2,3",ca).eval(),[1,2,3]),"计算正确");
ok(FR.equals(new FR.ArrayNode("1,-2,3",ca).eval(),[1,-2,3]),"带负号计算正确");ok(FR.equals(new FR.ArrayNode("'1',2,3",ca).eval(),["1",2,3]),"数字字符串区分开")});test("表达式节点-BooleanNode",function(){var ca=new FR.CAL();equal(new FR.BooleanNode("TRUE",ca).eval(),true,"计算正确");equal(new FR.BooleanNode("false",ca).eval(),false,"兼容大小写写法")});test("公式解析方法-removeSpace",function(){var str=["1 + 2 * 3 / 4 + len('sdf', 2)"];var res=["1+2*3/4+len('sdf',2)"];for(var i=0;i<str.length;i++){equal(FR.WE.removeSpace(str[i]),res[i],"解析"+str[i]+"正确")
}});test("公式解析方法-findMatchQuote",function(){var str=['"abc123"',"'abc123'","\"abc123'er'\""];var res=[7,7,11];for(var i=0;i<str.length;i++){equal(FR.WE.findMatchQuote(str[i]),res[i],"解析"+str[i]+"正确")}});test("公式解析方法-findMatchParentheses",function(){var str=["('sdf', 2)","['sdf', 2]","('sdf', if(true, 1, 2)) + 123","('sdf', if(true, 'aa)))', 2))asdf"];var res=[9,9,22,28];for(var i=0;i<str.length;i++){equal(FR.WE.findMatchParentheses(str[i]),res[i],"解析"+str[i]+"正确")}});test("公式解析方法-splitArgs",function(){var str=["1,2,3","[a,b,c],bb,cc","[a,b,c],'sdf,,,',cc"];
var res=[["1","2","3"],["[a,b,c]","bb","cc"],["[a,b,c]","'sdf,,,'","cc"]];for(var i=0;i<str.length;i++){ok(FR.equals(FR.WE.splitArgs(str[i]),res[i]),"解析"+str[i]+"正确")}});test("公式解析方法-getRelatedColumnRow",function(){var str=["a1+123","1 + B1 - ab12","1 + B1 - 'ab12'"];var res=[["A1"],["B1","AB12"],["B1"]];for(var i=0;i<str.length;i++){ok(FR.equals(FR.WE.getRelatedColumnRow(str[i]),res[i]),"解析"+str[i]+"正确")}});test("公式解析方法-checkInQuoteArea",function(){var str=["a'sdf,,,', cc","a'sdf,,,', cc","a'sdf,,,', cc","a'sdf,,,', cc","a'sdf,,,', cc","a'sdf,,,', cc"];
var pos=[0,1,2,3,8,9];var res=[false,false,true,true,true,false];for(var i=0;i<str.length;i++){equal(FR.WE.checkInQuoteArea(str[i],pos[i]),res[i],"解析"+str[i]+"正确")}})})();