/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.layout;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableLayout
extends GridBagLayout {
    public static final String NO_RESIZE = "* * 1 1 (0, 0) [0, 0, 0, 0] {0.0, 0.0}";
    public static final String RESIZE_WIDTH = "* * 1 1 (0, 0) [0, 0, 0, 0] {1.0, 0.0} w";
    public static final String RESIZE_HEIGHT = "* * 1 1 (0, 0) [0, 0, 0, 0] {0.0, 1.0} h";
    public static final String RESIZE_BOTH = "* * 1 1 (0, 0) [0, 0, 0, 0] {1.0, 1.0} wh";
    public static final String LEFT = "0 * [5 15 5 15] r";
    public static final String RIGHT = "1 * [5 15 5 15] lw";
    public static final String VERY_LEFT = "0 * [5 0 5 15] r";
    public static final String VERY_RIGHT = "1 * [5 15 5 0] lw";
    public static final String FULL = "0 * * 1 [5 15 5 15] w";
    public static final String COLUMN = "0 * wt";
    public static final String COLUMN_FILL = "0 * wh";
    private GridBagConstraints defaults;

    public TableLayout() {
        this(NO_RESIZE);
    }

    public TableLayout(String string) {
        this.defaults = this.getGridBagConstraints(string);
        if (this.defaults == null) {
            this.usage();
            this.defaults = new GridBagConstraints();
            System.err.println("Using Default GridBagConstraints.");
        }
    }

    public void usage() {
        System.err.println("Usage: gridx gridy gridwidth gridheight ( ipadx ipady ) [ top left bottom right ] { weightx weighty} options");
        System.err.println();
        System.err.println("you may use spaces or commas as separators.");
        System.err.println();
        System.err.println("  gridx and gridy are mandatory, can be * for RELATIVE");
        System.err.println("  gridwidth and gridheight are optional, can be * for REMAINDER");
        System.err.println("  ipadx and ipady are optional");
        System.err.println("  insets (top...right) are optional");
        System.err.println("  weights are optional and override any settings made to them by the options");
        System.err.println("  options are optional");
        System.err.println();
        System.err.println("Options may contain a set of characters which will set the corresponding");
        System.err.println("flag to true. If not set, the flag is false.");
        System.err.println();
        System.err.println("  \"r\" right align");
        System.err.println("  \"l\" left align");
        System.err.println("  \"t\" top align");
        System.err.println("  \"b\" bottom align");
        System.err.println("if none of these are set the component is placed in the center.");
        System.err.println();
        System.err.println("  \"w\" resize both cell and component in width");
        System.err.println("  \"W\" resize only cell in width");
        System.err.println("  \"h\" resize both cell and component in height");
        System.err.println("  \"H\" resize only cell in height");
        System.err.println("if none of these are set neither the component nor the cell is not resized.");
        System.err.println("and the extra space is put on the outside of the table.");
        System.err.println();
        System.err.println("The weight is calculated as follows, if not set explicitly by the {weight} section:");
        System.err.println("1.0 if character set, fill is set if lowercase.");
        System.err.println();
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String && (object = this.getGridBagConstraints((String)object)) == null) {
            this.usage();
            object = new GridBagConstraints();
            System.err.println("Using Default GridBagConstraints.");
        }
        super.addLayoutComponent(component, object);
    }

    public String toString() {
        return "[TableLayout: " + super.toString() + "]";
    }

    protected GridBagConstraints getGridBagConstraints(String string) {
        return TableLayout.getGridBagConstraints(string, this.defaults);
    }

    public static GridBagConstraints getGridBagConstraints(String string, GridBagConstraints gridBagConstraints) {
        String string2 = "\\s*";
        String string3 = "[\\s,]+";
        String string4 = "[+-]?\\d+";
        String string5 = "([+-]?\\d+)";
        String string6 = "((?:" + string4 + ")|\\*)";
        String string7 = "([+-]?\\d*(?:\\.\\d*)?)";
        String string8 = "([tlbrWwHh]*)";
        String string9 = string2 + string6 + string3 + string6 + "(?:" + string3 + string6 + string3 + string6 + ")?";
        String string10 = string2 + "(?:\\(" + string2 + string5 + string3 + string5 + string2 + "\\))?";
        String string11 = string2 + "(?:\\[" + string2 + string5 + string3 + string5 + string3 + string5 + string3 + string5 + string2 + "\\])?";
        String string12 = string2 + "(?:\\{" + string2 + string7 + string3 + string7 + string2 + "\\})?";
        String string13 = string2 + string8;
        String string14 = string2 + "(.*)";
        Pattern pattern = Pattern.compile(string9 + string10 + string11 + string12 + string13 + string14);
        Matcher matcher = pattern.matcher(string);
        int n2 = 14;
        if (!matcher.find()) {
            if (matcher.groupCount() != n2) {
                System.err.println("Expected " + n2 + " arguments, but got " + matcher.groupCount() + " in '" + string + "'.");
            } else {
                System.err.println("Cannot parse '" + string + "'.");
            }
            return null;
        }
        try {
            int n3;
            int n4 = TableLayout.getPosition(matcher.group(1));
            int n5 = TableLayout.getPosition(matcher.group(2));
            int n6 = matcher.group(3) != null ? TableLayout.getSpan(matcher.group(3)) : gridBagConstraints.gridwidth;
            int n7 = matcher.group(4) != null ? TableLayout.getSpan(matcher.group(4)) : gridBagConstraints.gridheight;
            int n8 = matcher.group(5) != null ? Integer.parseInt(matcher.group(5)) : gridBagConstraints.ipadx;
            int n9 = matcher.group(6) != null ? Integer.parseInt(matcher.group(6)) : gridBagConstraints.ipady;
            Insets insets = matcher.group(7) != null ? new Insets(Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)), Integer.parseInt(matcher.group(10))) : gridBagConstraints.insets;
            double d2 = matcher.group(11) != null ? Double.parseDouble(matcher.group(11)) : gridBagConstraints.weightx;
            double d3 = matcher.group(12) != null ? Double.parseDouble(matcher.group(12)) : gridBagConstraints.weighty;
            String string15 = matcher.group(13);
            int n10 = gridBagConstraints != null ? gridBagConstraints.anchor : 10;
            int n11 = n3 = gridBagConstraints != null ? gridBagConstraints.fill : 0;
            if (string15 != null) {
                boolean bl;
                boolean bl2;
                int n12 = 0;
                if (string15.indexOf(108) >= 0 && string15.indexOf(114) < 0) {
                    n12 |= 0x10;
                }
                if (string15.indexOf(114) >= 0 && string15.indexOf(108) < 0) {
                    n12 |= 0x20;
                }
                if (string15.indexOf(116) >= 0 && string15.indexOf(98) < 0) {
                    n12 |= 1;
                }
                if (string15.indexOf(98) >= 0 && string15.indexOf(116) < 0) {
                    n12 |= 2;
                }
                switch (n12) {
                    default: {
                        break;
                    }
                    case 1: {
                        n10 = 11;
                        break;
                    }
                    case 2: {
                        n10 = 15;
                        break;
                    }
                    case 16: {
                        n10 = 17;
                        break;
                    }
                    case 17: {
                        n10 = 18;
                        break;
                    }
                    case 18: {
                        n10 = 16;
                        break;
                    }
                    case 32: {
                        n10 = 13;
                        break;
                    }
                    case 33: {
                        n10 = 12;
                        break;
                    }
                    case 34: {
                        n10 = 14;
                    }
                }
                switch (n3) {
                    default: {
                        bl2 = false;
                        bl = false;
                        break;
                    }
                    case 2: {
                        bl2 = true;
                        bl = false;
                        break;
                    }
                    case 3: {
                        bl2 = false;
                        bl = true;
                        break;
                    }
                    case 1: {
                        bl2 = true;
                        bl = true;
                    }
                }
                if (string15.indexOf(119) >= 0) {
                    bl2 = true;
                    if (matcher.group(11) == null) {
                        d2 = 1.0;
                    }
                }
                if (string15.indexOf(87) >= 0 && matcher.group(11) == null) {
                    d2 = 1.0;
                }
                if (string15.indexOf(104) >= 0) {
                    bl = true;
                    if (matcher.group(12) == null) {
                        d3 = 1.0;
                    }
                }
                if (string15.indexOf(72) >= 0 && matcher.group(12) == null) {
                    d3 = 1.0;
                }
                if (bl2) {
                    n3 = bl ? 1 : 2;
                } else if (bl) {
                    n3 = 3;
                }
                if (matcher.group(14) != null && !matcher.group(14).equals("")) {
                    System.err.println("Cannot parse: '" + matcher.group(14) + "' in '" + string + "'.");
                    return null;
                }
            }
            return new TableConstraints(n4, n5, n6, n7, d2, d3, n10, n3, insets, n8, n9);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Problem " + numberFormatException.getMessage() + " in '" + string + "'.");
            return null;
        }
    }

    private static int getPosition(String string) {
        if (string.equals("*")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private static int getSpan(String string) {
        if (string.equals("*")) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static String toString(GridBagConstraints gridBagConstraints) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(gridBagConstraints.gridx == -1 ? "*" : String.valueOf(gridBagConstraints.gridx));
        stringBuffer.append(" ");
        stringBuffer.append(gridBagConstraints.gridy == -1 ? "*" : String.valueOf(gridBagConstraints.gridy));
        stringBuffer.append(" ");
        stringBuffer.append(gridBagConstraints.gridwidth == 0 ? "*" : String.valueOf(gridBagConstraints.gridwidth));
        stringBuffer.append(" ");
        stringBuffer.append(gridBagConstraints.gridheight == 0 ? "*" : String.valueOf(gridBagConstraints.gridheight));
        stringBuffer.append(" (");
        stringBuffer.append(String.valueOf(gridBagConstraints.ipadx));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(gridBagConstraints.ipady));
        stringBuffer.append(") [");
        stringBuffer.append(String.valueOf(gridBagConstraints.insets.top));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(gridBagConstraints.insets.left));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(gridBagConstraints.insets.bottom));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(gridBagConstraints.insets.right));
        stringBuffer.append("] {");
        stringBuffer.append(String.valueOf(gridBagConstraints.weightx));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(gridBagConstraints.weighty));
        stringBuffer.append("} ");
        switch (gridBagConstraints.anchor) {
            default: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                stringBuffer.append("t");
                break;
            }
            case 18: {
                stringBuffer.append("tl");
                break;
            }
            case 17: {
                stringBuffer.append("l");
                break;
            }
            case 16: {
                stringBuffer.append("bl");
                break;
            }
            case 15: {
                stringBuffer.append("b");
                break;
            }
            case 14: {
                stringBuffer.append("br");
                break;
            }
            case 13: {
                stringBuffer.append("r");
                break;
            }
            case 12: {
                stringBuffer.append("tr");
            }
        }
        switch (gridBagConstraints.fill) {
            default: {
                break;
            }
            case 0: {
                if (gridBagConstraints.weightx == 1.0) {
                    stringBuffer.append("W");
                }
                if (gridBagConstraints.weighty != 1.0) break;
                stringBuffer.append("H");
                break;
            }
            case 2: {
                stringBuffer.append("w");
                if (gridBagConstraints.weighty != 1.0) break;
                stringBuffer.append("H");
                break;
            }
            case 3: {
                if (gridBagConstraints.weightx == 1.0) {
                    stringBuffer.append("W");
                }
                stringBuffer.append("h");
                break;
            }
            case 1: {
                stringBuffer.append("wh");
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        TableLayout tableLayout = new TableLayout();
        System.out.println(tableLayout.getGridBagConstraints("1 2 3 4 (5 6) [7 8 9 10] {11 12} tlwh"));
        System.out.println(tableLayout.getGridBagConstraints("1 2 3 4 [7 8 9 10] {11 12} trWh"));
        System.out.println(tableLayout.getGridBagConstraints("1 2 3 4 (5 6) {11 12} tlwH"));
        System.out.println(tableLayout.getGridBagConstraints("1 2 3 4 (5 6) [7 8 9 10] brwh"));
        System.out.println(tableLayout.getGridBagConstraints("1 2 3 4 (5 6) tlWh"));
        System.out.println(tableLayout.getGridBagConstraints("1 2 3 4"));
        System.out.println(tableLayout.getGridBagConstraints("1 2"));
        System.out.println(tableLayout.getGridBagConstraints("* * 2 4"));
        System.out.println(tableLayout.getGridBagConstraints("* 0 2 4"));
        System.out.println(tableLayout.getGridBagConstraints("0 * * *"));
        System.out.println(tableLayout.getGridBagConstraints("0 0 * 4"));
    }

    public static class TableConstraints
    extends GridBagConstraints {
        public TableConstraints() {
        }

        public TableConstraints(int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7, Insets insets, int n8, int n9) {
            super(n2, n3, n4, n5, d2, d3, n6, n7, insets, n8, n9);
        }

        public String toString() {
            return "TableConstraints: " + TableLayout.toString(this);
        }
    }
}

