/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.crypto.engine;

public class ZipCryptoEngine {
    private final int[] keys = new int[3];
    private static final int[] CRC_TABLE = new int[256];

    public void initKeys(char[] cArray) {
        this.keys[0] = 305419896;
        this.keys[1] = 591751049;
        this.keys[2] = 878082192;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            this.updateKeys((byte)(cArray[i2] & 0xFF));
        }
    }

    public void updateKeys(byte by) {
        this.keys[0] = this.crc32(this.keys[0], by);
        this.keys[1] = this.keys[1] + (this.keys[0] & 0xFF);
        this.keys[1] = this.keys[1] * 134775813 + 1;
        this.keys[2] = this.crc32(this.keys[2], (byte)(this.keys[1] >> 24));
    }

    private int crc32(int n2, byte by) {
        return n2 >>> 8 ^ CRC_TABLE[(n2 ^ by) & 0xFF];
    }

    public byte decryptByte() {
        int n2 = this.keys[2] | 2;
        return (byte)(n2 * (n2 ^ 1) >>> 8);
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = i2;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((n2 & 1) == 1) {
                    n2 = n2 >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n2 >>>= 1;
            }
            ZipCryptoEngine.CRC_TABLE[i2] = n2;
        }
    }
}

