/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.namespace.NamespaceContext;
import com.fr.third.javax.xml.stream.Entity;
import com.fr.third.javax.xml.stream.Location;
import com.fr.third.javax.xml.stream.PropertyManager;
import com.fr.third.javax.xml.stream.StaxErrorReporter;
import com.fr.third.javax.xml.stream.XMLDTDScannerImpl;
import com.fr.third.javax.xml.stream.XMLEntityManager;
import com.fr.third.javax.xml.stream.XMLEntityReaderImpl;
import com.fr.third.javax.xml.stream.XMLEntityStorage;
import com.fr.third.javax.xml.stream.XMLNSDocumentScannerImpl;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.XMLStreamReader;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.DTDGrammar;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.XMLNotationDecl;
import com.fr.third.javax.xml.stream.events.EntityDeclarationImpl;
import com.fr.third.javax.xml.stream.events.NotationDeclarationImpl;
import com.fr.third.javax.xml.stream.xerces.util.NamespaceContextWrapper;
import com.fr.third.javax.xml.stream.xerces.util.SymbolTable;
import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import com.fr.third.javax.xml.stream.xerces.util.XMLStringBuffer;
import com.fr.third.javax.xml.stream.xerces.xni.QName;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;

public class XMLReaderImpl
implements XMLStreamReader {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private SymbolTable fSymbolTable = new SymbolTable();
    protected XMLNSDocumentScannerImpl fScanner = new XMLNSDocumentScannerImpl();
    protected NamespaceContextWrapper fNamespaceContextWrapper = new NamespaceContextWrapper(this.fScanner.getNamespaceContext());
    protected XMLEntityManager fEntityManager = new XMLEntityManager();
    protected StaxErrorReporter fErrorReporter = new StaxErrorReporter();
    protected XMLEntityReaderImpl fEntityScanner = null;
    protected XMLInputSource fInputSource = null;
    protected PropertyManager fPropertyManager = null;
    private int fEventType;
    static final boolean DEBUG = false;
    private boolean fReuse = true;
    private boolean fBindNamespaces = true;
    private String fDTDDecl = null;

    public XMLReaderImpl(InputStream inputStream, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, inputStream, null);
        this.setInputSource(xMLInputSource);
    }

    public XMLReaderImpl(String string, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        this.setInputSource(xMLInputSource);
    }

    public XMLReaderImpl(InputStream inputStream, String string, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new BufferedInputStream(inputStream), string);
        this.setInputSource(xMLInputSource);
    }

    public XMLReaderImpl(Reader reader, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new BufferedReader(reader), null);
        this.setInputSource(xMLInputSource);
    }

    public XMLReaderImpl(XMLInputSource xMLInputSource, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        this.setInputSource(xMLInputSource);
    }

    public void setInputSource(XMLInputSource xMLInputSource) throws XMLStreamException {
        this.fReuse = false;
        try {
            this.fScanner.setInputSource(xMLInputSource);
            this.fEventType = this.fScanner.next();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void setInputSource(InputSource inputSource) throws XMLStreamException {
        this.setInputSource(this.convertSAXInputSource2XMLInputSource(inputSource));
    }

    XMLInputSource convertSAXInputSource2XMLInputSource(InputSource inputSource) {
        XMLInputSource xMLInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null && !(inputStream instanceof ByteArrayInputStream) && !(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        xMLInputSource.setByteStream(inputStream);
        Reader reader = inputSource.getCharacterStream();
        if (!(reader == null || reader instanceof BufferedReader || reader instanceof CharArrayReader || reader instanceof StringReader)) {
            reader = new BufferedReader(reader);
        }
        xMLInputSource.setCharacterStream(reader);
        xMLInputSource.setEncoding(inputSource.getEncoding());
        return xMLInputSource;
    }

    void init(PropertyManager propertyManager) throws XMLStreamException {
        this.fPropertyManager = propertyManager;
        propertyManager.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        propertyManager.setProperty(ERROR_REPORTER, this.fErrorReporter);
        propertyManager.setProperty(ENTITY_MANAGER, this.fEntityManager);
        this.reset();
    }

    public boolean canReuse() {
        return this.fReuse;
    }

    public void reset() {
        this.fReuse = true;
        this.fEventType = 0;
        this.fEntityManager.reset(this.fPropertyManager);
        this.fScanner.reset(this.fPropertyManager);
        this.fDTDDecl = null;
        this.fEntityScanner = (XMLEntityReaderImpl)this.fEntityManager.getEntityReader();
        this.fBindNamespaces = (Boolean)this.fPropertyManager.getProperty("com.fr.third.javax.xml.stream.isNamespaceAware");
    }

    public void close() throws XMLStreamException {
        this.fReuse = true;
    }

    public String getCharacterEncodingScheme() {
        return this.fScanner.getCharacterEncodingScheme();
    }

    public int getColumnNumber() {
        return this.fEntityScanner.getColumnNumber();
    }

    public String getEncoding() {
        return this.fEntityScanner.getEncoding();
    }

    public int getEventType() {
        return this.fEventType;
    }

    public int getLineNumber() {
        return this.fEntityScanner.getLineNumber();
    }

    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        if (this.fEventType == 9) {
            return this.fScanner.getEntityName();
        }
        return null;
    }

    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().uri;
        }
        return null;
    }

    public String getPIData() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLReaderImpl.getEventTypeString(this.fEventType) + " But expected state is " + XMLReaderImpl.getEventTypeString(3));
    }

    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLReaderImpl.getEventTypeString(this.fEventType) + " But expected state is " + XMLReaderImpl.getEventTypeString(3));
    }

    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().prefix;
        }
        return null;
    }

    public char[] getTextCharacters() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().ch;
        }
        throw new IllegalStateException("Current state = " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(4) + " , " + XMLReaderImpl.getEventTypeString(5) + " , " + XMLReaderImpl.getEventTypeString(12) + " , " + XMLReaderImpl.getEventTypeString(6) + " valid for getTextCharacters() ");
    }

    public int getTextLength() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().length;
        }
        throw new IllegalStateException("Current state = " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(4) + " , " + XMLReaderImpl.getEventTypeString(5) + " , " + XMLReaderImpl.getEventTypeString(12) + " , " + XMLReaderImpl.getEventTypeString(6) + " valid for getTextLength() ");
    }

    public int getTextStart() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().offset;
        }
        throw new IllegalStateException("Current state = " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(4) + " , " + XMLReaderImpl.getEventTypeString(5) + " , " + XMLReaderImpl.getEventTypeString(12) + " , " + XMLReaderImpl.getEventTypeString(6) + " valid for getTextStart() ");
    }

    public String getValue() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        if (this.fEventType == 5) {
            return this.fScanner.getComment();
        }
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 4) {
            return this.fScanner.getCharacterData().toString();
        }
        return null;
    }

    public String getVersion() {
        return this.fEntityScanner.getVersion();
    }

    public boolean hasAttributes() {
        return this.fScanner.getAttributeIterator().getLength() > 0;
    }

    public boolean hasName() {
        return this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 9 || this.fEventType == 3;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    public boolean hasValue() {
        return this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 9 || this.fEventType == 3 || this.fEventType == 5 || this.fEventType == 4;
    }

    public boolean isEndElement() {
        return this.fEventType == 2;
    }

    public boolean isStandalone() {
        return this.fScanner.isStandAlone();
    }

    public boolean isStartElement() {
        return this.fEventType == 1;
    }

    public boolean isWhiteSpace() {
        if (this.isCharacters() || this.fEventType == 12) {
            char[] cArray = this.getTextCharacters();
            int n2 = this.getTextStart();
            int n3 = n2 + this.getTextLength();
            int n4 = n2;
            while (n4 < n3) {
                if (!XMLChar.isSpace(cArray[n4])) {
                    return false;
                }
                ++n4;
            }
            return true;
        }
        return false;
    }

    public int next() throws XMLStreamException {
        try {
            this.fEventType = this.fScanner.next();
            return this.fEventType;
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException.getMessage(), this.getLocation(), iOException);
        }
        catch (XNIException xNIException) {
            throw new XMLStreamException(xNIException.getMessage(), this.getLocation(), xNIException.getException());
        }
    }

    static final String getEventTypeString(int n2) {
        switch (n2) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE , " + String.valueOf(n2);
    }

    public int getAttributeCount() {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLength();
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeCount()");
    }

    public com.fr.third.javax.xml.namespace.QName getAttributeName(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getAttributeIterator().getQualifiedName(n2));
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeName()");
    }

    public String getAttributeLocalName(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLocalName(n2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeLocalName()");
    }

    public String getAttributeNamespace(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getURI(n2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeNamespace()");
    }

    public String getAttributePrefix(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getPrefix(n2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributePrefix()");
    }

    public com.fr.third.javax.xml.namespace.QName getAttributeQName(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            String string = this.fScanner.getAttributeIterator().getLocalName(n2);
            String string2 = this.fScanner.getAttributeIterator().getURI(n2);
            return new com.fr.third.javax.xml.namespace.QName(string2, string);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeQName()");
    }

    public String getAttributeType(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getType(n2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeType()");
    }

    public String getAttributeValue(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(n2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeValue()");
    }

    public String getAttributeValue(String string, String string2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(string, string2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeValue()");
    }

    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int n2 = this.next();
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 != 2) {
            if (n2 == 4 || n2 == 12 || n2 == 6 || n2 == 9) {
                stringBuffer.append(this.getText());
            } else if (n2 != 3 && n2 != 5) {
                if (n2 == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (n2 == 1) {
                    throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + n2, this.getLocation());
            }
            n2 = this.next();
        }
        return stringBuffer.toString();
    }

    public Location getLocation() {
        return new Location(){

            public String getLocationURI() {
                return XMLReaderImpl.this.fEntityScanner.getExpandedSystemId();
            }

            public int getCharacterOffset() {
                return XMLReaderImpl.this.fEntityScanner.getCharacterOffset();
            }

            public int getColumnNumber() {
                return XMLReaderImpl.this.fEntityScanner.getColumnNumber();
            }

            public int getLineNumber() {
                return XMLReaderImpl.this.fEntityScanner.getLineNumber();
            }

            public String getPublicId() {
                return XMLReaderImpl.this.fEntityScanner.getPublicId();
            }

            public String getSystemId() {
                return XMLReaderImpl.this.fEntityScanner.getExpandedSystemId();
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Line number = " + this.getLineNumber());
                stringBuffer.append("\n");
                stringBuffer.append("Column number = " + this.getColumnNumber());
                stringBuffer.append("\n");
                stringBuffer.append("System Id = " + this.getSystemId());
                stringBuffer.append("\n");
                stringBuffer.append("Public Id = " + this.getPublicId());
                stringBuffer.append("\n");
                stringBuffer.append("Location Uri= " + this.getLocationURI());
                stringBuffer.append("\n");
                stringBuffer.append("CharacterOffset = " + this.getCharacterOffset());
                stringBuffer.append("\n");
                return stringBuffer.toString();
            }
        };
    }

    public com.fr.third.javax.xml.namespace.QName getName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getElementQName());
        }
        throw new IllegalArgumentException("Illegal to call getName() when event type is " + XMLReaderImpl.getEventTypeString(this.fEventType) + "." + " Valid states are " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2));
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContextWrapper;
    }

    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getDeclaredPrefixCount();
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespaceCount().");
    }

    public String getNamespacePrefix(int n2) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            String string = this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n2);
            return string.equals("") ? null : string;
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespacePrefix().");
    }

    public String getNamespaceURI(int n2) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getURI(this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n2));
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespaceURI().");
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.fPropertyManager != null) {
            if (string.equals("com.fr.third.javax.xml.stream.notations")) {
                return this.getNotationDecls();
            }
            if (string.equals("com.fr.third.javax.xml.stream.entities")) {
                return this.getEntityDecls();
            }
            return this.fPropertyManager.getProperty(string);
        }
        return null;
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().toString();
        }
        if (this.fEventType == 9) {
            String string = this.fScanner.getEntityName();
            if (string != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return this.fScanner.getCharacterData().toString();
                }
                XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
                Hashtable hashtable = xMLEntityStorage.getDeclaredEntities();
                Entity entity = (Entity)hashtable.get(string);
                if (entity == null) {
                    return null;
                }
                if (entity.isExternal()) {
                    return ((Entity.ExternalEntity)entity).entityLocation.getExpandedSystemId();
                }
                return ((Entity.InternalEntity)entity).text;
            }
            return null;
        }
        if (this.fEventType == 11) {
            if (this.fDTDDecl != null) {
                return this.fDTDDecl;
            }
            XMLStringBuffer xMLStringBuffer = this.fScanner.getDTDDecl();
            this.fDTDDecl = xMLStringBuffer.toString();
            return this.fDTDDecl;
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states" + XMLReaderImpl.getEventTypeString(4) + ", " + XMLReaderImpl.getEventTypeString(5) + ", " + XMLReaderImpl.getEventTypeString(12) + ", " + XMLReaderImpl.getEventTypeString(6) + ", " + XMLReaderImpl.getEventTypeString(9) + ", " + XMLReaderImpl.getEventTypeString(11) + " valid for getText() ");
    }

    public void require(int n2, String string, String string2) throws XMLStreamException {
        if (n2 != this.fEventType) {
            throw new XMLStreamException("Event type " + XMLReaderImpl.getEventTypeString(n2) + " specified did " + "not match with current parser event " + XMLReaderImpl.getEventTypeString(this.fEventType));
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Namespace URI " + string + " specified did not match " + "with current namespace URI");
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException("LocalName " + string2 + " specified did not match with " + "current local name");
        }
    }

    public int getTextCharacters(int n2, char[] cArray, int n3, int n4) throws XMLStreamException {
        if (cArray == null) {
            throw new NullPointerException("target char array can't be null");
        }
        if (n3 < 0 || n4 < 0 || n2 < 0 || n3 >= cArray.length || n3 + n4 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = 0;
        int n6 = this.getTextLength() - n2;
        if (n6 < 0) {
            throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
        }
        n5 = n6 < n4 ? n6 : n4;
        System.arraycopy(this.getTextCharacters(), this.getTextStart() + n2, cArray, n3, n5);
        return n5;
    }

    public boolean hasText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12) {
            return this.fScanner.getCharacterData().length > 0;
        }
        if (this.fEventType == 9) {
            String string = this.fScanner.getEntityName();
            if (string != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return true;
                }
                XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
                Hashtable hashtable = xMLEntityStorage.getDeclaredEntities();
                Entity entity = (Entity)hashtable.get(string);
                if (entity == null) {
                    return false;
                }
                if (entity.isExternal()) {
                    return ((Entity.ExternalEntity)entity).entityLocation.getExpandedSystemId() != null;
                }
                return ((Entity.InternalEntity)entity).text != null;
            }
            return false;
        }
        if (this.fEventType == 11) {
            return this.fScanner.fSeenDoctypeDecl;
        }
        return false;
    }

    public boolean isAttributeSpecified(int n2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().isSpecified(n2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for isAttributeSpecified()");
    }

    public boolean isCharacters() {
        return this.fEventType == 4;
    }

    public int nextTag() throws XMLStreamException {
        int n2 = this.next();
        while (n2 == 4 && this.isWhiteSpace() || n2 == 12 && this.isWhiteSpace() || n2 == 6 || n2 == 3 || n2 == 5) {
            n2 = this.next();
        }
        if (n2 != 1 && n2 != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return n2;
    }

    public boolean standaloneSet() {
        return this.fScanner.isStandAlone();
    }

    public com.fr.third.javax.xml.namespace.QName convertXNIQNametoJavaxQName(QName qName) {
        if (qName == null) {
            return null;
        }
        if (qName.prefix == null) {
            return new com.fr.third.javax.xml.namespace.QName(qName.uri, qName.localpart);
        }
        return new com.fr.third.javax.xml.namespace.QName(qName.uri, qName.localpart, qName.prefix);
    }

    public String getNamespaceURI(String string) {
        return this.fScanner.getNamespaceContext().getURI(this.fSymbolTable.addSymbol(string));
    }

    protected void setPropertyManager(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
        this.fScanner.setProperty("stax-properties", propertyManager);
        this.fScanner.setPropertyManager(propertyManager);
    }

    protected PropertyManager getPropertyManager() {
        return this.fPropertyManager;
    }

    static void pr(String string) {
        System.out.println(string);
    }

    protected List getEntityDecls() {
        if (this.fEventType == 11) {
            XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
            Hashtable hashtable = xMLEntityStorage.getDeclaredEntities();
            ArrayList<EntityDeclarationImpl> arrayList = null;
            if (hashtable != null) {
                EntityDeclarationImpl entityDeclarationImpl = null;
                arrayList = new ArrayList<EntityDeclarationImpl>(hashtable.size());
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Entity entity = (Entity)hashtable.get(string);
                    entityDeclarationImpl = new EntityDeclarationImpl();
                    entityDeclarationImpl.setEntityName(string);
                    if (entity.isExternal()) {
                        entityDeclarationImpl.setXMLResourceIdentifier(((Entity.ExternalEntity)entity).entityLocation);
                        entityDeclarationImpl.setNotationName(((Entity.ExternalEntity)entity).notation);
                    } else {
                        entityDeclarationImpl.setEntityReplacementText(((Entity.InternalEntity)entity).text);
                    }
                    arrayList.add(entityDeclarationImpl);
                }
            }
            return arrayList;
        }
        return null;
    }

    protected List getNotationDecls() {
        if (this.fEventType == 11) {
            if (this.fScanner.fDTDScanner == null) {
                return null;
            }
            DTDGrammar dTDGrammar = ((XMLDTDScannerImpl)this.fScanner.fDTDScanner).getGrammar();
            if (dTDGrammar == null) {
                return null;
            }
            List list = dTDGrammar.getNotationDecls();
            Iterator iterator = list.iterator();
            ArrayList<NotationDeclarationImpl> arrayList = new ArrayList<NotationDeclarationImpl>();
            while (iterator.hasNext()) {
                XMLNotationDecl xMLNotationDecl = (XMLNotationDecl)iterator.next();
                if (xMLNotationDecl == null) continue;
                arrayList.add(new NotationDeclarationImpl(xMLNotationDecl));
            }
            return arrayList;
        }
        return null;
    }
}

