/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileSeekableStream
extends SeekableStream {
    private RandomAccessFile file;
    private long markPos = -1L;
    private static final int PAGE_SHIFT = 9;
    private static final int PAGE_SIZE = 512;
    private static final int PAGE_MASK = 511;
    private static final int NUM_PAGES = 32;
    private static final int READ_CACHE_LIMIT = 512;
    private byte[][] pageBuf = new byte[512][32];
    private int[] currentPage = new int[32];
    private long length = 0L;
    private long pointer = 0L;

    public FileSeekableStream(RandomAccessFile randomAccessFile) throws IOException {
        this.file = randomAccessFile;
        randomAccessFile.seek(0L);
        this.length = randomAccessFile.length();
        for (int i2 = 0; i2 < 32; ++i2) {
            this.pageBuf[i2] = new byte[512];
            this.currentPage[i2] = -1;
        }
    }

    public FileSeekableStream(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public FileSeekableStream(String string) throws IOException {
        this(new RandomAccessFile(string, "r"));
    }

    public final boolean canSeekBackwards() {
        return true;
    }

    public final long getFilePointer() throws IOException {
        return this.pointer;
    }

    public final void seek(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException(JaiI18N.getString("FileSeekableStream0"));
        }
        this.pointer = l2;
    }

    public final int skip(int n2) throws IOException {
        this.pointer += (long)n2;
        return n2;
    }

    private byte[] readPage(long l2) throws IOException {
        int n2;
        int n3 = (int)(l2 >> 9);
        for (n2 = 0; n2 < 32; ++n2) {
            if (this.currentPage[n2] != n3) continue;
            return this.pageBuf[n2];
        }
        n2 = (int)(Math.random() * 32.0);
        this.currentPage[n2] = n3;
        long l3 = (long)n3 << 9;
        long l4 = this.length - l3;
        int n4 = 512L < l4 ? 512 : (int)l4;
        this.file.seek(l3);
        this.file.readFully(this.pageBuf[n2], 0, n4);
        return this.pageBuf[n2];
    }

    public final int read() throws IOException {
        if (this.pointer >= this.length) {
            return -1;
        }
        byte[] byArray = this.readPage(this.pointer);
        return byArray[(int)(this.pointer++ & 0x1FFL)] & 0xFF;
    }

    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if ((n3 = (int)Math.min((long)n3, this.length - this.pointer)) <= 0) {
            return -1;
        }
        if (n3 > 512) {
            this.file.seek(this.pointer);
            int n4 = this.file.read(byArray, n2, n3);
            this.pointer += (long)n4;
            return n4;
        }
        byte[] byArray2 = this.readPage(this.pointer);
        int n5 = 512 - (int)(this.pointer & 0x1FFL);
        int n6 = n3 < n5 ? n3 : n5;
        System.arraycopy(byArray2, (int)(this.pointer & 0x1FFL), byArray, n2, n6);
        this.pointer += (long)n6;
        return n6;
    }

    public final void close() throws IOException {
        this.file.close();
    }

    public final synchronized void mark(int n2) {
        this.markPos = this.pointer;
    }

    public final synchronized void reset() throws IOException {
        if (this.markPos != -1L) {
            this.pointer = this.markPos;
        }
    }

    public boolean markSupported() {
        return true;
    }
}

