/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core.group;

import com.fr.base.FRContext;
import com.fr.cache.list.IntList;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.report.cell.cellattr.core.group.Group;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class IndexGrouper
extends RecordGrouper {
    private int index;

    public void setIndex(int n2) {
        this.index = n2;
    }

    public Group[] group(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        if (n2 == -1) {
            return super.group(dataModel, n2, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range(dataModel.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        Object object = null;
        int n3 = 0;
        if (this.index >= 0 && this.index < nArray.length) {
            n3 = nArray[this.index];
            try {
                object = dataModel.getValueAt(n3, n2);
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        return new Group[]{new Group(object, new int[]{n3})};
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "Attr".equals(xMLableReader.getTagName()) && (string = xMLableReader.getAttrAsString("index", null)) != null) {
            this.setIndex(Integer.parseInt(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr").attr("index", this.index).end();
    }
}

