/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.memory;

import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryManager {
    private static MemoryPoolMXBean tenuredMemoryPool;
    private static final ReentrantLock LOCK;
    private static boolean isInit;

    static MemoryPoolMXBean getTenuredMemoryPool() {
        if (!isInit) {
            tenuredMemoryPool = MemoryManager.findTenured();
            isInit = true;
        }
        return tenuredMemoryPool;
    }

    static boolean hasMXBean() {
        return tenuredMemoryPool != null;
    }

    public static void setTenuredMemoryPoolByName(String string) {
        List<MemoryPoolMXBean> list = MemoryManager.getHeapMemoryMXBean();
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            if (!memoryPoolMXBean.getName().equals(string)) continue;
            MemoryManager.setTenuredMemoryPool(memoryPoolMXBean);
            return;
        }
    }

    static void setTenuredMemoryPool(MemoryPoolMXBean memoryPoolMXBean) {
        LOCK.lock();
        try {
            tenuredMemoryPool = memoryPoolMXBean;
        }
        finally {
            LOCK.unlock();
        }
    }

    static JSONArray getMemoryMXBeanData() {
        JSONArray jSONArray = new JSONArray();
        List<MemoryPoolMXBean> list = MemoryManager.getHeapMemoryMXBean();
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("name", memoryPoolMXBean.getName());
                jSONObject.put("max", memoryPoolMXBean.getUsage().getMax());
                jSONArray.put(jSONObject);
            }
            catch (JSONException jSONException) {}
        }
        return jSONArray;
    }

    static List<MemoryPoolMXBean> getHeapMemoryMXBean() {
        ArrayList<MemoryPoolMXBean> arrayList = new ArrayList<MemoryPoolMXBean>();
        List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            MemoryType memoryType = memoryPoolMXBean.getType();
            if (!memoryType.equals((Object)MemoryType.HEAP)) continue;
            arrayList.add(memoryPoolMXBean);
        }
        return arrayList;
    }

    static MemoryPoolMXBean findTenured() {
        MemoryPoolMXBean memoryPoolMXBean = null;
        memoryPoolMXBean = MemoryManager.findTenuredByName();
        if (memoryPoolMXBean == null) {
            memoryPoolMXBean = MemoryManager.findTenuredByMaxMemory();
        }
        return memoryPoolMXBean;
    }

    private static MemoryPoolMXBean findTenuredByName() {
        List<MemoryPoolMXBean> list = MemoryManager.getHeapMemoryMXBean();
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            String string = memoryPoolMXBean.getName();
            if (!string.contains("Old Gen") && !string.contains("Tenured Gen")) continue;
            return memoryPoolMXBean;
        }
        return null;
    }

    private static MemoryPoolMXBean findTenuredByMaxMemory() {
        List<MemoryPoolMXBean> list = MemoryManager.getHeapMemoryMXBean();
        MemoryPoolMXBean memoryPoolMXBean = null;
        for (MemoryPoolMXBean memoryPoolMXBean2 : list) {
            if (memoryPoolMXBean == null) {
                memoryPoolMXBean = memoryPoolMXBean2;
                continue;
            }
            if (MemoryManager.getMaxMemory(memoryPoolMXBean2) <= MemoryManager.getMaxMemory(memoryPoolMXBean)) continue;
            memoryPoolMXBean = memoryPoolMXBean2;
        }
        return memoryPoolMXBean;
    }

    private static long getMaxMemory(MemoryPoolMXBean memoryPoolMXBean) {
        return memoryPoolMXBean.getUsage().getMax();
    }

    static boolean checkValid(MemoryPoolMXBean memoryPoolMXBean) {
        return memoryPoolMXBean != null && memoryPoolMXBean.isUsageThresholdSupported();
    }

    public static void main(String[] stringArray) {
        System.out.println(MemoryManager.getMemoryMXBeanData());
    }

    static {
        LOCK = new ReentrantLock();
    }
}

