/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.general.FRLogger;
import com.fr.performance.dao.FileManager;
import com.fr.performance.dao.InfoSaver;
import com.fr.performance.info.PerformanceInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class JSONInfoSaver
implements InfoSaver {
    private OutputStream out;

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void save(PerformanceInfo performanceInfo) {
        try {
            this.writeMark();
            byte[] byArray = this.getInfoBytes(performanceInfo);
            this.writeInt(byArray.length);
            this.out.write(byArray);
            this.flush();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
    }

    private byte[] getInfoBytes(PerformanceInfo performanceInfo) throws UnsupportedEncodingException {
        String string = performanceInfo.toJSONString();
        return string.getBytes("UTF-8");
    }

    private void writeInt(int n2) throws IOException {
        this.out.write(n2 >>> 24 & 0xFF);
        this.out.write(n2 >>> 16 & 0xFF);
        this.out.write(n2 >>> 8 & 0xFF);
        this.out.write(n2 >>> 0 & 0xFF);
    }

    private void writeMark() throws IOException {
        this.out.write(FileManager.INFO_MARK);
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
    }

    public static JSONInfoSaver create(File file) {
        JSONInfoSaver jSONInfoSaver = new JSONInfoSaver();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, true));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        jSONInfoSaver.setOutputStream(bufferedOutputStream);
        return jSONInfoSaver;
    }
}

