/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.BaseUtils;
import com.fr.base.DynamicUnitList;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.general.FRFont;
import com.fr.io.core.ExporterUtils;
import com.fr.io.exporter.PDFExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PagePainterProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.core.ResultSubReport;
import com.fr.report.cellcase.CellElementCaseGetter;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.stable.unit.PT;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.Image;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.Rectangle;
import com.fr.third.com.lowagie.text.pdf.FontMapper;
import com.fr.third.com.lowagie.text.pdf.PdfContentByte;
import com.fr.third.com.lowagie.text.pdf.PdfPCell;
import com.fr.third.com.lowagie.text.pdf.PdfPTable;
import com.fr.third.com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class PDFExporter2
extends PDFExporter {
    private boolean isPrint = false;

    public PDFExporter2() {
        this(false);
    }

    public PDFExporter2(boolean bl) {
        this.isPrint = bl;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        this.export(outputStream, pageSetProvider);
        pageSetProvider.release();
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        ReportPageProvider reportPageProvider;
        Document document = new Document();
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        PDFExporter2.prepareFontMapper();
        for (int i2 = 0; i2 < pageSetProvider.size() && (reportPageProvider = pageSetProvider.getPage(i2)) != null; ++i2) {
            Object object;
            float f2 = reportPageProvider.getPaperWidth().toPixF(72);
            float f3 = reportPageProvider.getPaperHeight().toPixF(72);
            float f4 = reportPageProvider.getMarginLeft().toPixF(72);
            float f5 = reportPageProvider.getMarginRight().toPixF(72);
            float f6 = reportPageProvider.getMarginTop().toPixF(72);
            float f7 = reportPageProvider.getMarginBottom().toPixF(72);
            ReportSettingsProvider reportSettingsProvider = reportPageProvider.getReportSettings();
            float f8 = reportSettingsProvider.getHeaderHeight().toPixF(72);
            float f9 = reportSettingsProvider.getFooterHeight().toPixF(72);
            document.setPageSize(new Rectangle(f2, f3));
            document.setMargins(f4, f5, f6, f7);
            document.newPage();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContentUnder();
            Graphics2D graphics2D = pdfContentByte.createGraphics(f2, f3, (FontMapper)PDFExporter2.prepareFontMapper());
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("0", ReportPageProvider.class);
            hashMap.put("1", Graphics2D.class);
            PagePainterProvider pagePainterProvider = StableFactory.getMarkedInstanceObjectFromClass("PDFExporter", new Object[]{reportPageProvider, graphics2D, Integer.valueOf(String.valueOf(72)), this.isPrint}, hashMap, PagePainterProvider.class);
            pagePainterProvider.convert();
            graphics2D.dispose();
            ClippedPageProvider clippedPageProvider = ExporterUtils.support(reportPageProvider);
            if (clippedPageProvider == null) {
                return;
            }
            int n2 = clippedPageProvider.getColumnCount();
            int n3 = clippedPageProvider.getRowCount();
            DynamicUnitList dynamicUnitList = ReportHelper.createColumnWidthList((CellElementCaseGetter)((Object)clippedPageProvider));
            DynamicUnitList dynamicUnitList2 = ReportHelper.createRowHeightList((CellElementCaseGetter)((Object)clippedPageProvider));
            float[] fArray = this.sumDynamicValueList2Float(n2, dynamicUnitList);
            float f10 = fArray[fArray.length - 1];
            float[] fArray2 = this.sumDynamicValueList2Float(n3, dynamicUnitList2);
            float f11 = fArray2[fArray2.length - 1];
            ReportHFProvider reportHFProvider = reportPageProvider.getHeader();
            if (f8 > 0.0f && reportHFProvider != null) {
                document.add((Element)this.createImageFromHFElement(reportHFProvider, reportPageProvider, f2 - f4 - f5, f8, this.isPrint));
            }
            float[] fArray3 = this.DynamicValueList2FloatArray(n2, dynamicUnitList);
            PdfPTable pdfPTable = new PdfPTable(fArray3);
            pdfPTable.setSpacingBefore(0.0f);
            pdfPTable.setSpacingAfter(f3 - f11 - f8 - f9 - f6 - f7);
            pdfPTable.setTotalWidth(f10);
            pdfPTable.setLockedWidth(true);
            pdfPTable.setHorizontalAlignment(0);
            Color color = Color.white;
            pdfPTable.getDefaultCell().setBackgroundColor(color);
            pdfPTable.getDefaultCell().setBorderWidth(0.0f);
            Iterator iterator = clippedPageProvider.cellIterator();
            int n4 = -1;
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            byte[][] byArray = new byte[clippedPageProvider.getRowCount()][clippedPageProvider.getColumnCount()];
            long l2 = 0L;
            while (iterator.hasNext()) {
                if ((l2++ & 0x1FFFL) == 0L) {
                    MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
                }
                object = (CellElement)iterator.next();
                n6 = object.getRow();
                n7 = object.getColumn();
                if (n6 != 0 || n7 != 0) {
                    this.fillBlankCell(pdfPTable, byArray, n4, n5, n6, n7, dynamicUnitList2);
                }
                float f12 = f3 - f6 - f8 - fArray2[object.getRow()];
                float f13 = f4 + fArray[object.getColumn()];
                pdfPTable.addCell(this.createCellFromCellElement(pdfWriter, f13, f12, (CellElement)object, dynamicUnitList, dynamicUnitList2, this.isPrint));
                for (int i3 = 0; i3 < object.getRowSpan(); ++i3) {
                    for (int i4 = 0; i4 < object.getColumnSpan(); ++i4) {
                        byArray[n6 + i3][n7 + i4] = 1;
                    }
                }
                n4 = n6;
                n5 = n7;
            }
            this.fillBlankCell(pdfPTable, byArray, n4, n5, -1, -1, dynamicUnitList2);
            document.add((Element)pdfPTable);
            object = reportPageProvider.getFooter();
            if (f9 > 0.0f && object != null) {
                document.add((Element)this.createImageFromHFElement((ReportHFProvider)object, reportPageProvider, f2 - f4 - f5, f9, this.isPrint));
            }
            Iterator iterator2 = clippedPageProvider.floatIterator();
            while (iterator2.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator2.next();
                float f14 = f4 + floatElement.getLeftDistance_inClippedPage().toPixF(72);
                float f15 = f3 - f6 - f8 - floatElement.getTopDistance_inClippedPage().toPixF(72);
                float f16 = floatElement.getWidth().toPixF(72);
                float f17 = floatElement.getHeight().toPixF(72);
                f15 -= f17;
                java.awt.Image image = this.drawFloatImage(floatElement, (int)f16, (int)f17);
                if (image == null) continue;
                PdfContentByte pdfContentByte2 = pdfWriter.getDirectContent();
                Image image2 = Image.getInstance((java.awt.Image)image, null);
                image2.setAbsolutePosition(f14, f15);
                pdfContentByte2.addImage(image2);
            }
        }
        document.close();
    }

    private void fillBlankCell(PdfPTable pdfPTable, byte[][] byArray, int n2, int n3, int n4, int n5, DynamicUnitList dynamicUnitList) {
        int n6;
        int n7 = n6 = n2 < 0 ? 0 : n2;
        block0: while (n6 < byArray.length) {
            int n8;
            int n9 = n8 = n6 == n2 ? n3 + 1 : 0;
            while (n8 < byArray[0].length) {
                if (n6 == n4 && n8 == n5) break block0;
                if (byArray[n6][n8] == 0) {
                    pdfPTable.getDefaultCell().setFixedHeight(dynamicUnitList.get(n6).toPixF(72));
                    pdfPTable.addCell("");
                    byArray[n6][n8] = 1;
                }
                ++n8;
            }
            ++n6;
        }
    }

    private PdfPCell createCellFromCellElement(PdfWriter pdfWriter, float f2, float f3, CellElement cellElement, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, boolean bl) throws Exception {
        PdfPCell pdfPCell = new PdfPCell();
        Style style = cellElement.getStyle();
        Object object = cellElement.getValue();
        int n2 = dynamicUnitList.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan()).toPixI(72);
        int n3 = dynamicUnitList2.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan()).toPixI(72);
        pdfPCell.setColspan(cellElement.getColumnSpan());
        pdfPCell.setRowspan(cellElement.getRowSpan());
        boolean bl2 = false;
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        if (cellGUIAttr == null) {
            cellGUIAttr = new CellGUIAttr();
        }
        if (!(object instanceof java.awt.Image || bl && !cellGUIAttr.isPrintContent())) {
            Graphics2D graphics2D;
            Object object2;
            if (!(object instanceof Painter) && !(object instanceof ResultSubReport) && !(object instanceof java.awt.Image) && this.checkWriteable(style)) {
                if (object instanceof Formula) {
                    object = ((Formula)object).getResult();
                }
                object2 = Style.valueToText(object, style.getFormat());
                graphics2D = new Paragraph((String)object2, this.frFont2Font(style.getFRFont()));
                if (style.getRotation() % 90 == 0) {
                    pdfPCell.setRotation(style.getRotation());
                }
                pdfPCell.addElement((Element)graphics2D);
                bl2 = true;
            }
            if (!bl2) {
                object2 = CoreGraphHelper.createBufferedImage(n2, n3, 6);
                graphics2D = ((BufferedImage)object2).createGraphics();
                graphics2D.setPaint(Color.WHITE);
                if (object instanceof Painter || object instanceof java.awt.Image) {
                    Style.paintContent(graphics2D, object, style, n2, n3, 72);
                } else {
                    if (Color.BLACK.equals(style.getFRFont().getForeground())) {
                        style = style.deriveFRFont(style.getFRFont().applyForeground(new Color(1, 0, 0)));
                    } else if (Color.WHITE.equals(style.getFRFont().getForeground())) {
                        style = style.deriveFRFont(style.getFRFont().applyForeground(new Color(255, 255, 254)));
                    }
                    Style.paintContent(graphics2D, object, style, n2, n3, 72);
                }
                ((java.awt.Image)object2).flush();
                graphics2D.dispose();
                pdfPCell.setImage(Image.getInstance((java.awt.Image)object2, null));
            }
        }
        pdfPCell.setFixedHeight((float)n3);
        this.applyCellStyle(pdfPCell, style, bl2, object);
        return pdfPCell;
    }

    private boolean checkWriteable(Style style) {
        if (style.getVerticalText() == 1) {
            return false;
        }
        if (style.getFRFont() != null && (style.getFRFont().isShadow() || style.getFRFont().isSubscript() || style.getFRFont().isSuperscript())) {
            return false;
        }
        if (style.getTextStyle() != 0) {
            return false;
        }
        return style.getRotation() % 90 == 0;
    }

    private void applyCellStyle(PdfPCell pdfPCell, Style style, boolean bl, Object object) {
        int n2 = BaseUtils.getAlignment4Horizontal(style, object);
        switch (n2) {
            case 0: {
                pdfPCell.setHorizontalAlignment(1);
                break;
            }
            case 4: {
                pdfPCell.setHorizontalAlignment(2);
            }
        }
        switch (style.getVerticalAlignment()) {
            case 3: {
                pdfPCell.setVerticalAlignment(6);
                break;
            }
            case 0: {
                pdfPCell.setVerticalAlignment(5);
            }
        }
        pdfPCell.setPaddingLeft(new PT((float)(GraphHelper.getLineStyleSize(style.getBorderLeft()) + (bl ? style.getPaddingLeft() : 0))).toPixF(72));
        pdfPCell.setPaddingRight(new PT((float)(GraphHelper.getLineStyleSize(style.getBorderRight()) + (bl ? style.getPaddingRight() : 0))).toPixF(72));
        pdfPCell.setPaddingTop(new PT((float)GraphHelper.getLineStyleSize(style.getBorderTop())).toPixF(72));
        pdfPCell.setPaddingBottom(new PT((float)GraphHelper.getLineStyleSize(style.getBorderBottom())).toPixF(72));
        pdfPCell.setBorderWidth(0.0f);
    }

    private Image createImageFromHFElement(ReportHFProvider reportHFProvider, ReportPageProvider reportPageProvider, float f2, float f3, boolean bl) throws Exception {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f2, f3);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)f2, (int)f3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        GraphHelper.fill(graphics2D, double_);
        reportHFProvider.paint(graphics2D, double_, (int)((RectangularShape)double_).getWidth(), reportPageProvider.getCurrentPageNumber(), reportPageProvider.getTotalPages(), reportPageProvider.getFirstPage(), bl, 72);
        bufferedImage.flush();
        graphics2D.dispose();
        return Image.getInstance((java.awt.Image)bufferedImage, null);
    }

    private Font frFont2Font(FRFont fRFont) {
        int n2;
        switch (fRFont.getStyle()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (fRFont.isStrikethrough()) {
            n2 += 8;
        }
        if (fRFont.getUnderline() != 0) {
            n2 += 4;
        }
        Font font = new Font(fontMapper.awtToPdf(fRFont), (float)fRFont.getSize(), n2, fRFont.getForeground());
        return font;
    }

    private float[] DynamicValueList2FloatArray(int n2, DynamicUnitList dynamicUnitList) {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = dynamicUnitList.get(i2).toPixF(72);
        }
        return fArray;
    }

    private float[] sumDynamicValueList2Float(int n2, DynamicUnitList dynamicUnitList) {
        float f2 = 0.0f;
        float[] fArray = new float[n2 + 1];
        for (int i2 = 0; i2 < fArray.length - 1; ++i2) {
            fArray[i2 + 1] = f2 += dynamicUnitList.get(i2).toPixF(72);
        }
        return fArray;
    }

    private java.awt.Image drawFloatImage(FloatElement floatElement, int n2, int n3) {
        if (floatElement == null || n2 == 0 || n3 == 0) {
            return null;
        }
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        PaintUtils.paintFloatElement(graphics2D, floatElement, n2 - 1, n3 - 1, 72);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }
}

