/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.main.Form;
import com.fr.form.main.WidgetGatherAdapter;
import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WFitLayout;
import com.fr.form.ui.container.WLayout;
import com.fr.form.ui.container.cardlayout.ButtonNameWrapper;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCardLayout
extends WLayout {
    public static final String CARD_CHANGE = "cardchange";
    private static final String CAROUSEL_ATTR = "isCarousel";
    private static final String CAROUSEL_INTERVAL = "carouselInterval";
    private static final String CAROUSEL_ATTR_TAG = "carouselAttr";
    private int showIndex = 0;
    private transient ButtonNameWrapper btnsName;
    private transient boolean showAllCardOnInit = false;
    private boolean isCarousel = false;
    private double carouselInterval = 1.8;

    public WCardLayout() {
        this(0, 0);
    }

    public WCardLayout(int n2, int n3) {
        this.setHgap(n2);
        this.setVgap(n3);
        this.clearMargin();
    }

    public int getShowIndex() {
        return this.showIndex;
    }

    public void setShowIndex(int n2) {
        this.showIndex = n2;
    }

    public void setBtnsName(ButtonNameWrapper buttonNameWrapper) {
        this.btnsName = buttonNameWrapper;
    }

    public String getShowIndex2Name() {
        return this.getWidget(this.showIndex).getWidgetName();
    }

    public void setShowIndexByName(String string) {
        this.showIndex = this.getWidgetIndex(this.getWidget(string));
    }

    public boolean isCarousel() {
        return this.isCarousel;
    }

    public void setCarousel(boolean bl) {
        this.isCarousel = bl;
    }

    public double getCarouselInterval() {
        return this.carouselInterval;
    }

    public void setCarouselInterval(double d2) {
        this.carouselInterval = d2;
    }

    @Override
    public String[] supportedEvents() {
        return new String[]{"afterinit", CARD_CHANGE};
    }

    @Override
    public String getXType() {
        return "cardlayout";
    }

    @Override
    public String getLayoutToolTip() {
        return Inter.getLocText("FR-Designer_WLayout-Card-ToolTips");
    }

    @Override
    public Dimension getMinDesignSize() {
        Widget widget;
        if (this.getWidgetCount() > this.showIndex && (widget = this.getWidget(this.showIndex)) instanceof WLayout && widget.isVisible()) {
            return ((WLayout)widget).getMinDesignSize();
        }
        return new Dimension();
    }

    public void addWidget(Widget widget, int n2) {
        if (n2 > -1 && n2 < this.widgetList.size()) {
            this.widgetList.add(n2, widget);
        } else {
            this.widgetList.add(widget);
        }
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (this.btnsName == null) {
            return jSONObject;
        }
        jSONObject.put(CAROUSEL_ATTR, this.isCarousel);
        if (this.isCarousel) {
            jSONObject.put(CAROUSEL_INTERVAL, this.carouselInterval);
        }
        int n2 = this.btnsName.getTagCount();
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            jSONArray.put(this.btnsName.getIndexTab(i2));
        }
        jSONObject.put("allTagName", jSONArray);
        jSONObject.put("preBtnName", this.btnsName.getPreBtnName());
        jSONObject.put("nextBtnName", this.btnsName.getNextBtnName());
        jSONObject.put("titleWidth", this.btnsName.getTitleWidth());
        jSONObject.put("tagLayoutName", this.btnsName.getTagLayoutName());
        jSONObject.put("showAllCardOnInit", this.showAllCardOnInit);
        return jSONObject;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && CAROUSEL_ATTR_TAG.equals(string = xMLableReader.getTagName())) {
            this.isCarousel = xMLableReader.getAttrAsBoolean(CAROUSEL_ATTR, false);
            this.carouselInterval = xMLableReader.getAttrAsDouble(CAROUSEL_INTERVAL, 0.0);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG(CAROUSEL_ATTR_TAG).attr(CAROUSEL_ATTR, this.isCarousel).attr(CAROUSEL_INTERVAL, this.carouselInterval).end();
    }

    @Override
    public void resize(double d2, double d3, double d4) {
        if (d2 > 0.0 || d3 > 0.0) {
            this.showAllCardOnInit = true;
            List<Widget> list = this.findDelWidget();
            List<Widget> list2 = this.traversalFitInCardLayout(this);
            for (Widget widget : list2) {
                if (list.contains(widget)) continue;
                d4 = d4 == 1.0 ? -1.0 : d4;
                widget.resize(d2, d3, d4);
            }
        }
    }

    private List<Widget> findDelWidget() {
        final ArrayList arrayList = new ArrayList();
        Form.traversalWidget(this, new WidgetGatherAdapter(){

            public boolean dealWithAllCards() {
                return true;
            }

            public void dealWith(Widget widget) {
                arrayList.add((WCardLayout)widget);
            }
        }, WCardLayout.class);
        ArrayList<Widget> arrayList2 = new ArrayList<Widget>();
        for (WCardLayout wCardLayout : arrayList) {
            if (this.getWidgetName().equals(wCardLayout.getWidgetName())) continue;
            arrayList2.addAll(this.traversalFitInCardLayout(wCardLayout));
        }
        return arrayList2;
    }

    private List<Widget> traversalFitInCardLayout(WCardLayout wCardLayout) {
        final ArrayList<Widget> arrayList = new ArrayList<Widget>();
        Form.traversalWidget(wCardLayout, new WidgetGatherAdapter(){

            public boolean dealWithAllCards() {
                return true;
            }

            public void dealWith(Widget widget) {
                arrayList.add(widget);
            }
        }, WFitLayout.class);
        return arrayList;
    }
}

