/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.DataControl;
import com.fr.form.ui.RegexFieldEditor;
import com.fr.form.ui.WaterMark;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class NumberEditor
extends RegexFieldEditor
implements WaterMark,
DataControl {
    private static final int DEFAULT_MAX_INT = 32;
    private static final int DEFAULT_MAX_DEC = 16;
    private int maxIntegerLength = 32;
    private int maxDecimalLength = 16;
    private boolean allowDecimals = true;
    private boolean allowNegative = true;
    private double minValue = -1.7976931348623157E308;
    private double maxValue = Double.MAX_VALUE;
    private WidgetValue widgetValue = new WidgetValue();
    private String waterMark;

    public String getXType() {
        return "number";
    }

    public int[] getValueType() {
        return new int[]{0, 2, 3};
    }

    public void setWidgetValue(WidgetValue widgetValue) {
        this.widgetValue = widgetValue;
    }

    public WidgetValue getWidgetValue() {
        return this.widgetValue;
    }

    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        WidgetValue.createWidgetValueResult(this, calculator, jSONObject, jSONObject2);
    }

    public int getMaxIntegerLength() {
        return this.maxIntegerLength;
    }

    public void setMaxIntegerLength(int n2) {
        this.maxIntegerLength = n2;
    }

    public int getMaxDecimalLength() {
        return this.maxDecimalLength;
    }

    public void setMaxDecimalLength(int n2) {
        this.maxDecimalLength = n2;
    }

    public boolean isAllowDecimals() {
        return this.allowDecimals;
    }

    public void setAllowDecimals(boolean bl) {
        this.allowDecimals = bl;
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean bl) {
        this.allowNegative = bl;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d2) {
        if (d2 > this.maxValue) {
            return;
        }
        this.minValue = d2;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d2) {
        if (d2 < this.minValue) {
            return;
        }
        this.maxValue = d2;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        WidgetValue widgetValue = this.getWidgetValue();
        return widgetValue == null ? new String[]{} : widgetValue.dependence(calculatorProvider);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("maxIntLength", this.getMaxIntegerLength()).put("maxDecLength", this.getMaxDecimalLength());
        if (!this.isAllowDecimals()) {
            jSONObject.put("allowDecimals", this.isAllowDecimals());
        }
        if (!this.isAllowNegative()) {
            jSONObject.put("allowNegative", this.isAllowNegative());
        }
        if (this.getMinValue() != -1.7976931348623157E308) {
            jSONObject.put("minValue", this.getMinValue());
        }
        if (this.getMaxValue() != Double.MAX_VALUE) {
            jSONObject.put("maxValue", this.getMaxValue());
        }
        if (StringUtils.isNotBlank(this.waterMark)) {
            jSONObject.put("watermark", this.waterMark);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("NumberAttr")) {
                this.setMaxIntegerLength(xMLableReader.getAttrAsInt("maxIntegerLength", 32));
                this.setMaxDecimalLength(xMLableReader.getAttrAsInt("maxDecimalLength", 16));
                this.setAllowDecimals(xMLableReader.getAttrAsBoolean("allowDecimals", true));
                this.setAllowNegative(xMLableReader.getAttrAsBoolean("allowNegative", true));
                String string2 = xMLableReader.getAttrAsString("minValue", null);
                if (string2 != null) {
                    this.setMinValue(Double.parseDouble(string2));
                }
                if ((string2 = xMLableReader.getAttrAsString("maxValue", null)) != null) {
                    this.setMaxValue(Double.parseDouble(string2));
                }
            } else if ("watermark".equals(string)) {
                this.setWaterMark(xMLableReader.getElementValue());
            } else if ("widgetValue".equals(string)) {
                this.widgetValue = new WidgetValue();
                xMLableReader.readXMLObject(this.widgetValue);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("NumberAttr");
        if (this.getMaxIntegerLength() != 32) {
            xMLPrintWriter.attr("maxIntegerLength", this.getMaxIntegerLength());
        }
        if (this.getMaxDecimalLength() != 16) {
            xMLPrintWriter.attr("maxDecimalLength", this.getMaxDecimalLength());
        }
        if (!this.isAllowDecimals()) {
            xMLPrintWriter.attr("allowDecimals", this.isAllowDecimals());
        }
        if (!this.isAllowNegative()) {
            xMLPrintWriter.attr("allowNegative", this.isAllowNegative());
        }
        if (this.getMinValue() != -1.7976931348623157E308) {
            xMLPrintWriter.attr("minValue", this.getMinValue());
        }
        if (this.getMaxValue() != Double.MAX_VALUE) {
            xMLPrintWriter.attr("maxValue", this.getMaxValue());
        }
        if (StringUtils.isNotBlank(this.waterMark)) {
            xMLPrintWriter.startTAG("watermark").textNode(this.waterMark).end();
        }
        if (this.widgetValue != null) {
            this.widgetValue.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof NumberEditor && super.equals(object) && this.maxIntegerLength == ((NumberEditor)object).maxIntegerLength && this.maxDecimalLength == ((NumberEditor)object).maxDecimalLength && this.allowDecimals == ((NumberEditor)object).allowDecimals && this.allowNegative == ((NumberEditor)object).allowNegative && this.minValue == ((NumberEditor)object).minValue && this.maxValue == ((NumberEditor)object).maxValue && ComparatorUtils.equals(this.waterMark, ((NumberEditor)object).waterMark);
    }

    public String getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(String string) {
        this.waterMark = string;
    }
}

