/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseUtils;
import com.fr.base.GraphHelper;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.data.Dictionary;
import com.fr.form.ui.ButtonGroup;
import com.fr.form.ui.CheckBox;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRFont;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONUtils;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxGroup
extends ButtonGroup {
    private static final int CHECKBOX_GAP = 10;
    private static final int STRING_GAP = 2;
    private String delimiter = ",";
    private String startSymbol = "";
    private String endSymbol = "";
    private boolean returnArray = true;
    private boolean chooseAll = false;

    @Override
    public String getXType() {
        return "checkboxgroup";
    }

    public boolean isChooseAll() {
        return this.chooseAll;
    }

    public void setChooseAll(boolean bl) {
        this.chooseAll = bl;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public void setStartSymbol(String string) {
        this.startSymbol = string;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }

    public void setEndSymbol(String string) {
        this.endSymbol = string;
    }

    public boolean isReturnString() {
        return !this.returnArray;
    }

    public void setReturnString(boolean bl) {
        this.returnArray = !bl;
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (this.isChooseAll()) {
            jSONObject.put("chooseAll", true);
        }
        if (this.returnArray) {
            jSONObject.put("returnArray", true);
        }
        if (!ComparatorUtils.equals(this.delimiter, ",")) {
            jSONObject.put("delimiter", this.delimiter);
        }
        if (StringUtils.isNotEmpty(this.startSymbol)) {
            jSONObject.put("startSymbol", this.startSymbol);
        }
        if (StringUtils.isNotEmpty(this.endSymbol)) {
            jSONObject.put("endSymbol", this.endSymbol);
        }
        if (!ArrayUtils.isEmpty(this.dependence(calculator))) {
            jSONObject.put("dependence", this.dependence(calculator));
        }
        return jSONObject;
    }

    @Override
    public BufferedImage toImage(Object object, int n2, int n3, Style style) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3);
        Graphics graphics = bufferedImage.getGraphics();
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        Dictionary dictionary = this.getDictionary();
        if (dictionary == null) {
            return null;
        }
        if (object instanceof ResultFormula) {
            object = ((ResultFormula)object).getResult();
        }
        Iterator iterator = dictionary.entrys(null);
        BufferedImage bufferedImage2 = CoreGraphHelper.createBufferedImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        FRFont fRFont = style.getFRFont();
        Font font = fRFont.applyResolutionNP(96);
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        this.paintImageMoved(fontMetrics, graphics2D, iterator, object, bufferedImage2, font, style, rectangle.width);
        GraphHelper.paintImageMoved(graphics, rectangle.width, rectangle.height, bufferedImage2, 1);
        return bufferedImage;
    }

    private void paintImageMoved(FontMetrics fontMetrics, Graphics2D graphics2D, Iterator<Dictionary.MV> iterator, Object object, BufferedImage bufferedImage, Font font, Style style, double d2) {
        int n2 = 10;
        int n3 = this.getColumnsInRow();
        int n4 = fontMetrics.getHeight() / 2;
        int n5 = 0;
        while (iterator.hasNext()) {
            if (n3 > 0 && n5 >= n3) {
                n2 = 10;
                n4 += fontMetrics.getHeight();
                n4 += 2;
                n5 = 0;
            }
            Dictionary.MV mV = iterator.next();
            Image image = this.getCheckBoxImage(object, mV);
            graphics2D.drawImage(image, n2, n4, null);
            n2 += 13;
            String string = String.valueOf(mV.getView());
            double d3 = d2 - (double)(n2 += 2);
            List list = BaseUtils.getLineTextList(string, style, font, d3);
            int n6 = list.size();
            for (int i2 = 0; i2 < n6; ++i2) {
                String string2 = (String)list.get(i2);
                if (i2 != 0) {
                    n4 += fontMetrics.getHeight();
                }
                this.paintShowValue(string2, graphics2D, font, fontMetrics, n2, n4);
            }
            n2 += fontMetrics.stringWidth(string);
            n2 += 10;
            ++n5;
        }
        bufferedImage.flush();
    }

    private Image getCheckBoxImage(Object object, Dictionary.MV mV) {
        if ((object = this.convertStringToFArray(object)) instanceof FArray) {
            return this.dealFArray((FArray)object, mV);
        }
        return ComparatorUtils.equals(object, mV.getModel()) ? CheckBox.CHECK_ON : CheckBox.CHECK_OFF;
    }

    private Image dealFArray(FArray fArray, Dictionary.MV mV) {
        int n2 = fArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object t2 = fArray.elementAt(i2);
            if (!ComparatorUtils.equals(t2, mV.getModel())) continue;
            return CheckBox.CHECK_ON;
        }
        return CheckBox.CHECK_OFF;
    }

    private Object convertStringToFArray(Object fArray) {
        if (fArray instanceof String && ((String)((Object)fArray)).indexOf(this.delimiter) != -1) {
            String[] stringArray = ((String)((Object)fArray)).split(Pattern.quote(this.delimiter));
            fArray = new FArray<String>(stringArray);
        }
        return fArray;
    }

    private void paintShowValue(String string, Graphics graphics, Font font, FontMetrics fontMetrics, int n2, int n3) {
        Color color = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setFont(font);
        graphics.setColor(Color.BLACK);
        graphics.drawString(string, n2, n3 + fontMetrics.getHeight() / 2 + 2);
        graphics.setColor(color);
        graphics.setFont(font2);
    }

    @Override
    public Object dealWithPresentableValue(String string) throws Exception {
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            JSONArray jSONArray = (JSONArray)JSONUtils.jsonDecode(string);
            return jSONArray;
        }
        return string;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("RAAttr")) {
                this.returnArray = false;
                if (xMLableReader.getAttrAsString("delimiter", null) != null) {
                    this.delimiter = xMLableReader.getAttrAsString("delimiter", null);
                }
                if (xMLableReader.getAttrAsString("start", null) != null) {
                    this.startSymbol = xMLableReader.getAttrAsString("start", null);
                }
                if (xMLableReader.getAttrAsString("end", null) != null) {
                    this.endSymbol = xMLableReader.getAttrAsString("end", null);
                }
            } else if (xMLableReader.getTagName().equals("ChooseAll")) {
                this.setChooseAll(true);
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!this.returnArray) {
            xMLPrintWriter.startTAG("RAAttr").attr("isArray", this.returnArray);
            if (!",".equals(this.delimiter)) {
                xMLPrintWriter.attr("delimiter", this.delimiter);
            }
            if (StringUtils.isNotEmpty(this.startSymbol)) {
                xMLPrintWriter.attr("start", this.startSymbol);
            }
            if (StringUtils.isNotEmpty(this.endSymbol)) {
                xMLPrintWriter.attr("end", this.endSymbol);
            }
            xMLPrintWriter.end();
        }
        if (this.isChooseAll()) {
            xMLPrintWriter.startTAG("ChooseAll").end();
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CheckBoxGroup && super.equals(object) && ComparatorUtils.equals(this.delimiter, ((CheckBoxGroup)object).delimiter) && this.returnArray == ((CheckBoxGroup)object).returnArray && super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 7;
        n2 = 13 * n2 + (this.delimiter != null ? this.delimiter.hashCode() : 0);
        n2 = 13 * n2 + (this.startSymbol != null ? this.startSymbol.hashCode() : 0);
        n2 = 13 * n2 + (this.endSymbol != null ? this.endSymbol.hashCode() : 0);
        n2 = 13 * n2 + (this.returnArray ? 1 : 0);
        return n2 += super.hashCode();
    }
}

