/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.AbstractTableData;
import com.fr.base.MultiFieldParameter;
import com.fr.base.Parameter;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.general.ManagerFactory;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class MultiFieldTableData
extends AbstractTableData {
    private MultiFieldParameter multiPara;
    private int id;
    private String autoIncParaName;

    public MultiFieldTableData(MultiFieldParameter multiFieldParameter) {
        this(multiFieldParameter, null, -1);
    }

    public MultiFieldTableData(MultiFieldParameter multiFieldParameter, String string, int n2) {
        this.multiPara = multiFieldParameter;
        this.autoIncParaName = string;
        this.id = n2;
    }

    public DataModel createDataModel(Calculator calculator) {
        return new MultiFieldDataModel();
    }

    public DataModel createDataModel(Calculator calculator, String string) {
        return this.createDataModel(calculator);
    }

    public DataModel createDataModel(Calculator calculator, int n2) {
        return this.createDataModel(calculator);
    }

    public Parameter[] getParameters(Calculator calculator) {
        return new Parameter[0];
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public Object clone() throws CloneNotSupportedException {
        MultiFieldTableData multiFieldTableData = (MultiFieldTableData)super.clone();
        multiFieldTableData.multiPara = (MultiFieldParameter)this.multiPara.clone();
        return multiFieldTableData;
    }

    private Connection createConnection() {
        return PlatformDB4MultiFieldData.getDB();
    }

    private String createSqlString() {
        return "select " + this.multiPara.getName() + " from FR_T_" + this.multiPara.getProcessName().toUpperCase() + (this.autoIncParaName == null || this.id == -1 ? "" : " where " + this.autoIncParaName + "=" + this.id);
    }

    private static class PlatformDB4MultiFieldData {
        private static JDBCDatabaseConnection db = null;

        private PlatformDB4MultiFieldData() {
        }

        public static JDBCDatabaseConnection getDB() {
            if (db == null) {
                PlatformDB4MultiFieldData.refreshDB();
            }
            return db;
        }

        private static synchronized void refreshDB() {
            db = (JDBCDatabaseConnection)ManagerFactory.getConfigProvider().getPlatformConnection();
            if (db == null) {
                db = DBUtils.getEmbeddedDB("finedb", 2);
            }
        }
    }

    private class MultiFieldDataModel
    extends AbstractDBDataModel {
        private JSONArray ja;
        private String[] names;

        public MultiFieldDataModel() {
            super(MultiFieldTableData.this.createConnection(), MultiFieldTableData.this.createSqlString());
        }

        protected void initRowValueStatus() {
            this.names = MultiFieldTableData.this.multiPara.getAllFiledName().toArray(new String[0]);
            try {
                if (this.resultSet.next()) {
                    String string = this.resultSet.getString(1);
                    this.ja = new JSONArray(string.replaceAll("\n", "<br/>"));
                }
            }
            catch (Exception exception) {
                this.ja = new JSONArray();
            }
            int n2 = this.names.length;
            this.columnInformations = new ColumnInformation[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.columnInformations[i2] = new ColumnInformation(this.names[i2], 1, "String", 255);
            }
        }

        public int getRowCount() throws TableDataException {
            return this.ja.length();
        }

        public Object getValueAt(int n2, int n3) throws TableDataException {
            if (this.hasRow(n2)) {
                try {
                    JSONObject jSONObject = (JSONObject)this.ja.get(n2);
                    return jSONObject.getString(this.columnInformations[n3].getColumnName());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

