/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.TemplateUtils;
import com.fr.data.impl.AbstractDatabaseConnection;
import com.fr.data.pool.DBCPConnectionPoolAttr;
import com.fr.data.pool.MemoryConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.sql.Connection;

public class JDBCDatabaseConnection
extends AbstractDatabaseConnection {
    private String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String url = "";
    private String user = "";
    private String password = "";
    private DBCPConnectionPoolAttr dbcpAttr = null;
    private boolean encryptPassword = true;

    public JDBCDatabaseConnection() {
        this("", "", "", "");
    }

    public JDBCDatabaseConnection(String string, String string2, String string3, String string4) {
        this.setDriver(string);
        this.setURL(string2);
        this.setUser(string3);
        this.setPassword(string4);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isEncryptPassword() {
        return this.encryptPassword;
    }

    public void setEncryptPassword(boolean bl) {
        this.encryptPassword = bl;
    }

    public DBCPConnectionPoolAttr getDbcpAttr() {
        return this.dbcpAttr;
    }

    public void setDbcpAttr(DBCPConnectionPoolAttr dBCPConnectionPoolAttr) {
        this.dbcpAttr = dBCPConnectionPoolAttr;
    }

    public void testConnection() throws Exception {
        this.createConnection().close();
    }

    public Connection createConnection() throws Exception {
        return MemoryConnection.create(JDBCDatabaseConnection.renderAttribute(this.getDriver()), JDBCDatabaseConnection.renderAttribute(this.getURL()), JDBCDatabaseConnection.renderAttribute(this.getUser()), JDBCDatabaseConnection.renderAttribute(this.getPassword()), this.dbcpAttr);
    }

    private static String renderAttribute(String string) {
        if (string != null) {
            try {
                return TemplateUtils.render(string);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return string;
    }

    public String feature() {
        return this.url;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("driver", this.getDriver());
        jSONObject.put("url", this.getURL());
        jSONObject.put("user", this.getUser());
        jSONObject.put("password", this.getPassword());
        jSONObject.put("originalCharsetName", StringUtils.alwaysNotNull(this.getOriginalCharsetName()));
        jSONObject.put("newCharsetName", StringUtils.alwaysNotNull(this.getNewCharsetName()));
        return jSONObject;
    }

    public boolean hasSchema() {
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JDBCDatabaseConnection)) {
            return false;
        }
        JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)object;
        return super.equals(jDBCDatabaseConnection) && ComparatorUtils.equals(this.driver, jDBCDatabaseConnection.driver) && ComparatorUtils.equals(this.url, jDBCDatabaseConnection.url) && ComparatorUtils.equals(this.user, jDBCDatabaseConnection.user) && ComparatorUtils.equals(this.password, jDBCDatabaseConnection.password) && ComparatorUtils.equals(this.encryptPassword, jDBCDatabaseConnection.encryptPassword) && ComparatorUtils.equals(this.dbcpAttr, jDBCDatabaseConnection.dbcpAttr);
    }

    public Object clone() throws CloneNotSupportedException {
        JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)super.clone();
        jDBCDatabaseConnection.driver = this.driver;
        jDBCDatabaseConnection.url = this.url;
        jDBCDatabaseConnection.user = this.user;
        jDBCDatabaseConnection.password = this.password;
        jDBCDatabaseConnection.encryptPassword = this.encryptPassword;
        if (this.dbcpAttr != null) {
            jDBCDatabaseConnection.dbcpAttr = (DBCPConnectionPoolAttr)this.dbcpAttr.clone();
        }
        return jDBCDatabaseConnection;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = 37 * n2 + this.getDriver().hashCode();
        n2 = 37 * n2 + this.getURL().hashCode();
        n2 = 37 * n2 + this.getUser().hashCode();
        n2 = 37 * n2 + this.getPassword().hashCode();
        n2 = 37 * n2 + (this.isEncryptPassword() ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "[JDBCDatabase][Driver:" + this.getDriver() + "][URL:" + this.getURL() + "][User:" + this.getUser() + "][Password:***]";
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "JDBCDatabaseAttr".equals(xMLableReader.getTagName())) {
            String string = xMLableReader.getAttrAsString("driver", null);
            if (string != null) {
                this.setDriver(string);
            }
            if ((string = xMLableReader.getAttrAsString("url", null)) != null) {
                this.setURL(string);
            }
            if ((string = xMLableReader.getAttrAsString("user", null)) != null) {
                this.setUser(string);
            }
            if ((string = xMLableReader.getAttrAsString("password", null)) != null) {
                this.setPassword(CodeUtils.passwordDecode(string));
            }
            this.setEncryptPassword(xMLableReader.getAttrAsBoolean("encryptPassword", true));
            DBCPConnectionPoolAttr dBCPConnectionPoolAttr = new DBCPConnectionPoolAttr();
            this.setDbcpAttr(dBCPConnectionPoolAttr);
            xMLableReader.readXMLObject(dBCPConnectionPoolAttr);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("JDBCDatabaseAttr").attr("url", this.getURL()).attr("driver", this.getDriver()).attr("user", this.getUser());
        if (this.isEncryptPassword()) {
            xMLPrintWriter.attr("password", CodeUtils.passwordEncode(this.getPassword()));
        } else {
            xMLPrintWriter.attr("password", this.getPassword());
        }
        xMLPrintWriter.attr("encryptPassword", this.isEncryptPassword());
        if (this.getDbcpAttr() != null) {
            this.getDbcpAttr().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }
}

