/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.base.BaseScriptUtils;
import com.fr.cache.list.IntList;
import com.fr.data.SingleRowNameSpace;
import com.fr.data.condition.AbstractCondition;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.general.data.EvalFormulaAction;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONObject;
import com.fr.script.CurrentValueNameSpace;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class FormulaCondition
extends AbstractCondition {
    private String formulaContent;

    public FormulaCondition() {
    }

    public FormulaCondition(String string) {
        this.formulaContent = string;
    }

    public String getFormula() {
        return this.formulaContent;
    }

    public void setFormula(String string) {
        this.formulaContent = string;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        return BaseScriptUtils.getDependenceByFormula(this.formulaContent);
    }

    public void modColumnRow(ModColumnRowProvider modColumnRowProvider) {
        this.formulaContent = modColumnRowProvider.mod_fm_statement(this.formulaContent);
    }

    public boolean eval(Object object, CalculatorProvider calculatorProvider) {
        return this.eval(object, calculatorProvider, EvalFormulaAction.EVAL_STRING);
    }

    public boolean eval(Object object, CalculatorProvider calculatorProvider, EvalFormulaAction evalFormulaAction) {
        if (object instanceof FormulaProvider) {
            object = ((FormulaProvider)object).getResult();
        }
        CurrentValueNameSpace currentValueNameSpace = new CurrentValueNameSpace(object);
        calculatorProvider.pushNameSpace(currentValueNameSpace);
        boolean bl = false;
        try {
            Object object2 = evalFormulaAction.eval(calculatorProvider, this.getFormula());
            bl = ComparatorUtils.equals(Boolean.TRUE, object2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        calculatorProvider.removeNameSpace(currentValueNameSpace);
        return bl;
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        exTool.setCreateRelation(true);
        calculatorProvider.exStatement(columnRow, this.getPureFormulaContent());
        exTool.setCreateRelation(false);
    }

    private String getPureFormulaContent() {
        return this.formulaContent.startsWith("=") ? this.formulaContent.substring(1) : this.formulaContent;
    }

    public int[] evalTableData(DataModel dataModel, int[] nArray, int n2, CalculatorProvider calculatorProvider) {
        nArray = super.getFilterRows(dataModel, n2, nArray, calculatorProvider);
        if (dataModel == null || calculatorProvider == null) {
            return new int[0];
        }
        int n3 = 0;
        try {
            n3 = dataModel.getRowCount();
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        if (nArray == null) {
            nArray = IntList.range(n3);
        }
        IntList intList = new IntList();
        SingleRowNameSpace singleRowNameSpace = new SingleRowNameSpace(dataModel, Integer.MIN_VALUE, null);
        calculatorProvider.pushNameSpace(singleRowNameSpace);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n4 = nArray[i2];
            if (n4 < 0 || n4 >= n3) continue;
            try {
                singleRowNameSpace.setRowIndex(n4);
                singleRowNameSpace.setCurrentValue(dataModel.getValueAt(n4, n2));
                if (!ComparatorUtils.equals(Boolean.TRUE, calculatorProvider.evalValue(this.getFormula()))) continue;
                intList.add(n4);
                continue;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        calculatorProvider.removeNameSpace(singleRowNameSpace);
        return intList.toArray();
    }

    public String toString() {
        return this.formulaContent;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FormulaCondition)) {
            return false;
        }
        FormulaCondition formulaCondition = (FormulaCondition)object;
        return ComparatorUtils.equals(formulaCondition.getFormula(), this.getFormula());
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "Formula".equals(xMLableReader.getTagName()) && StringUtils.isNotBlank(string = xMLableReader.getElementValue())) {
            this.formulaContent = string.startsWith("=") ? string.substring(1) : string;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.formulaContent)) {
            xMLPrintWriter.startTAG("Formula").textNode(this.getFormula()).end();
        }
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
    }
}

