/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.cache;

import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.cluster.stable.ClusterState;
import com.fr.data.cache.DelegateAttachment;
import com.fr.data.core.db.handler.BlobDelegate;
import com.fr.file.BaseClusterHelper;
import com.fr.file.ClusterConfigManager;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.general.http.HttpClient;
import com.fr.stable.AttachmentIDCreator;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class AttachmentCacheManager {
    public static Attachment addAttachment(String string, String string2, byte[] byArray) {
        return AttachmentCacheManager.addAttachment(string, string2, byArray, 0, 0);
    }

    public static Attachment addAttachment(String string, String string2, BlobDelegate blobDelegate) {
        return AttachmentCacheManager.addAttachment(string, string2, blobDelegate, 0, 0);
    }

    public static Attachment addAttachment(String string, String string2, byte[] byArray, int n2, int n3) {
        String string3 = StableFactory.getMarkedObject("AttachmentIDCreator", AttachmentIDCreator.class).createID();
        Attachment attachment = new Attachment(string3, string, string2, byArray, n2, n3);
        AttachmentSource.putAttachment(string3, attachment);
        return attachment;
    }

    public static Attachment addAttachment(String string, String string2, BlobDelegate blobDelegate, int n2, int n3) {
        String string3 = StableFactory.getMarkedObject("AttachmentIDCreator", AttachmentIDCreator.class).createID();
        DelegateAttachment delegateAttachment = new DelegateAttachment(string3, string, string2, new byte[0], n2, n3);
        delegateAttachment.setDelegate(blobDelegate);
        AttachmentSource.putDelegateAttachment(string3, delegateAttachment);
        return delegateAttachment;
    }

    public static Attachment getAttachment(String string) {
        Attachment attachment = AttachmentSource.getAttachment(string);
        if (attachment != null) {
            return attachment;
        }
        if (BaseClusterHelper.getClusterState() != ClusterState.CLOSED) {
            return AttachmentCacheManager.findAttachmentFormOtherMachine(string);
        }
        return attachment;
    }

    private static Attachment findAttachmentFormOtherMachine(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("_");
        String string3 = string2 = stringArray.length > 0 ? stringArray[0] : "";
        if (StringUtils.isEmpty(string2)) {
            return null;
        }
        String string4 = ClusterConfigManager.getServiceURL(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_attach");
        hashMap.put("cmd", "ah_download");
        hashMap.put("id", string);
        HttpClient httpClient = new HttpClient(string4, hashMap);
        InputStream inputStream = httpClient.getResponseStream();
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copyBinaryTo(inputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Attachment attachment = new Attachment(string, "image", string, byArray);
        AttachmentSource.putAttachment(string, attachment);
        return attachment;
    }
}

