/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.Shadow;
import com.fr.chart.chartglyph.HighLightChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class StackedBarHighLightStyle
extends HighLightChart {
    protected static final int SHADOW_WIDTH = 6;
    private Rectangle2D rect;
    private Rectangle2D totalRect;
    private boolean isHorizontal;
    private boolean isTop = false;
    private boolean axisReversed;
    private Shadow shadow;
    private boolean firstDraw = false;

    public StackedBarHighLightStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2, boolean bl3) {
        this.baseColor = color;
        this.rect = rectangle2D;
        this.totalRect = rectangle2D;
        this.isHorizontal = bl;
        this.avoidOriginDraw = bl2;
        this.axisReversed = bl3;
        this.shadow = new Shadow(new Color(0.77f, 0.77f, 0.77f), 12, 0.75f);
    }

    public void paintStyle(Graphics graphics) {
        if (this.baseColor == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        double d2 = this.rect.getWidth();
        double d3 = this.rect.getHeight();
        if (d2 <= 6.0 || d3 <= 6.0) {
            graphics2D.setPaint(this.baseColor);
            graphics2D.fill(this.rect);
            graphics2D.setPaint(paint);
            return;
        }
        if (this.isHorizontal) {
            this.horizontalPaint(graphics2D);
        } else {
            this.verticalPaint(graphics2D);
        }
    }

    private void verticalPaint(Graphics2D graphics2D) {
        Object object;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        double d2 = this.totalRect.getX();
        double d3 = this.totalRect.getY();
        double d4 = this.totalRect.getWidth();
        double d5 = this.totalRect.getHeight();
        if (this.firstDraw) {
            object = new Rectangle2D.Double(d2 - 6.0, d3 - 6.0, d4 + 6.0, d5 + 6.0);
            this.shadow.paint(graphics2D, (Shape)object);
        }
        object = this.axisReversed ? new GradientPaint((float)d2, (float)(d3 + d5), this.getPaintStartColor(), (float)d2, (float)d3, this.getPaintEndColor()) : new GradientPaint((float)d2, (float)d3, this.getPaintStartColor(), (float)d2, (float)(d3 + d5), this.getPaintEndColor());
        graphics2D.setPaint((Paint)object);
        graphics2D.fill(this.rect);
        if (this.isTop) {
            object = this.axisReversed ? new GradientPaint((float)d2, (float)(d3 + d5), this.getHighLightStartColor(), (float)d2, (float)d3, this.getHighLightEndColor()) : new GradientPaint((float)d2, (float)d3, this.getHighLightStartColor(), (float)d2, (float)(d3 + d5), this.getHighLightEndColor());
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(this.getHighLightShape());
            graphics2D.setPaint(Color.WHITE);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(this.totalRect);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private void horizontalPaint(Graphics2D graphics2D) {
        Object object;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        double d2 = this.totalRect.getX();
        double d3 = this.totalRect.getY();
        double d4 = this.totalRect.getWidth();
        double d5 = this.totalRect.getHeight();
        if (this.firstDraw) {
            object = new Rectangle2D.Double(d2 - 6.0, d3 - 6.0, d4 + 6.0, d5 + 6.0);
            this.shadow.paint(graphics2D, (Shape)object);
        }
        object = this.axisReversed ? new GradientPaint((float)d2, (float)d3, this.getPaintStartColor(), (float)(d2 + d4), (float)d3, this.getPaintEndColor()) : new GradientPaint((float)(d2 + d4), (float)d3, this.getPaintStartColor(), (float)d2, (float)d3, this.getPaintEndColor());
        graphics2D.setPaint((Paint)object);
        graphics2D.fill(this.rect);
        if (this.isTop) {
            object = this.axisReversed ? new GradientPaint((float)d2, (float)d3, this.getHighLightStartColor(), (float)(d2 + d4), (float)d3, this.getHighLightEndColor()) : new GradientPaint((float)(d2 + d4), (float)d3, this.getHighLightStartColor(), (float)d2, (float)d3, this.getHighLightEndColor());
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(this.getHighLightShape());
            graphics2D.setPaint(Color.WHITE);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(this.totalRect);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private Shape getHighLightShape() {
        GeneralPath generalPath = new GeneralPath();
        float f2 = (float)this.totalRect.getX();
        float f3 = (float)this.totalRect.getY();
        float f4 = (float)this.totalRect.getWidth();
        float f5 = (float)this.totalRect.getHeight();
        if (this.isHorizontal) {
            if (this.axisReversed) {
                generalPath.moveTo(f2, f3 + f5 * 2.0f / 3.0f);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2 + f4, f3);
            } else {
                generalPath.moveTo(f2, f3);
                generalPath.lineTo(f2 + f4, f3);
                generalPath.lineTo(f2 + f4, f3 + f5 * 2.0f / 3.0f);
            }
            generalPath.closePath();
        } else {
            if (this.axisReversed) {
                generalPath.moveTo(f2, f3);
                generalPath.lineTo(f2, f3 + f5);
                generalPath.lineTo(f2 + f4 * 2.0f / 3.0f, f3 + f5);
            } else {
                generalPath.moveTo(f2, f3 + f5);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2 + f4 * 2.0f / 3.0f, f3);
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    public void setTotalRect(Rectangle2D rectangle2D) {
        this.totalRect = rectangle2D;
    }

    public void setIsTop(boolean bl) {
        this.isTop = bl;
    }

    public void setFirstDraw(boolean bl) {
        this.firstDraw = bl;
    }

    public Color getPaintStartColor() {
        return this.baseColor.brighter();
    }

    public Color getPaintEndColor() {
        return this.baseColor;
    }

    public Color getHighLightStartColor() {
        return new Color(1.0f, 1.0f, 1.0f, 0.6f);
    }

    public Color getHighLightEndColor() {
        return new Color(1.0f, 1.0f, 1.0f, 0.0f);
    }
}

