/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.ChartComparatorUtils;
import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.GeneralGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.Pie3D;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.GeneralPath;

public class DataPoint4Pie
extends DataPoint {
    private static final long serialVersionUID = -5433212446915904894L;
    private GeneralPath leadLine;
    private boolean isShowLabel = true;
    private String showText;

    public void setLeadLine(GeneralPath generalPath) {
        this.leadLine = generalPath;
    }

    public GeneralPath getLeadLine() {
        return this.leadLine;
    }

    public String getType() {
        return "DataPoint4Pie";
    }

    public void setDataLabel(TextGlyph textGlyph) {
        super.setDataLabel(textGlyph);
        this.showText = textGlyph.text;
    }

    public void drawLabel(Graphics graphics, int n2) {
        if (this.isValueIsNull() || !this.isShowLabel) {
            return;
        }
        if (this.getDataLabel() == null) {
            return;
        }
        String string = this.getDataLabel().getText();
        this.getDataLabel().setText(this.showText);
        super.drawLabel(graphics, n2);
        this.getDataLabel().setText(string);
        if (this.getDataLabel() != null && this.getLeadLine() != null) {
            ShapeGlyph shapeGlyph;
            GeneralInfo generalInfo;
            Background background;
            Color color = graphics.getColor();
            Glyph glyph = this.getDrawImpl();
            if (glyph instanceof Pie3D) {
                Pie3D pie3D = (Pie3D)glyph;
                Cylinder cylinder = pie3D.getCylinder(0);
                if (cylinder != null && cylinder.getColorInfo() != null) {
                    ColorInfo colorInfo = cylinder.getColorInfo();
                    Color color2 = colorInfo.getSeriesAttrColor() != null ? colorInfo.getSeriesAttrColor().getSeriesColor() : Color.gray;
                    graphics.setColor(color2);
                }
            } else if (glyph instanceof ShapeGlyph && (background = (generalInfo = (shapeGlyph = (ShapeGlyph)glyph).getGeneralInfo()).getBackground()) instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
                graphics.setColor(((ColorBackground)background).getColor());
            }
            GraphHelper.draw(graphics, this.getLeadLine(), 1);
            graphics.setColor(color);
        }
    }

    public boolean equals(Object object) {
        return object instanceof DataPoint4Pie && ChartComparatorUtils.equals(this.leadLine, ((DataPoint4Pie)object).leadLine) && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)super.clone();
        dataPoint4Pie.leadLine = (GeneralPath)this.leadLine.clone();
        return dataPoint4Pie;
    }

    public void draw(Graphics graphics, int n2) {
        ChartStyle chartStyle = this.getDataPointStyle();
        if (!(chartStyle != null && chartStyle.isAvoidOriginDraw() || this.getDrawImpl() == null)) {
            ((GeneralGlyph)this.getDrawImpl()).drawWithOutBorder(graphics, n2);
        }
        if (chartStyle != null) {
            chartStyle.paintStyle(graphics);
        }
    }

    public boolean isBorderDefault() {
        ChartStyle chartStyle = this.getDataPointStyle();
        if (!(chartStyle != null && chartStyle.isAvoidOriginDraw() || this.getDrawImpl() == null)) {
            GeneralGlyph generalGlyph = (GeneralGlyph)this.getDrawImpl();
            return ComparatorUtils.equals(generalGlyph.getBorderColor(), Color.WHITE) || ComparatorUtils.equals(generalGlyph.getBorderStyle(), 1);
        }
        return true;
    }

    public void drawOnlyBorder(Graphics graphics, int n2) {
        ChartStyle chartStyle = this.getDataPointStyle();
        if (!(chartStyle != null && chartStyle.isAvoidOriginDraw() || this.getDrawImpl() == null)) {
            ((GeneralGlyph)this.getDrawImpl()).drawOnlyBorder(graphics, n2);
        }
    }

    public boolean isShowLabel() {
        return this.isShowLabel;
    }

    public void setShowLabel(boolean bl) {
        this.isShowLabel = bl;
    }

    public void setShowText(String string) {
        this.showText = string;
    }

    public String getShowText() {
        return this.showText;
    }
}

