/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartCustomRendererType;
import com.fr.chart.chartglyph.AreaPlotGlyph;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.Bar3DPlotGlyph;
import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSeries4Area;
import com.fr.chart.chartglyph.LinePlotGlyph;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;

public class CustomPlotGlyph
extends CategoryPlotGlyph
implements Plot3DGlyph {
    private static final long serialVersionUID = -717908304255012814L;
    private static final double STA_SERIES_GAP = -0.25;
    private static final double STA_CATEGORY_GAP = 1.0;
    private double seriesOverlapPercent = -0.25;
    private double categoryIntervalPercent = 1.0;
    private int deepBase = -1;
    private int deep = -1;
    private Projection projection = new Projection();
    private boolean has3DShape = false;
    private Bar2DPlotGlyph bar2DPlotGlyph;
    private Bar2DPlotGlyph bar2DPlotGlyphStack;
    private Bar3DPlotGlyph bar3DPlotGlyph;
    private Bar3DPlotGlyph bar3DPlotGlyphStack;
    private LinePlotGlyph linePlotGlyph;
    private AreaPlotGlyph areaPlotGlyphStack;
    private ConditionCollection customTypeCondition = new ConditionCollection();
    private Integer[][] stackedList = null;
    private int normalBarCount = 0;

    public void setBar2DPlotGlyph(Bar2DPlotGlyph bar2DPlotGlyph) {
        this.bar2DPlotGlyph = bar2DPlotGlyph;
    }

    public void setBar2DPlotGlyphStack(Bar2DPlotGlyph bar2DPlotGlyph) {
        this.bar2DPlotGlyphStack = bar2DPlotGlyph;
    }

    public void setLinePlotGlyph(LinePlotGlyph linePlotGlyph) {
        this.linePlotGlyph = linePlotGlyph;
    }

    public void setAreaPlotGlyphStack(AreaPlotGlyph areaPlotGlyph) {
        this.areaPlotGlyphStack = areaPlotGlyph;
    }

    public void setCustomTypeCondition(ConditionCollection conditionCollection) {
        this.customTypeCondition = conditionCollection;
    }

    public ConditionCollection getCustomTypeCondition() {
        return this.customTypeCondition;
    }

    public void setBar3DPlotGlyph(Bar3DPlotGlyph bar3DPlotGlyph) {
        this.bar3DPlotGlyph = bar3DPlotGlyph;
    }

    public void setBar3DPlotGlyphStack(Bar3DPlotGlyph bar3DPlotGlyph) {
        this.bar3DPlotGlyphStack = bar3DPlotGlyph;
    }

    public void setHas3DShape(boolean bl) {
        this.has3DShape = bl;
    }

    public int getDeepBase() {
        return this.deepBase;
    }

    public void set3DDeepBase(int n2) {
        this.deepBase = n2;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public int getDeep() {
        return this.deep;
    }

    protected int get3DDeep(Plot3DGlyph plot3DGlyph) {
        return 100;
    }

    public boolean isNeedDefaultDeep() {
        return true;
    }

    public void setCategoryIntervalPercent(double d2) {
        this.categoryIntervalPercent = d2;
    }

    public void setSeriesOverlapPercent(double d2) {
        this.seriesOverlapPercent = d2;
    }

    public void layoutAxisGlyph(int n2) {
        this.setBounds4EachPlot(this.bar2DPlotGlyph, this.bounds);
        this.setBounds4EachPlot(this.bar2DPlotGlyphStack, this.bounds);
        this.setBounds4EachPlot(this.linePlotGlyph, this.bounds);
        this.setBounds4EachPlot(this.areaPlotGlyphStack, this.bounds);
        this.setBounds4EachPlot(this.bar3DPlotGlyph, this.bounds);
        this.setBounds4EachPlot(this.bar3DPlotGlyphStack, this.bounds);
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), this.has3DShape, n2);
        this.layoutAxisGlyph4EachPlot(this.bar2DPlotGlyph, false, n2);
        this.layoutAxisGlyph4EachPlot(this.bar2DPlotGlyphStack, false, n2);
        this.layoutAxisGlyph4EachPlot(this.linePlotGlyph, false, n2);
        this.layoutAxisGlyph4EachPlot(this.areaPlotGlyphStack, false, n2);
        this.layoutAxisGlyph4EachPlot(this.bar3DPlotGlyph, true, n2);
        this.layoutAxisGlyph4EachPlot(this.bar3DPlotGlyphStack, true, n2);
    }

    private void setBounds4EachPlot(PlotGlyph plotGlyph, RectangularShape rectangularShape) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangularShape.getX(), rectangularShape.getY(), rectangularShape.getWidth(), rectangularShape.getHeight());
        plotGlyph.setBounds(double_);
    }

    private void layoutAxisGlyph4EachPlot(CategoryPlotGlyph categoryPlotGlyph, boolean bl, int n2) {
        categoryPlotGlyph.layoutDoubleAxisGlyph(categoryPlotGlyph.getxAxisGlyph(), categoryPlotGlyph.getyAxisGlyph(), categoryPlotGlyph.getSecondAxisGlyph(), bl, n2);
    }

    public void draw(Graphics graphics, int n2) {
        if (this.has3DShape) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.draw3DInfo(graphics, n2);
            this.drawAxisGlyph4ThreeD(this.getyAxisGlyph(), graphics, n2);
            this.drawAxisGlyph4ThreeD(this.getSecondAxisGlyph(), graphics, n2);
            graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
            this.drawAxisGlyph4ThreeD(this.getxAxisGlyph(), graphics, n2);
            this.drawShape4Series(graphics, n2);
            this.drawLabel4Series(graphics, n2);
            graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        } else {
            super.draw(graphics, n2);
        }
    }

    public void layoutDataSeriesGlyph(int n2) {
        Cloneable cloneable;
        int n3;
        this.normalBarCount = 0;
        for (n3 = 0; n3 < this.getSeriesSize(); ++n3) {
            cloneable = (CustomAttr)this.getCustomTypeCondition().getAttrByResult(this.getSeries(n3));
            ChartCustomRendererType chartCustomRendererType = ((CustomAttr)cloneable).getUseRenderer();
            if (chartCustomRendererType != ChartCustomRendererType.BAR_RENDERER && chartCustomRendererType != ChartCustomRendererType.BAR3D) continue;
            ++this.normalBarCount;
        }
        n3 = 0;
        cloneable = new ArrayList();
        int n4 = this.customTypeCondition.getConditionAttrSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getConditionAttr(i2);
            if (!customAttr.isStackedBarShape()) continue;
            ++n3;
            ((ArrayList)cloneable).add(customAttr.getStackedSeriesList(this.seriesList));
        }
        CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getDefaultAttr();
        if (customAttr.isStackedBarShape()) {
            Integer[] integerArray = this.customTypeCondition.getUnUsedSeriesIndex(this.seriesList);
            ++n3;
            ((ArrayList)cloneable).add(integerArray);
        }
        this.stackedList = new Integer[n3][];
        for (n4 = 0; n4 < n3; ++n4) {
            this.stackedList[n4] = (Integer[])((ArrayList)cloneable).get(n4);
        }
        this.setBounds4All();
        this.dealSeriesSingle(this.normalBarCount + n3, n2);
        this.calculateStackedTotal();
        this.dealLabelBoundsInOrder();
    }

    private void setBounds4All() {
        this.bar2DPlotGlyph.setBounds(this.getBounds());
        this.bar2DPlotGlyphStack.setBounds(this.getBounds());
        this.linePlotGlyph.setBounds(this.getBounds());
        this.areaPlotGlyphStack.setBounds(this.getBounds());
        this.bar3DPlotGlyph.setBounds(this.getBounds());
        this.bar3DPlotGlyphStack.setBounds(this.getBounds());
    }

    private void dealSeriesSingle(int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            AxisGlyph axisGlyph = this.getSeriesAxisGlyph(i2);
            CustomAttr customAttr = (CustomAttr)this.getCustomTypeCondition().getAttrByResult(dataSeries);
            ChartCustomRendererType chartCustomRendererType = customAttr.getUseRenderer();
            int n5 = this.getStackedBarIndex(i2);
            if (chartCustomRendererType == ChartCustomRendererType.BAR_RENDERER) {
                this.bar2DPlotGlyph.dealShape4Bar(dataSeries, this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), axisGlyph, n2, n4), n3);
                ++n4;
                continue;
            }
            if (chartCustomRendererType == ChartCustomRendererType.BAR_STACK) {
                this.bar2DPlotGlyphStack.dealShape4Bar(dataSeries, this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), axisGlyph, n2, n5), n3);
                continue;
            }
            if (chartCustomRendererType == ChartCustomRendererType.LINE_RENDERER || chartCustomRendererType == ChartCustomRendererType.AREA_RENDERER) {
                this.linePlotGlyph.dealLine4PlotGlyph(dataSeries, this, this.getxAxisGlyph(), axisGlyph, n3);
                continue;
            }
            if (chartCustomRendererType == ChartCustomRendererType.AREA_STACK && ComparatorUtils.equals(dataSeries.getType(), "DataSeries4Area")) {
                this.areaPlotGlyphStack.dealAreaShape4PlotGlyph((DataSeries4Area)dataSeries, this, this.getxAxisGlyph(), axisGlyph, n3);
                continue;
            }
            if (chartCustomRendererType == ChartCustomRendererType.BAR3D) {
                this.bar3DPlotGlyph.dealShape4Bar(dataSeries, this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), axisGlyph, n2, n4), n3);
                ++n4;
                continue;
            }
            if (chartCustomRendererType != ChartCustomRendererType.BAR3D_STACK) continue;
            this.bar3DPlotGlyphStack.dealShape4Bar(dataSeries, this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), axisGlyph, n2, n5), n3);
        }
    }

    private void calculateStackedTotal() {
        for (Integer[] integerArray : this.stackedList) {
            DataSeries[] dataSeriesArray = new DataSeries[integerArray.length];
            for (int i2 = 0; i2 < integerArray.length; ++i2) {
                dataSeriesArray[i2] = this.getSeries(integerArray[i2]);
            }
            this.bar2DPlotGlyphStack.setTotalRectForStackedBar(dataSeriesArray);
        }
    }

    private int getStackedBarIndex(int n2) {
        for (int i2 = 0; i2 < this.stackedList.length; ++i2) {
            Integer[] integerArray = this.stackedList[i2];
            for (int i3 = 0; i3 < integerArray.length; ++i3) {
                int n3 = integerArray[i3];
                if (n2 != n3) continue;
                return this.normalBarCount + i2;
            }
        }
        return -1;
    }

    private Integer[] getStackedSeriesList(int n2) {
        for (int i2 = 0; i2 < this.stackedList.length; ++i2) {
            Integer[] integerArray = this.stackedList[i2];
            for (int i3 = 0; i3 < integerArray.length; ++i3) {
                int n3 = integerArray[i3];
                if (n2 != n3) continue;
                return integerArray;
            }
        }
        return new Integer[0];
    }

    public AxisGlyph getSeriesAxisGlyph(int n2) {
        ChartAxisPosition chartAxisPosition = this.getAxisPosition(n2);
        return ComparatorUtils.equals((Object)chartAxisPosition, (Object)ChartAxisPosition.AXIS_RIGHT) ? this.getSecondAxisGlyph() : this.getyAxisGlyph();
    }

    private ChartAxisPosition getAxisPosition(int n2) {
        CustomAttr customAttr = (CustomAttr)this.getCustomTypeCondition().getAttrByResult(this.getSeries(n2));
        return customAttr.getAxisPosition();
    }

    private ChartCustomRendererType getRenderer(int n2) {
        if (this.customTypeCondition != null && this.customTypeCondition.getAttrByResult(this.getSeries(n2)) != null) {
            CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getAttrByResult(this.getSeries(n2));
            return customAttr.getUseRenderer();
        }
        return ChartCustomRendererType.BAR_RENDERER;
    }

    public double getPreSum4Area(int n2, int n3) {
        ChartAxisPosition chartAxisPosition = this.getAxisPosition(n2);
        double d2 = 0.0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ChartAxisPosition chartAxisPosition2 = this.getAxisPosition(i2);
            ChartCustomRendererType chartCustomRendererType = this.getRenderer(i2);
            if (!ComparatorUtils.equals((Object)chartAxisPosition2, (Object)chartAxisPosition) || !ComparatorUtils.equals((Object)chartCustomRendererType, (Object)ChartCustomRendererType.AREA_STACK)) continue;
            d2 += this.getDataPointPercentValue(i2, n3);
        }
        return d2;
    }

    public double getPreSum4Bar(int n2, int n3, boolean bl) {
        int n4;
        Integer[] integerArray = this.getStackedSeriesList(n2);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < integerArray.length && n2 != (n4 = integerArray[i2].intValue()); ++i2) {
            double d4 = this.getDataPointPercentValue(n4, n3);
            if (d4 > 0.0) {
                d2 += d4;
                continue;
            }
            d3 += d4;
        }
        if (bl) {
            return d3;
        }
        return d2;
    }

    public double getBarPercent(int n2) {
        return 1.0 / ((double)n2 - (double)(n2 - 1) * this.seriesOverlapPercent + this.categoryIntervalPercent);
    }

    public double getBarStartPercent(double d2, int n2, BarDataWithAxisGlyph barDataWithAxisGlyph) {
        return d2 * (1.0 - this.seriesOverlapPercent) * (double)barDataWithAxisGlyph.barIndex + 0.5 * this.categoryIntervalPercent * d2 + (double)barDataWithAxisGlyph.xAxisGlyph.getTickIndex4Value(n2);
    }

    public int[] getDrawSequence() {
        Integer[] integerArray;
        Integer[] integerArray2;
        int[] nArray = new int[this.getSeriesSize()];
        int n2 = this.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = i2;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        int n3 = this.getSeriesSize();
        for (int i3 = 0; i3 < n3; ++i3) {
            integerArray2 = this.getSeries(i3);
            integerArray = (Integer[])this.customTypeCondition.getAttrByResult((Result)integerArray2);
            ChartCustomRendererType chartCustomRendererType = integerArray.getUseRenderer();
            if (chartCustomRendererType == ChartCustomRendererType.BAR_RENDERER) {
                arrayList2.add(i3);
                continue;
            }
            if (chartCustomRendererType == ChartCustomRendererType.BAR3D) {
                arrayList.add(i3);
                continue;
            }
            if (chartCustomRendererType == ChartCustomRendererType.AREA_STACK) {
                arrayList3.add(i3);
                continue;
            }
            if (chartCustomRendererType != ChartCustomRendererType.LINE_RENDERER) continue;
            arrayList4.add(i3);
        }
        Integer[] integerArray3 = arrayList.toArray(new Integer[0]);
        Integer[] integerArray4 = arrayList3.toArray(new Integer[0]);
        integerArray2 = arrayList4.toArray(new Integer[0]);
        integerArray = arrayList2.toArray(new Integer[0]);
        this.addToOrder(integerArray3, integerArray4, integerArray2, integerArray, nArray);
        return nArray;
    }

    private void addToOrder(Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4, int[] nArray) {
        Integer[] integerArray5;
        int n2;
        int n3 = 0;
        this.addIndexToOrder(integerArray4, nArray, n3);
        n3 += integerArray4.length;
        if (!this.is3DStackedBar()) {
            for (n2 = 0; n2 < this.stackedList.length; ++n2) {
                integerArray5 = this.stackedList[n2];
                this.addIndexToOrder(integerArray5, nArray, n3);
                n3 += integerArray5.length;
            }
        }
        this.addIndexToOrder(integerArray3, nArray, n3);
        this.addIndexToOrder(integerArray2, nArray, n3 += integerArray3.length);
        this.addIndexToOrder(integerArray, nArray, n3 += integerArray2.length);
        n3 += integerArray.length;
        if (this.is3DStackedBar()) {
            for (n2 = 0; n2 < this.stackedList.length; ++n2) {
                integerArray5 = this.stackedList[n2];
                this.addIndexToOrder(integerArray5, nArray, n3);
                n3 += integerArray5.length;
            }
        }
    }

    private boolean is3DStackedBar() {
        if (this.stackedList != null) {
            for (int i2 = 0; i2 < this.stackedList.length; ++i2) {
                int n2 = 0;
                Integer[] integerArray = this.stackedList[i2];
                if (n2 >= integerArray.length) continue;
                int n3 = integerArray[n2];
                CustomAttr customAttr = (CustomAttr)this.getCustomTypeCondition().getAttrByResult(this.getSeries(n3));
                return customAttr.getUseRenderer() == ChartCustomRendererType.BAR3D_STACK;
            }
        }
        return false;
    }

    private void addIndexToOrder(Integer[] integerArray, int[] nArray, int n2) {
        int n3 = nArray.length;
        int n4 = integerArray.length;
        for (int i2 = 0; i2 < n4 && n3 > i2 + n2; ++i2) {
            nArray[i2 + n2] = integerArray[i2];
        }
    }

    public boolean equals(Object object) {
        return object instanceof CustomPlotGlyph && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPlotGlyph customPlotGlyph = (CustomPlotGlyph)super.clone();
        return customPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.bar2DPlotGlyph != null) {
            jSONObject.put("bar2DPlotGlyph", this.bar2DPlotGlyph.toJSONObject(repository));
        }
        if (this.bar2DPlotGlyphStack != null) {
            jSONObject.put("bar2DPlotGlyphStack", this.bar2DPlotGlyphStack.toJSONObject(repository));
        }
        if (this.areaPlotGlyphStack != null) {
            jSONObject.put("areaPlotGlyphStack", this.areaPlotGlyphStack.toJSONObject(repository));
        }
        if (this.linePlotGlyph != null) {
            jSONObject.put("linePlotGlyph", this.linePlotGlyph.toJSONObject(repository));
        }
        if (this.bar3DPlotGlyph != null) {
            jSONObject.put("bar3DPlotGlyph", this.bar3DPlotGlyph.toJSONObject(repository));
        }
        if (this.bar3DPlotGlyphStack != null) {
            jSONObject.put("bar3DPlotGlyphStack", this.bar3DPlotGlyphStack.toJSONObject(repository));
        }
        if (this.customTypeCondition != null) {
            DataSeries[] dataSeriesArray = this.seriesList.toArray(new DataSeries[this.seriesList.size()]);
            jSONObject.put("customTypeCondition", this.customTypeCondition.toJSONObject(repository, dataSeriesArray));
        }
        jSONObject.put("has3DShape", this.has3DShape);
        jSONObject.put("seriesOverlapPercent", this.seriesOverlapPercent);
        jSONObject.put("categoryIntervalPercent", this.categoryIntervalPercent);
        if (this.projection != null) {
            jSONObject.put("projection", this.projection.toJSONObject());
        }
        return jSONObject;
    }

    public PlotGlyph[] getAllPlotGlyph() {
        return new PlotGlyph[]{this.bar2DPlotGlyph, this.bar2DPlotGlyphStack, this.bar3DPlotGlyph, this.bar3DPlotGlyphStack, this.linePlotGlyph, this.areaPlotGlyphStack};
    }

    public String getPlotGlyphType() {
        return "CustomPlotGlyph";
    }

    public String getChartType() {
        return "Custom";
    }
}

