/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.BarStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.freehep.graphics2d.AbstractVectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.swf.SWFGraphics2D;

public class BarHorizontal3DStyle
extends BarStyle {
    private boolean axisReversed;

    public BarHorizontal3DStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        this.color = color;
        this.rect = rectangle2D;
        this.avoidOriginDraw = bl;
        this.axisReversed = bl2;
    }

    public void paintStyle(Graphics graphics) {
        Paint paint;
        Graphics2D graphics2D;
        if (this.rect == null || this.color == null) {
            return;
        }
        if (graphics instanceof SWFGraphics2D) {
            graphics2D = (SWFGraphics2D)graphics;
            paint = ((AbstractVectorGraphics)graphics2D).getPaint();
            if (this.isAvoidOriginDraw()) {
                ((AbstractVectorGraphicsIO)graphics2D).setPaint(this.color);
                ((SWFGraphics2D)graphics2D).fill(this.rect);
                ((AbstractVectorGraphicsIO)graphics2D).setPaint(paint);
                return;
            }
        }
        if (this.rect.getWidth() <= 4.0 || this.rect.getHeight() <= 4.0) {
            this.drawNormal((Graphics2D)graphics, this.rect, this.color);
        } else {
            graphics2D = (Graphics2D)graphics;
            paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            GradientPaint gradientPaint = new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), this.getShadeStartColor(), (float)this.rect.getX(), (float)(this.rect.getY() + this.rect.getHeight()), this.getShadeEndColor());
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(this.rect);
            graphics2D.setPaint(this.getStrokeColor());
            graphics2D.setStroke(new BasicStroke(this.borderWidth));
            graphics2D.draw(this.rect);
            graphics2D.setPaint(this.getInnerStrokeColor());
            GeneralPath generalPath = new GeneralPath();
            if (this.axisReversed) {
                generalPath.moveTo((float)this.rect.getX() + 1.0f, (float)(this.rect.getY() + this.rect.getHeight()) - 2.0f);
                generalPath.lineTo((float)this.rect.getX() + 1.0f, (float)this.rect.getY() + 1.0f);
                generalPath.lineTo((float)(this.rect.getX() + this.rect.getWidth()) - 1.0f, (float)this.rect.getY() + 1.0f);
            } else {
                generalPath.moveTo((float)this.rect.getX() + 1.0f, (float)this.rect.getY() + 1.0f);
                generalPath.lineTo((float)(this.rect.getX() + this.rect.getWidth()) - 1.0f, (float)this.rect.getY() + 1.0f);
                generalPath.lineTo((float)(this.rect.getX() + this.rect.getWidth()) - 1.0f, (float)(this.rect.getY() + this.rect.getHeight()) - 2.0f);
            }
            graphics2D.draw(generalPath);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }
}

