/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.Area3D;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Area3DPlotGlyph
extends CategoryPlotGlyph
implements Plot3DGlyph {
    private static final long serialVersionUID = 823999902188932597L;
    private static final double HALF = 0.5;
    private Projection projection = new Projection();
    private int deep = -1;
    private int deepBase = -1;
    private double seriesIntervalPercent;

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setSeriesIntervalPercent(double d2) {
        this.seriesIntervalPercent = d2;
    }

    public void setDeep(int n2) {
        this.deep = n2;
    }

    public int getDeep() {
        return this.deep;
    }

    public void set3DDeepBase(int n2) {
        this.deepBase = n2;
    }

    public int getDeepBase() {
        return this.deepBase;
    }

    public void layoutAxisGlyph(int n2) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), true, n2);
    }

    protected void resetClip(Graphics2D graphics2D) {
    }

    public void layoutDataSeriesGlyph(int n2) {
        double d2 = this.getDeep();
        if (d2 == -1.0) {
            d2 = this.getProjection().projecteeDeep(this.getDeepBase());
        }
        Color[] colorArray = this.createColors4Series();
        this.layoutWithStacked(d2, n2, colorArray);
        this.dealLabelBoundsInOrder();
    }

    private void layoutWithStacked(double d2, int n2, Color[] colorArray) {
        double d3 = d2 / (1.0 + this.seriesIntervalPercent);
        double d4 = -this.seriesIntervalPercent * d3 * 0.5;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            int n3;
            DataSeries dataSeries = this.getSeries(i2);
            Area3D area3D = new Area3D(d4, d3);
            dataSeries.setDrawImpl(area3D);
            area3D.setProjection(this.projection);
            area3D.setTopSize(this.getCategoryCount());
            if (i2 == 0) {
                area3D.setIsFirst(true);
            }
            this.getConditionCollection().changeStyleConditionWithInfo(area3D.getColorInfo(), dataSeries, colorArray);
            double[] dArray = new double[dataSeries.getDataPointCount()];
            for (n3 = 0; n3 < dataSeries.getDataPointCount(); ++n3) {
                DataPoint dataPoint = dataSeries.getDataPoint(n3);
                this.calculatePreValueWithStacked(area3D, dataPoint, dArray, d4, n3, i2, n2);
            }
            for (n3 = dArray.length - 1; n3 >= 0; --n3) {
                area3D.lineTo((float)this.getxAxisGlyph().getPoint2D(n3).getX(), (float)dArray[n3]);
            }
            area3D.closePath();
        }
    }

    private void calculatePreValueWithStacked(Area3D area3D, DataPoint dataPoint, double[] dArray, double d2, int n2, int n3, int n4) {
        double d3 = this.getDataPointPercentValue(n3, n2);
        float f2 = (float)this.getxAxisGlyph().getPointInBounds(n2).getX();
        double d4 = 0.0;
        double d5 = 0.0;
        d5 = this.getPrePercentValue(n3, n2);
        d4 = this.getPrePercentValue(n3 - 1, n2);
        float f3 = (float)(this.getyAxisGlyph().getBounds().getY() + (double)((float)this.getyAxisGlyph().getPointInBounds(d5).getY()));
        dArray[n2] = this.getyAxisGlyph().getBounds().getY() + (double)((float)this.getyAxisGlyph().getPointInBounds(d4).getY());
        this.dealPointPath(dataPoint, area3D, f2, f3, d2, n2);
        this.dealDataPointLabel(dataPoint, n4);
    }

    private double getPrePercentValue(int n2, int n3) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            DataSeries dataSeries = this.getSeries(i2);
            d2 += Math.abs(dataSeries.getDataPoint(n3).getValue());
            if (i2 > n2) continue;
            d3 += Math.abs(dataSeries.getDataPoint(n3).getValue());
        }
        if (!this.getyAxisGlyph().isPercentage()) {
            return d3;
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d3 / d2;
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n2);
    }

    private void dealPointPath(DataPoint dataPoint, Area3D area3D, float f2, float f3, double d2, int n2) {
        if (n2 == 0) {
            area3D.moveTo(f2, f3);
        } else {
            area3D.lineTo(f2, f3);
        }
        Point2D point2D = this.projection.projectee(f2, f3, d2);
        dataPoint.setShape(new Arc2D.Double(point2D.getX() - 3.0, point2D.getY() - 3.0, 6.0, 6.0, 0.0, 360.0, 2));
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw3DInfo(graphics, n2);
        this.drawAxisGlyph4ThreeD(this.getyAxisGlyph(), graphics, n2);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGlyph4ThreeD(this.getxAxisGlyph(), graphics, n2);
        if (this.isStacked()) {
            int n3;
            int n4 = this.getSeriesSize();
            for (n3 = 0; n3 < n4; ++n3) {
                this.getSeries(n3).draw(graphics, n2);
            }
            n4 = this.getSeriesSize();
            for (n3 = 0; n3 < n4; ++n3) {
                this.getSeries(n3).drawLabel(graphics, n2);
            }
        } else {
            int n5;
            for (n5 = this.getSeriesSize() - 1; n5 >= 0; --n5) {
                this.getSeries(n5).draw(graphics, n2);
            }
            for (n5 = this.getSeriesSize() - 1; n5 >= 0; --n5) {
                this.getSeries(n5).drawLabel(graphics, n2);
            }
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public boolean equals(Object object) {
        return object instanceof Area3DPlotGlyph && super.equals(object) && ((Area3DPlotGlyph)object).deep == this.deep && ((Area3DPlotGlyph)object).seriesIntervalPercent == this.seriesIntervalPercent && ComparatorUtils.equals(((Area3DPlotGlyph)object).projection, this.projection);
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("projection", this.projection.toJSONObject());
        jSONObject.put("seriesIntervalPercent", this.seriesIntervalPercent);
        jSONObject.put("deep", this.deep);
        return jSONObject;
    }

    public String getPlotDetailType() {
        String string = "Area3DPlotGlyph";
        if (this.isStacked()) {
            string = string + "-Stack";
        }
        if (this.getyAxisGlyph().isPercentage()) {
            string = string + "-Percent";
        }
        return string;
    }

    public String getPlotGlyphType() {
        return "Area3DPlotGlyph";
    }

    public String getChartType() {
        return "Area3D";
    }

    public String getSmallIconType() {
        return "Area";
    }
}

