/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RectanglePlot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.Date;

public abstract class CategoryPlot
extends RectanglePlot {
    private static final long serialVersionUID = 6344220409249871761L;
    public static final double GAP_BETWEEN_PLOTS = 1.0;
    public static final String XML_TAG = "CategoryPlot";
    protected boolean isStacked = false;

    public CategoryPlot() {
        this.setxAxis(new CategoryAxis());
        this.setyAxis(new ValueAxis());
        this.setSecondAxis(new ValueAxis(4));
    }

    public void install4PlotGlyph(CategoryPlotGlyph categoryPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(categoryPlotGlyph, chartData);
        categoryPlotGlyph.setStacked(this.isStacked);
    }

    public void installAxisGlyph(CategoryPlotGlyph categoryPlotGlyph, ChartData chartData) {
        AxisGlyph axisGlyph = this.getxAxis().createAxisGlyph(chartData);
        categoryPlotGlyph.setxAxisGlyph(axisGlyph);
        axisGlyph.setAxisType("xAxis");
        categoryPlotGlyph.axisExtendsMaxMinValueWithTrendLine(axisGlyph);
        AxisGlyph axisGlyph2 = this.getyAxis().createAxisGlyph(chartData);
        categoryPlotGlyph.setyAxisGlyph(axisGlyph2);
        axisGlyph2.setAxisType("yAxis");
        axisGlyph2.initMinMaxValue(this.getMinValueFromData(chartData, axisGlyph2.isLog(), axisGlyph), this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_LEFT, axisGlyph));
        if (this.isUseSecondAxis()) {
            AxisGlyph axisGlyph3 = this.getSecondAxis().createAxisGlyph(chartData);
            categoryPlotGlyph.setSecondAxisGlyph(axisGlyph3);
            axisGlyph3.setAxisType("secondAxis");
            axisGlyph3.initMinMaxValue(this.getMinValueFromData(chartData, axisGlyph3.isLog(), axisGlyph), this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_RIGHT, axisGlyph));
        }
        super.installAxisGlyph(categoryPlotGlyph, chartData);
    }

    public boolean isStacked() {
        return this.isStacked;
    }

    public void setStacked(boolean bl) {
        this.isStacked = bl;
    }

    public boolean isSupportAxisReverse() {
        return true;
    }

    public boolean isSupportCate() {
        return true;
    }

    public double getMaxValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition, AxisGlyph axisGlyph) {
        if (this.isStacked) {
            return this.getMaxValue4Stack(chartData, chartAxisPosition, axisGlyph);
        }
        return this.getMaxValue4Normal(chartData, chartAxisPosition, axisGlyph);
    }

    private double getMaxValue4Normal(ChartData chartData, ChartAxisPosition chartAxisPosition, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            boolean bl = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i2));
            for (int i3 = 0; i3 < normalChartData.getSeriesCount() && bl; ++i3) {
                Number number = normalChartData.getValueAt(i3, i2);
                if (number == null) continue;
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, i3);
                if (!(number.doubleValue() > d2) || !ComparatorUtils.equals((Object)attrAxisPosition.getAxisPosition(), (Object)chartAxisPosition)) continue;
                d2 = number.doubleValue();
            }
        }
        if (this.getMinValueFromData((ChartData)normalChartData, false, axisGlyph) == d2) {
            return d2 + 10.0;
        }
        return d2;
    }

    private double getMaxValue4Stack(ChartData chartData, ChartAxisPosition chartAxisPosition, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            double d4 = 0.0;
            boolean bl = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i2));
            for (int i3 = 0; i3 < normalChartData.getSeriesCount() && bl; ++i3) {
                Number number = normalChartData.getValueAt(i3, i2);
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, i3);
                if (number == null || !(number.doubleValue() >= 0.0) || !ComparatorUtils.equals((Object)attrAxisPosition.getAxisPosition(), (Object)chartAxisPosition)) continue;
                d4 += number.doubleValue();
            }
            double d5 = d2 = d4 > d2 ? d4 : d2;
            if (!bl || !this.getyAxis().isPercentage()) continue;
            d3 = this.getMinMaxValue(d3, i2, normalChartData, true, d4);
        }
        if (this.getyAxis().isPercentage()) {
            return d3;
        }
        if (this.getMinValueFromData(chartData, false, axisGlyph) == d2) {
            return d2 + 10.0;
        }
        return d2;
    }

    private double getMinValueFromData(ChartData chartData, boolean bl, AxisGlyph axisGlyph) {
        if (this.isStacked) {
            return this.getMinValue4Stack(chartData, bl, axisGlyph);
        }
        return this.getMinValue4Normal(chartData, bl, axisGlyph);
    }

    private double getMinValue4Normal(ChartData chartData, boolean bl, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
        }
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            boolean bl2 = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i2));
            for (int i3 = 0; i3 < normalChartData.getSeriesCount() && bl2; ++i3) {
                Number number = normalChartData.getValueAt(i3, i2);
                if (number == null) continue;
                d2 = bl ? (number.doubleValue() < d2 && number.doubleValue() > 0.0 ? number.doubleValue() : d2) : (number.doubleValue() < d2 ? number.doubleValue() : d2);
            }
        }
        if (d2 == Double.MAX_VALUE) {
            return 1.0;
        }
        return d2;
    }

    private double getMinValue4Stack(ChartData chartData, boolean bl, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        double d3 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
        }
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            double d4 = 0.0;
            boolean bl2 = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i2));
            for (int i3 = 0; i3 < normalChartData.getSeriesCount() && bl2; ++i3) {
                Number number = normalChartData.getValueAt(i3, i2);
                if (number == null) continue;
                if (number.doubleValue() <= 0.0) {
                    d4 += number.doubleValue();
                    continue;
                }
                if (!bl) continue;
                d2 = number.doubleValue() < d2 ? number.doubleValue() : d2;
            }
            if (!bl) {
                double d5 = d2 = d4 < d2 ? d4 : d2;
            }
            if (!bl2 || !this.getyAxis().isPercentage()) continue;
            d3 = this.getMinMaxValue(d3, i2, normalChartData, false, d4);
        }
        if (this.getyAxis().isPercentage()) {
            return d3;
        }
        if (d2 == Double.MAX_VALUE) {
            return 1.0;
        }
        return d2;
    }

    protected boolean isInCategoryField(AxisGlyph axisGlyph, Object object) {
        if (axisGlyph instanceof DateAxisGlyph) {
            double d2;
            double d3 = axisGlyph.getMinValue();
            double d4 = axisGlyph.getMaxValue();
            Date date = DateUtils.object2Date(object, true);
            if (date != null && ((d2 = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)axisGlyph).getMainType())) < d3 || d2 > d4)) {
                return false;
            }
        }
        return true;
    }

    private double getMinMaxValue(double d2, int n2, ChartData chartData, boolean bl, double d3) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        if (this.getyAxis().isPercentage()) {
            double d4 = 0.0;
            for (int i2 = 0; i2 < normalChartData.getSeriesCount(); ++i2) {
                Number number = normalChartData.getValueAt(i2, n2);
                if (number == null) continue;
                d4 += Math.abs(number.doubleValue());
            }
            d2 = bl ? (d3 / d4 > d2 ? d3 / d4 : d2) : (d3 / d4 < d2 ? d3 / d4 : d2);
        }
        return d2;
    }

    public boolean match4GUI(Plot plot) {
        if (!(plot instanceof CategoryPlot)) {
            return false;
        }
        boolean bl = ((CategoryPlot)plot).getyAxis().isPercentage();
        return super.match4GUI(plot) && this.isStacked == ((CategoryPlot)plot).isStacked && this.getyAxis().isPercentage() == bl;
    }

    public boolean isSupportDataSheet() {
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "CateAttr".equals(string = xMLableReader.getTagName())) {
            this.setStacked(xMLableReader.getAttrAsBoolean("isStacked", false));
            if (xMLableReader.getAttrAsBoolean("bgStagger", false)) {
                this.setVerticalIntervalBackgroundColor(xMLableReader.getAttrAsColor("bgColor", Color.black));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("CateAttr").attr("isStacked", this.isStacked);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        return categoryPlot;
    }

    public boolean equals(Object object) {
        return object instanceof CategoryPlot && super.equals(object) && ((CategoryPlot)object).isStacked() == this.isStacked;
    }
}

