/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.stable.StableUtils;
import com.fr.stable.collections.map.IntMap;
import java.io.Serializable;
import java.util.Arrays;

public class IntList
implements Cloneable,
Serializable {
    private int[] data;
    private int size = 0;
    private static final int CACHE_SIZE = 100;
    private static IntMap<int[]> cacheMap = new IntMap(100);

    public IntList() {
        this(8);
    }

    public IntList(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.data = new int[n2];
    }

    public int get(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.data[n2];
    }

    public void set(int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.data[n2] = n3;
    }

    public void add(int n2) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = n2;
    }

    public void add(int n2, int n3) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n2, this.data, n2 + 1, this.size - n2);
        this.data[n2] = n3;
        ++this.size;
    }

    public boolean contain(int n2) {
        return this.indexOf(n2) >= 0;
    }

    public int indexOf(int n2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.data[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public void remove(int n2) {
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.data, n2 + 1, this.data, n2, n3);
        }
        --this.size;
    }

    public void removeEqual() {
        int[] nArray = this.toArray();
        this.clear();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (this.contain(nArray[i2])) continue;
            this.add(nArray[i2]);
        }
    }

    public void sort() {
        this.trimToSize();
        Arrays.sort(this.data);
    }

    public void clear() {
        this.data = new int[0];
        this.size = 0;
    }

    public void trimToSize() {
        this.data = this.toArray();
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        return nArray;
    }

    public boolean addAll(int n2, IntList intList) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        int[] nArray = intList.toArray();
        int n3 = nArray.length;
        this.ensureCapacity(this.size + n3);
        int n4 = this.size - n2;
        if (n4 > 0) {
            System.arraycopy(this.data, n2, this.data, n2 + n3, n4);
        }
        System.arraycopy(nArray, 0, this.data, n2, n3);
        this.size += n3;
        return n3 != 0;
    }

    public boolean addAll(IntList intList) {
        int[] nArray = intList.toArray();
        int n2 = nArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(nArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 != 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntList)) {
            return false;
        }
        IntList intList = (IntList)object;
        if (this.size != intList.size) {
            return false;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.data[i2] == intList.data[i2]) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IntList intList = (IntList)super.clone();
        intList.clear();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            intList.add(this.get(i2));
        }
        return intList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.get(i2));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void ensureCapacity(int n2) {
        int n3 = this.data.length;
        if (n2 > n3) {
            int[] nArray = this.data;
            int n4 = n3 * 3 / 2 + 1;
            if (n4 < n2) {
                n4 = n2;
            }
            this.data = new int[n4];
            System.arraycopy(nArray, 0, this.data, 0, this.size);
        }
    }

    public static IntList asList(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        IntList intList = new IntList();
        intList.data = nArray;
        intList.size = intList.data.length;
        return intList;
    }

    public static IntList toIntListDecimal(String string, char c2) {
        IntList intList = new IntList();
        if (string == null) {
            return intList;
        }
        String[] stringArray = StableUtils.splitString(string, "" + c2);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2].trim();
            try {
                intList.add(Integer.parseInt(string2));
                continue;
            }
            catch (Exception exception) {
                int n2;
                String[] stringArray2 = StableUtils.splitString(string2, "-");
                int n3 = -1;
                int n4 = -1;
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    int n5 = 0;
                    try {
                        n5 = Integer.parseInt(stringArray2[n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n2 == 0) {
                        n3 = n5;
                        n4 = n5;
                        continue;
                    }
                    n3 = Math.min(n5, n3);
                    n4 = Math.max(n5, n4);
                }
                for (n2 = n3; n2 <= n4; ++n2) {
                    intList.add(n2);
                }
            }
        }
        return intList;
    }

    public static int[] toIntArrayDecimal(String string, char c2) {
        return IntList.toIntListDecimal(string, c2).toArray();
    }

    public static int[] unionArray(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2 == null ? nArray2 : (int[])nArray2.clone();
        }
        if (nArray2 == null) {
            return (int[])nArray.clone();
        }
        int[] nArray3 = (int[])nArray.clone();
        int[] nArray4 = (int[])nArray2.clone();
        Arrays.sort(nArray3);
        Arrays.sort(nArray4);
        IntList intList = new IntList();
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray3.length || n3 < nArray4.length) {
            if (n2 == nArray3.length) {
                intList.add(nArray4[n3]);
                ++n3;
                continue;
            }
            if (n3 == nArray4.length) {
                intList.add(nArray3[n2]);
                ++n2;
                continue;
            }
            if (nArray3[n2] < nArray4[n3]) {
                intList.add(nArray3[n2]);
                ++n2;
                continue;
            }
            if (nArray3[n2] > nArray4[n3]) {
                intList.add(nArray4[n3]);
                ++n3;
                continue;
            }
            if (nArray3[n2] != nArray4[n3]) continue;
            intList.add(nArray4[n3]);
            ++n2;
            ++n3;
        }
        return intList.toArray();
    }

    public static void sort(IntList intList) {
        int[] nArray = intList.toArray();
        Arrays.sort(nArray);
        intList.data = nArray;
    }

    public static int[] getRangeFromCache(int n2) {
        int[] nArray = IntList.getCache(n2);
        if (nArray == null) {
            nArray = IntList.range(n2);
            IntList.putCache(n2, nArray);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getCache(int n2) {
        IntMap<int[]> intMap = cacheMap;
        synchronized (intMap) {
            return cacheMap.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCache(int n2, int[] nArray) {
        IntMap<int[]> intMap = cacheMap;
        synchronized (intMap) {
            if (IntList.cacheMap.size > 1000) {
                cacheMap.clear();
            }
            cacheMap.put(n2, nArray);
        }
    }

    public static int[] range(int n2) {
        if (n2 > 0) {
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = i2;
            }
            return nArray;
        }
        return IntList.range(0, n2);
    }

    public static int[] range(int n2, int n3) {
        return IntList.range(n2, n3, 1);
    }

    public static int[] range(int n2, int n3, int n4) {
        IntList intList = new IntList();
        if (n4 > 0) {
            while (n2 < n3) {
                intList.add(n2);
                n2 += n4;
            }
        } else {
            while (n2 > n3) {
                intList.add(n2);
                n2 += n4;
            }
        }
        return intList.toArray();
    }

    public static IntList reverse(IntList intList) {
        int n2 = intList.size();
        int[] nArray = intList.toArray();
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray2[i2] = nArray[n2 - i2 - 1];
        }
        return IntList.asList(nArray2);
    }
}

