/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.view;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxCellStatePreview {
    protected Map<mxCellState, mxPoint> deltas = new LinkedHashMap<mxCellState, mxPoint>();
    protected int count = 0;
    protected mxGraphComponent graphComponent;
    protected boolean cloned;
    protected float opacity = 1.0f;
    protected List<mxCellState> cellStates;

    public mxCellStatePreview(mxGraphComponent graphComponent, boolean cloned) {
        this.graphComponent = graphComponent;
        this.cloned = cloned;
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setCloned(boolean value) {
        this.cloned = value;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int getCount() {
        return this.count;
    }

    public Map<mxCellState, mxPoint> getDeltas() {
        return this.deltas;
    }

    public void setOpacity(float value) {
        this.opacity = value;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public mxPoint moveState(mxCellState state, double dx, double dy) {
        return this.moveState(state, dx, dy, true, true);
    }

    public mxPoint moveState(mxCellState state, double dx, double dy, boolean add, boolean includeEdges) {
        mxPoint delta = this.deltas.get(state);
        if (delta == null) {
            delta = new mxPoint(dx, dy);
            this.deltas.put(state, delta);
            ++this.count;
        } else if (add) {
            delta.setX(delta.getX() + dx);
            delta.setY(delta.getY() + dy);
        } else {
            delta.setX(dx);
            delta.setY(dy);
        }
        if (includeEdges) {
            this.addEdges(state);
        }
        return delta;
    }

    public mxRectangle show() {
        mxGraph graph = this.graphComponent.getGraph();
        mxIGraphModel model = graph.getModel();
        LinkedList<mxCellState> previousStates = null;
        if (this.isCloned()) {
            previousStates = new LinkedList<mxCellState>();
            for (mxCellState state : this.deltas.keySet()) {
                previousStates.addAll(this.snapshot(state));
            }
        }
        for (mxCellState state : this.deltas.keySet()) {
            mxPoint delta = this.deltas.get(state);
            mxCellState parentState = graph.getView().getState(model.getParent(state.getCell()));
            this.translateState(parentState, state, delta.getX(), delta.getY());
        }
        mxRectangle dirty = null;
        for (mxCellState state : this.deltas.keySet()) {
            mxPoint delta = this.deltas.get(state);
            mxCellState parentState = graph.getView().getState(model.getParent(state.getCell()));
            mxRectangle tmp = this.revalidateState(parentState, state, delta.getX(), delta.getY());
            if (dirty != null) {
                dirty.add(tmp);
                continue;
            }
            dirty = tmp;
        }
        if (previousStates != null) {
            this.cellStates = new LinkedList<mxCellState>();
            for (mxCellState state : this.deltas.keySet()) {
                this.cellStates.addAll(this.snapshot(state));
            }
            this.restore(previousStates);
        }
        if (dirty != null) {
            dirty.grow(2.0);
        }
        return dirty;
    }

    public void restore(List<mxCellState> snapshot) {
        mxGraph graph = this.graphComponent.getGraph();
        for (mxCellState state : snapshot) {
            mxCellState orig = graph.getView().getState(state.getCell());
            if (orig == null || orig == state) continue;
            this.restoreState(orig, state);
        }
    }

    public void restoreState(mxCellState state, mxCellState from) {
        state.setLabelBounds(from.getLabelBounds());
        state.setAbsolutePoints(from.getAbsolutePoints());
        state.setOrigin(from.getOrigin());
        state.setAbsoluteOffset(from.getAbsoluteOffset());
        state.setBoundingBox(from.getBoundingBox());
        state.setTerminalDistance(from.getTerminalDistance());
        state.setSegments(from.getSegments());
        state.setLength(from.getLength());
        state.setX(from.getX());
        state.setY(from.getY());
        state.setWidth(from.getWidth());
        state.setHeight(from.getHeight());
    }

    public List<mxCellState> snapshot(mxCellState state) {
        LinkedList<mxCellState> result = new LinkedList<mxCellState>();
        if (state != null) {
            result.add((mxCellState)state.clone());
            mxGraph graph = this.graphComponent.getGraph();
            mxIGraphModel model = graph.getModel();
            Object cell = state.getCell();
            int childCount = model.getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                result.addAll(this.snapshot(graph.getView().getState(model.getChildAt(cell, i))));
            }
        }
        return result;
    }

    protected void translateState(mxCellState parentState, mxCellState state, double dx, double dy) {
        if (state != null) {
            Object cell;
            mxGraph graph = this.graphComponent.getGraph();
            mxIGraphModel model = graph.getModel();
            if (model.isVertex(cell = state.getCell())) {
                state.setInvalid(true);
                graph.getView().validateBounds(parentState, cell);
                mxGeometry geo = graph.getCellGeometry(cell);
                if (!(dx == 0.0 && dy == 0.0 || geo == null || geo.isRelative() && this.deltas.get(state) == null)) {
                    state.setX(state.getX() + dx);
                    state.setY(state.getY() + dy);
                }
            }
            int childCount = model.getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                this.translateState(state, graph.getView().getState(model.getChildAt(cell, i)), dx, dy);
            }
        }
    }

    protected mxRectangle revalidateState(mxCellState parentState, mxCellState state, double dx, double dy) {
        mxRectangle dirty = null;
        if (state != null) {
            mxGraph graph = this.graphComponent.getGraph();
            mxIGraphModel model = graph.getModel();
            Object cell = state.getCell();
            state.setInvalid(true);
            dirty = graph.getView().validatePoints(parentState, cell);
            mxGeometry geo = graph.getCellGeometry(cell);
            if ((dx != 0.0 || dy != 0.0) && geo != null && geo.isRelative() && model.isVertex(cell) && (parentState == null || model.isVertex(parentState.getCell()) || this.deltas.get(state) != null)) {
                state.setX(state.getX() + dx);
                state.setY(state.getY() + dy);
                dirty.setX(dirty.getX() + dx);
                dirty.setY(dirty.getY() + dy);
                graph.getView().updateLabelBounds(state);
            }
            int childCount = model.getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                mxRectangle tmp = this.revalidateState(state, graph.getView().getState(model.getChildAt(cell, i)), dx, dy);
                if (dirty != null) {
                    dirty.add(tmp);
                    continue;
                }
                dirty = tmp;
            }
        }
        return dirty;
    }

    public void addEdges(mxCellState state) {
        mxGraph graph = this.graphComponent.getGraph();
        mxIGraphModel model = graph.getModel();
        Object cell = state.getCell();
        int edgeCount = model.getEdgeCount(cell);
        for (int i = 0; i < edgeCount; ++i) {
            mxCellState state2 = graph.getView().getState(model.getEdgeAt(cell, i));
            if (state2 == null) continue;
            this.moveState(state2, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.cellStates != null && this.cellStates.size() > 0) {
            mxInteractiveCanvas canvas = this.graphComponent.getCanvas();
            if (this.graphComponent.isAntiAlias()) {
                mxUtils.setAntiAlias((Graphics2D)g, true, true);
            }
            Graphics2D previousGraphics = canvas.getGraphics();
            Point previousTranslate = canvas.getTranslate();
            double previousScale = canvas.getScale();
            try {
                canvas.setScale(this.graphComponent.getGraph().getView().getScale());
                canvas.setTranslate(0, 0);
                canvas.setGraphics((Graphics2D)g);
                this.paintPreview(canvas);
            }
            finally {
                canvas.setScale(previousScale);
                canvas.setTranslate(previousTranslate.x, previousTranslate.y);
                canvas.setGraphics(previousGraphics);
            }
        }
    }

    protected float getOpacityForCell(Object cell) {
        return this.opacity;
    }

    protected void paintPreview(mxGraphics2DCanvas canvas) {
        Composite previousComposite = canvas.getGraphics().getComposite();
        for (mxCellState state : this.cellStates) {
            canvas.getGraphics().setComposite(AlphaComposite.getInstance(3, this.getOpacityForCell(state.getCell())));
            this.paintPreviewState(canvas, state);
        }
        canvas.getGraphics().setComposite(previousComposite);
    }

    protected void paintPreviewState(mxGraphics2DCanvas canvas, mxCellState state) {
        this.graphComponent.getGraph().drawState(canvas, state, state.getCell() != this.graphComponent.getCellEditor().getEditingCell());
    }
}

