/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.vanchart;

import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.base.background.ImageBackground;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartTools;
import com.fr.plugin.chart.attr.VanChartZoom;
import com.fr.plugin.chart.glyph.VanChartAxisPlotGlyphInterface;
import com.fr.plugin.chart.glyph.VanChartLegendGlyph;
import com.fr.plugin.chart.vanchart.VanChartGlyphLayout;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.geom.RoundRectangle2D;

public class VanChartGlyph
extends ChartGlyph {
    private static final long serialVersionUID = 2594623742395993399L;
    private VanChartTools vanChartTools;
    private VanChartZoom vanChartZoom;

    public void setVanChartTools(VanChartTools vanChartTools) {
        this.vanChartTools = vanChartTools;
    }

    public void setVanChartZoom(VanChartZoom vanChartZoom) {
        this.vanChartZoom = vanChartZoom;
    }

    protected void makeSureBounds(double d, int n, int n2) {
        this.setBounds(new RoundRectangle2D.Double(0.0, 0.0, (double)n - d, (double)n2 - d, this.getRoundRadius(), this.getRoundRadius()));
    }

    protected void chartDoLayout(int n) {
        VanChartGlyphLayout.doLayout(this, n);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        VanChartLegendGlyph vanChartLegendGlyph;
        if (this.getPlotGlyph() != null && this.getPlotGlyph().isNeedDealHotHyperlink()) {
            this.getPlotGlyph().dealPlotHotAttr(repository);
        }
        JSONObject jSONObject = new JSONObject();
        if (this.getTitleGlyph() != null && this.getTitleGlyph().isVisible()) {
            jSONObject.put("title", (Object)this.getTitleGlyph().toJSONObject(repository));
        }
        if (this.getLegendGlyph() != null) {
            vanChartLegendGlyph = (VanChartLegendGlyph)this.getLegendGlyph();
            vanChartLegendGlyph.addLegendJSON(jSONObject, repository);
        }
        if (this.getDataSheetGlyph() != null) {
            jSONObject.put("dataSheet", (Object)this.getDataSheetGlyph().toJSONObject(repository));
        }
        this.addChartBackgroundAndBorder(jSONObject, repository);
        jSONObject.put("tools", (Object)this.vanChartTools.toJSONObject());
        if (this.vanChartZoom != null) {
            jSONObject.put("zoom", (Object)this.vanChartZoom.toJSONObject());
        }
        if ((vanChartLegendGlyph = this.getPlotGlyph()) == null) {
            return jSONObject;
        }
        jSONObject.put("chartType", (Object)vanChartLegendGlyph.getChartType());
        jSONObject.put("style", (Object)VanChartAttrHelper.getPlotStyle(vanChartLegendGlyph.getPlotStyle()));
        this.addColorsJSON((PlotGlyph)vanChartLegendGlyph, jSONObject);
        this.addPlotBackgroundAndBorder((PlotGlyph)vanChartLegendGlyph, jSONObject, repository);
        vanChartLegendGlyph.addSeriesJSON(jSONObject, repository);
        jSONObject.put("plotOptions", (Object)vanChartLegendGlyph.getPlotOptionsJSON(repository, this.isJSDraw()));
        if (vanChartLegendGlyph instanceof VanChartAxisPlotGlyphInterface) {
            ((VanChartAxisPlotGlyphInterface)((Object)vanChartLegendGlyph)).addXAxisJSON(jSONObject, repository);
            ((VanChartAxisPlotGlyphInterface)((Object)vanChartLegendGlyph)).addYAxisJSON(jSONObject, repository);
        }
        return jSONObject;
    }

    public void addChartBackgroundAndBorder(JSONObject jSONObject, Repository repository) throws JSONException {
        Background background = this.getBackground();
        if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"ColorBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(((ColorBackground)background).getColor(), this.getAlpha()));
        } else if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"GradientBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getGradientBackgroundJSON((GradientBackground)background, this.getAlpha()));
        } else if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"ImageBackground")) {
            jSONObject.put("backgroundImage", (Object)VanChartAttrHelper.getImageBackground((ImageBackground)background, repository));
        }
        jSONObject.put("shadow", this.isShadow());
        if (this.getBorderColor() != null) {
            jSONObject.put("borderColor", (Object)StableUtils.javaColorToCSSColor((Color)this.getBorderColor()));
        } else {
            jSONObject.put("borderColor", (Object)"rgba(255,255,255,0)");
        }
        jSONObject.put("borderWidth", VanChartAttrHelper.getAxisLineStyle(this.getBorderStyle()));
        jSONObject.put("borderRadius", this.getRoundRadius());
    }

    public void addColorsJSON(PlotGlyph plotGlyph, JSONObject jSONObject) throws JSONException {
        Color[] colorArray = plotGlyph.createColors4Series();
        JSONArray jSONArray = new JSONArray();
        for (Color color : colorArray) {
            if (color == null) continue;
            jSONArray.put((Object)StableUtils.javaColorToCSSColor((Color)color));
        }
        jSONObject.put("colors", (Object)jSONArray);
    }

    public void addPlotBackgroundAndBorder(PlotGlyph plotGlyph, JSONObject jSONObject, Repository repository) throws JSONException {
        Background background = plotGlyph.getBackground();
        if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"ColorBackground")) {
            jSONObject.put("plotBackgroundColor", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(((ColorBackground)background).getColor(), plotGlyph.getAlpha()));
        } else if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"GradientBackground")) {
            jSONObject.put("plotBackgroundColor", (Object)VanChartAttrHelper.getGradientBackgroundJSON((GradientBackground)background, plotGlyph.getAlpha()));
        } else if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"ImageBackground")) {
            jSONObject.put("plotBackgroundImage", (Object)VanChartAttrHelper.getImageBackground((ImageBackground)background, repository));
        }
        jSONObject.put("plotShadow", plotGlyph.isShadow());
        if (plotGlyph.getBorderColor() != null) {
            jSONObject.put("plotBorderColor", (Object)StableUtils.javaColorToCSSColor((Color)plotGlyph.getBorderColor()));
        } else {
            jSONObject.put("plotBorderColor", (Object)"rgba(255,255,255,0)");
        }
        jSONObject.put("plotBorderWidth", VanChartAttrHelper.getAxisLineStyle(plotGlyph.getBorderStyle()));
        jSONObject.put("plotBorderRadius", plotGlyph.getRoundRadius());
    }
}

