/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.range;

import com.fr.base.Formula;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.range.MinAndMaxValue;
import com.fr.plugin.chart.range.glyph.GradualColorDist;
import com.fr.plugin.chart.range.glyph.GradualIntervalConfigGlyph;
import com.fr.plugin.chart.scatter.VanChartScatterPlotGlyph;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GradualIntervalConfig
implements XMLReadable,
Cloneable,
Serializable {
    private MinAndMaxValue minAndMaxValue = new MinAndMaxValue(new Formula("0"), new Formula("0"));
    private Color subColor = new Color(36, 167, 255);
    private double divStage = 2.0;
    private ArrayList<GradualColorDist> gradualColorDistList = new ArrayList();
    private static final double DEFAULTMAX = -100.0;
    private static final double DEFAULTMIN = 0.0;

    public GradualIntervalConfig() {
        this.initDistAndColors();
    }

    private void initDistAndColors() {
        int n = (int)this.getDivStage() + 1;
        Color[] colorArray = ChartBaseUtils.createColorsWithHSB((Color)this.getSubColor(), (int)n);
        Color[] colorArray2 = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray2[i] = colorArray[n - 1 - i];
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)i / (float)(n - 1);
        }
        this.initGradualColorDistList(colorArray2, fArray);
    }

    private void initGradualColorDistList(Color[] colorArray, float[] fArray) {
        for (int i = 0; i < (int)this.getDivStage() + 1; ++i) {
            this.gradualColorDistList.add(new GradualColorDist(fArray[i], colorArray[i]));
        }
    }

    public Color getSubColor() {
        return this.subColor;
    }

    public void setSubColor(Color color) {
        this.subColor = color;
    }

    public double getDivStage() {
        return this.divStage;
    }

    public void setDivStage(double d) {
        this.divStage = d;
    }

    public ArrayList<GradualColorDist> getGradualColorDistList() {
        return this.gradualColorDistList;
    }

    public void setGradualColorDistList(ArrayList<GradualColorDist> arrayList) {
        this.gradualColorDistList = arrayList;
    }

    public void addGradualColorDistList(GradualColorDist gradualColorDist) {
        this.gradualColorDistList.add(gradualColorDist);
    }

    public MinAndMaxValue getMinAndMaxValue() {
        return this.minAndMaxValue;
    }

    public void setMinAndMaxValue(MinAndMaxValue minAndMaxValue) {
        this.minAndMaxValue = minAndMaxValue;
    }

    public GradualIntervalConfigGlyph createGradualIntervalConfigGlyph(PlotGlyph plotGlyph) {
        GradualIntervalConfigGlyph gradualIntervalConfigGlyph = new GradualIntervalConfigGlyph();
        this.dealMinAndMaxValue4GradualIntervalConfigGlyph(gradualIntervalConfigGlyph, plotGlyph);
        this.dealColorDist4GradualIntervalConfigGlyph(gradualIntervalConfigGlyph, this.getGradualColorDistList());
        return gradualIntervalConfigGlyph;
    }

    private void dealColorDist4GradualIntervalConfigGlyph(GradualIntervalConfigGlyph gradualIntervalConfigGlyph, ArrayList<GradualColorDist> arrayList) {
        gradualIntervalConfigGlyph.setColors(arrayList);
    }

    private void dealMinAndMaxValue4GradualIntervalConfigGlyph(GradualIntervalConfigGlyph gradualIntervalConfigGlyph, PlotGlyph plotGlyph) {
        double d = 0.0;
        double d2 = -100.0;
        double[] dArray = VanChartAttrHelper.getScatterMinAndMaxValue((VanChartScatterPlotGlyph)plotGlyph, d, d2);
        d = dArray[0];
        d2 = dArray[1];
        d = VanChartAttrHelper.roundValue(d, false);
        d2 = VanChartAttrHelper.roundValue(d2, true);
        if (this.getMinAndMaxValue().isCustomMin()) {
            gradualIntervalConfigGlyph.setMin(this.getMinAndMaxValue().getMinNum());
        } else {
            if (d > 0.0) {
                d = 0.0;
            }
            gradualIntervalConfigGlyph.setMin(d);
        }
        if (this.getMinAndMaxValue().isCustomMax()) {
            gradualIntervalConfigGlyph.setMax(this.getMinAndMaxValue().getMaxNum());
        } else {
            gradualIntervalConfigGlyph.setMax(d2);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("GradualIntervalConfig");
        xMLPrintWriter.startTAG("IntervalConfigAttr").attr("subColor", this.getSubColor().getRGB()).attr("divStage", this.getDivStage()).end();
        this.writeValueRangeXML(xMLPrintWriter);
        this.writeColorDistXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private void writeValueRangeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ValueRange");
        xMLPrintWriter.attr("IsCustomMin", this.getMinAndMaxValue().isCustomMin());
        if (this.getMinAndMaxValue().isCustomMin()) {
            xMLPrintWriter.attr("minValue", this.getMinAndMaxValue().getMinValue().toString());
        }
        xMLPrintWriter.attr("IsCustomMax", this.getMinAndMaxValue().isCustomMax());
        if (this.getMinAndMaxValue().isCustomMax()) {
            xMLPrintWriter.attr("maxValue", this.getMinAndMaxValue().getMaxValue().toString());
        }
        xMLPrintWriter.end();
    }

    private void writeColorDistXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ColorDistList");
        for (GradualColorDist gradualColorDist : this.getGradualColorDistList()) {
            xMLPrintWriter.startTAG("ColorDist").attr("color", gradualColorDist.getColor().getRGB()).attr("dist", gradualColorDist.getPosition()).end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("IntervalConfigAttr".equals(string)) {
                this.setSubColor(xMLableReader.getAttrAsColor("subColor", null));
                this.setDivStage(xMLableReader.getAttrAsDouble("divStage", 2.0));
            }
            if ("ValueRange".equals(string)) {
                String string2 = "";
                this.getMinAndMaxValue().setCustomMin(xMLableReader.getAttrAsBoolean("IsCustomMin", false));
                string2 = xMLableReader.getAttrAsString("minValue", null);
                if (string2 != null) {
                    this.getMinAndMaxValue().setMinValue(new Formula(string2));
                }
                this.getMinAndMaxValue().setCustomMax(xMLableReader.getAttrAsBoolean("IsCustomMax", false));
                string2 = xMLableReader.getAttrAsString("maxValue", null);
                if (string2 != null) {
                    this.getMinAndMaxValue().setMaxValue(new Formula(string2));
                }
            }
            if ("ColorDistList".equals(string)) {
                this.getGradualColorDistList().clear();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        GradualIntervalConfig.this.readColorDistXML(xMLableReader);
                    }
                });
            }
        }
    }

    private void readColorDistXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "ColorDist".equals(string = xMLableReader.getTagName())) {
            Color color = xMLableReader.getAttrAsColor("color", Color.WHITE);
            float f = xMLableReader.getAttrAsFloat("dist", 0.0f);
            this.getGradualColorDistList().add(new GradualColorDist(f, color));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GradualIntervalConfig gradualIntervalConfig = (GradualIntervalConfig)super.clone();
        gradualIntervalConfig.setSubColor(this.getSubColor());
        gradualIntervalConfig.gradualColorDistList = new ArrayList();
        gradualIntervalConfig.gradualColorDistList.clear();
        if (!this.gradualColorDistList.isEmpty()) {
            for (int i = 0; i < this.gradualColorDistList.size(); ++i) {
                GradualColorDist gradualColorDist = this.gradualColorDistList.get(i);
                gradualIntervalConfig.gradualColorDistList.add((GradualColorDist)gradualColorDist.clone());
            }
        }
        gradualIntervalConfig.setDivStage(this.getDivStage());
        gradualIntervalConfig.setMinAndMaxValue((MinAndMaxValue)this.getMinAndMaxValue().clone());
        return gradualIntervalConfig;
    }

    public boolean equals(Object object) {
        return object instanceof GradualIntervalConfig && ((GradualIntervalConfig)object).getDivStage() == this.getDivStage() && ComparatorUtils.equals((Object)((GradualIntervalConfig)object).getSubColor(), (Object)this.getSubColor()) && ComparatorUtils.equals(((GradualIntervalConfig)object).getGradualColorDistList(), this.getGradualColorDistList()) && ComparatorUtils.equals((Object)((GradualIntervalConfig)object).getMinAndMaxValue(), (Object)this.getMinAndMaxValue());
    }

    public void dealFormula(Calculator calculator) {
        if (this.minAndMaxValue != null) {
            this.minAndMaxValue.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.minAndMaxValue != null) {
            this.minAndMaxValue.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.minAndMaxValue != null) {
            this.minAndMaxValue.modFormulaString(mOD_COLUMN_ROW);
        }
    }
}

