/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.stable.web.Repository;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class VanChartTitleGlyph
extends TitleGlyph {
    private static final long serialVersionUID = 7433581862270748780L;
    private boolean useHtml;
    private boolean floating;
    private double floatPercentX;
    private double floatPercentY;
    private boolean limitSize;
    private double maxHeight;

    public VanChartTitleGlyph() {
    }

    public VanChartTitleGlyph(String string, TextAttr textAttr) {
        super(string, textAttr);
    }

    public void setUseHtml(boolean bl) {
        this.useHtml = bl;
    }

    public boolean isUseHtml() {
        return this.useHtml;
    }

    public void setFloating(boolean bl) {
        this.floating = bl;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloatPercentX(double d) {
        this.floatPercentX = d;
    }

    public double getFloatPercentX() {
        return this.floatPercentX;
    }

    public void setFloatPercentY(double d) {
        this.floatPercentY = d;
    }

    public double getFloatPercentY() {
        return this.floatPercentY;
    }

    public void setLimitSize(boolean bl) {
        this.limitSize = bl;
    }

    public boolean isLimitSize() {
        return this.limitSize;
    }

    public void setMaxHeight(double d) {
        this.maxHeight = d;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public void layoutTitleAndRefreshChartBounds(Rectangle2D rectangle2D, double d, double d2, int n) {
        Dimension2D dimension2D = this.preferredDimension(n, rectangle2D.getWidth(), rectangle2D.getHeight());
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.isFloating()) {
            d3 = this.getFloatPercentX() * rectangle2D.getWidth() / 100.0;
            d4 = this.getFloatPercentY() * rectangle2D.getHeight() / 100.0;
        } else {
            d3 = this.getPosition() == 2 ? rectangle2D.getX() : (this.getPosition() == 4 ? rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth() : rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, dimension2D.getWidth(), dimension2D.getHeight());
        this.setBounds(ChartBaseUtils.rectangle2RoundRectangle((Rectangle2D)double_, (double)this.getRoundRadius()));
        if (!this.isFloating()) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + dimension2D.getHeight() + d, rectangle2D.getWidth(), rectangle2D.getHeight() - dimension2D.getHeight() - d2);
        }
    }

    public Dimension2D preferredDimension(int n, double d, double d2) {
        String string = this.dealStringAutoWrap(this.text, this.textAttr, n, d - 8.0);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)this.textAttr, (int)n);
        if (this.isFloating()) {
            return new DoubleDimension2D(Math.min(dimension2D.getWidth() + 8.0, d), Math.min(dimension2D.getHeight() + 8.0, d2));
        }
        if (this.isLimitSize()) {
            double d3 = Math.min(d2 * this.getMaxHeight() / 100.0, dimension2D.getHeight() + 8.0);
            return new DoubleDimension2D(d, d3);
        }
        return new DoubleDimension2D(d, dimension2D.getHeight() + 8.0);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Background background = this.getBackground();
        if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"ColorBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(((ColorBackground)background).getColor(), this.getAlpha()));
        } else if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"GradientBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getGradientBackgroundJSON((GradientBackground)background, this.getAlpha()));
        }
        jSONObject.put("borderRadius", this.getRoundRadius());
        if (this.isFloating()) {
            jSONObject.put("floating", this.isFloating());
            jSONObject.put("x", (Object)(this.getFloatPercentX() + "%"));
            jSONObject.put("y", (Object)(this.getFloatPercentY() + "%"));
        } else {
            jSONObject.put("align", (Object)ChartUtils.getPositionString((int)this.getPosition()));
            if (this.isLimitSize()) {
                jSONObject.put("maxHeight", (Object)(this.getMaxHeight() + "%"));
            }
        }
        jSONObject.put("text", (Object)this.getText());
        jSONObject.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.getTextAttr().getFRFont()));
        jSONObject.put("useHtml", this.isUseHtml());
        return jSONObject;
    }
}

