/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge.glyph;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.FRFont;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.column.ColumnTopDownShadeStyle;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class ThermometerGaugeGlyph
extends GaugeGlyph {
    private static final long serialVersionUID = 2377125930562201704L;
    private static final int R = 5;
    private static final int MAIN_TICK = 6;
    private static final int SEC_TICK = 4;
    private static final double SMALL_RADIUS = 3.0;
    private static final double BIG_RADIUS = 6.0;
    private static final int AXIS_GAP = 4;
    private static final double LABEL_THERMOMETER_GAP = 0.8;
    private static final double LABEL_LABEL_GAP = 0.5;
    private static final double COLOR = 0.1;
    private static final double TEMP = 2.0;
    private Point2D valueLabelCenterPoint;
    private Point2D percentLabelCenterPoint;
    private RoundRectangle2D thermometerBounds;
    private RoundRectangle2D seriesBounds;
    private Point2D valuePoint;
    private Color valueColor;

    public ThermometerGaugeGlyph(Rectangle2D rectangle2D, AttrLabel attrLabel, GaugeDetailStyle gaugeDetailStyle, VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph) {
        super(rectangle2D, attrLabel, gaugeDetailStyle, vanChartGaugeAxisGlyph);
    }

    private boolean isVertical() {
        return this.gaugeDetailStyle.isHorizontalLayout();
    }

    @Override
    public void doLayout(double d, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        Dimension2D dimension2D = new Dimension(0, 0);
        Dimension2D dimension2D2 = new Dimension(0, 0);
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            object4 = this.attrLabel.getAttrLabelDetail();
            object3 = this.attrLabel.getGaugeValueLabelDetail();
            n2 = ((AttrLabelDetail)object4).getPosition();
            n3 = ((AttrLabelDetail)object3).getPosition();
            object2 = ((AttrLabelDetail)object4).getTextAttr().getFRFont();
            object = ((AttrLabelDetail)object3).getTextAttr().getFRFont();
            dimension2D = GaugeGlyphHelper.calculateTextDimension(this.cateOrPercentLabelString, (FRFont)object2, n);
            dimension2D2 = GaugeGlyphHelper.calculateTextDimension(this.valueLabelString, (FRFont)object, n);
            d2 = GaugeGlyphHelper.calculateOneLineHeight((FRFont)object2);
            d3 = GaugeGlyphHelper.calculateOneLineHeight((FRFont)object);
            bl = ((AttrLabelDetail)object4).getContent().hasLabelContent();
            bl2 = ((AttrLabelDetail)object3).getContent().hasLabelContent();
        }
        object4 = GaugeGlyphHelper.value2String(this.gaugeAxisGlyph.getMaxValue(), this.gaugeAxisGlyph.getFormat());
        object3 = GaugeGlyphHelper.value2String(this.gaugeAxisGlyph.getMinValue(), this.gaugeAxisGlyph.getFormat());
        object2 = GlyphUtils.calculateTextDimensionWithNoRotation((String)object4, (TextAttr)this.gaugeAxisGlyph.getTextAttr(), (int)n);
        object = GlyphUtils.calculateTextDimensionWithNoRotation((String)object3, (TextAttr)this.gaugeAxisGlyph.getTextAttr(), (int)n);
        Dimension dimension = new Dimension((int)Math.max(((Dimension2D)object2).getWidth(), ((Dimension2D)object).getWidth()), (int)((Dimension2D)object2).getHeight());
        if (this.isVertical()) {
            this.doVerticalLayout(dimension2D, dimension2D2, dimension, d2, d3, bl, n2, bl2, n3);
            this.radius = this.bounds.getHeight();
        } else {
            this.doHorizontalLayout(dimension2D, dimension2D2, dimension, d2, d3, bl, n2, bl2, n3);
            this.radius = this.bounds.getWidth();
        }
    }

    private void doHorizontalLayout(Dimension2D dimension2D, Dimension2D dimension2D2, Dimension2D dimension2D3, double d, double d2, boolean bl, int n, boolean bl2, int n2) {
        double d3 = this.gaugeAxisGlyph.isShowAxisLabel() ? dimension2D3.getHeight() + 4.0 : 0.0;
        d3 += 20.0;
        boolean bl3 = bl && n == 1;
        boolean bl4 = bl && n == 3;
        boolean bl5 = bl2 && n2 == 1;
        boolean bl6 = bl2 && n2 == 3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (bl3) {
            d4 = d6;
            d6 += dimension2D.getHeight();
        }
        if (bl5) {
            d5 = d6 += bl3 ? d * 0.5 : 0.0;
            d6 += dimension2D2.getHeight();
        }
        double d7 = d6 += (bl5 ? d2 : (bl3 ? d : 0.0)) * 0.8;
        d6 += d3;
        if (bl4) {
            d4 = d6 += d * 0.8;
            d6 += dimension2D.getHeight();
        }
        if (bl6) {
            d5 = d6 += bl4 ? d * 0.5 : d2 * 0.8;
            d6 += dimension2D2.getHeight();
        }
        d6 = (this.bounds.getHeight() - d6) / 2.0;
        this.initHorizontalBounds(dimension2D, dimension2D2, dimension2D3, d4 += d6, d5 += d6, d7 += d6, d3);
    }

    private void initHorizontalBounds(Dimension2D dimension2D, Dimension2D dimension2D2, Dimension2D dimension2D3, double d, double d2, double d3, double d4) {
        this.valueLabelCenterPoint = new Point2D.Double(this.bounds.getWidth() / 2.0, d2 + dimension2D2.getHeight() / 2.0);
        this.percentLabelCenterPoint = new Point2D.Double(this.bounds.getWidth() / 2.0, d + dimension2D.getHeight() / 2.0);
        double d5 = 5.0 + dimension2D3.getWidth() / 2.0;
        double d6 = 10.0;
        double d7 = d3 + (d4 - d6);
        double d8 = this.bounds.getWidth() - 2.0 * d5;
        this.thermometerBounds = new RoundRectangle2D.Double(d5, d7, d8, d6, d6, d6);
        double d9 = this.getValue(d8, d5, false);
        this.valuePoint = new Point2D.Double(d9, d7 + 5.0);
        this.seriesBounds = new RoundRectangle2D.Double(d5, d7, d9 - d5, d6, d6, d6);
    }

    private void doVerticalLayout(Dimension2D dimension2D, Dimension2D dimension2D2, Dimension2D dimension2D3, double d, double d2, boolean bl, int n, boolean bl2, int n2) {
        double d3;
        double d4;
        double d5;
        boolean bl3 = bl && n == 2;
        boolean bl4 = bl && n == 4;
        boolean bl5 = bl2 && n2 == 2;
        boolean bl6 = bl2 && n2 == 4;
        boolean bl7 = bl3 && bl6 || bl4 && bl5;
        double d6 = 0.8 * Math.max(d, d2);
        double d7 = 20.0;
        d7 += this.gaugeAxisGlyph.isShowAxisLabel() ? 4.0 + dimension2D3.getWidth() : 0.0;
        double d8 = 0.0;
        if (bl7) {
            if (bl4) {
                d5 = d8;
                d4 = d8 += dimension2D2.getWidth() + d6;
                d3 = d8 += d7 + d6;
                d8 += dimension2D.getWidth();
            } else {
                d3 = d8;
                d4 = d8 += dimension2D.getWidth() + d6;
                d5 = d8 += d7 + d6;
                d8 += dimension2D2.getWidth();
            }
        } else {
            double d9 = Math.max(dimension2D.getWidth(), dimension2D2.getWidth());
            if (bl4 || bl6) {
                d4 = d8;
                d3 = d8 += d7 + d6;
                d5 = d8;
                d8 += d9;
            } else {
                d3 = d8 + d9 - dimension2D.getWidth();
                d5 = d8 + d9 - dimension2D2.getWidth();
                d4 = d8 += d9 + d6;
                d8 += d7;
            }
        }
        d8 = (this.bounds.getWidth() - d8) / 2.0;
        this.initVerticalBounds(dimension2D, dimension2D2, dimension2D3, d, d3 += d8, d5 += d8, bl7, bl, d4 += d8);
    }

    private void initVerticalBounds(Dimension2D dimension2D, Dimension2D dimension2D2, Dimension2D dimension2D3, double d, double d2, double d3, boolean bl, boolean bl2, double d4) {
        double d5 = 10.0;
        double d6 = 5.0 + dimension2D3.getHeight() / 2.0;
        double d7 = this.bounds.getHeight() - 2.0 * d6;
        double d8 = this.getValue(d7, d6, true);
        this.thermometerBounds = new RoundRectangle2D.Double(d4, d6, d5, d7, d5, d5);
        this.valuePoint = new Point2D.Double(d4 + 5.0, d8);
        this.seriesBounds = new RoundRectangle2D.Double(d4, d8, d5, this.bounds.getHeight() - d6 - d8, d5, d5);
        double d9 = this.bounds.getHeight() - d6 - 5.0;
        if (bl) {
            this.percentLabelCenterPoint = d8 + dimension2D.getHeight() / 2.0 > d9 ? new Point2D.Double(d2 + dimension2D.getWidth() / 2.0, d9 - dimension2D.getHeight() / 2.0) : new Point2D.Double(d2 + dimension2D.getWidth() / 2.0, d8);
            this.valueLabelCenterPoint = d8 + dimension2D2.getHeight() / 2.0 > d9 ? new Point2D.Double(d3 + dimension2D2.getWidth() / 2.0, d9 - dimension2D2.getHeight() / 2.0) : new Point2D.Double(d3 + dimension2D2.getWidth() / 2.0, d8);
        } else {
            double d10 = bl2 ? dimension2D.getHeight() / 2.0 + d * 0.5 : 0.0;
            if (d8 + (d10 += dimension2D2.getHeight()) > d9) {
                d8 = d9 - d10;
            }
            this.percentLabelCenterPoint = new Point2D.Double(d2 + dimension2D.getWidth() / 2.0, d8);
            this.valueLabelCenterPoint = new Point2D.Double(d3 + dimension2D2.getWidth() / 2.0, d8 + d10 - dimension2D2.getHeight() / 2.0);
        }
    }

    private double getValue(double d, double d2, boolean bl) {
        d -= 10.0;
        if (this.valueList.isEmpty()) {
            return -1.0;
        }
        double d3 = ((Number)this.valueList.get(0)).doubleValue();
        double d4 = this.gaugeAxisGlyph.getMinValue();
        double d5 = this.gaugeAxisGlyph.getMaxValue();
        d3 = Math.max(d3, d4);
        d3 = Math.min(d3, d5);
        this.valueColor = this.getValueColor(d3, d4, d5);
        return bl ? this.getValueY(d, d2, d4, d5, d3) : this.getValueX(d, d2, d4, d5, d3);
    }

    private double getValueY(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.min(d, d / (d4 - d3) * (d5 - d3));
        return this.bounds.getHeight() - d2 - d6 - 5.0;
    }

    private double getValueX(double d, double d2, double d3, double d4, double d5) {
        return d2 + d / (d4 - d3) * (d5 - d3) + 5.0;
    }

    @Override
    protected void drawInfo(Graphics2D graphics2D, int n) {
        this.drawThermometer(graphics2D);
        this.drawTicksAndAxisLabel(graphics2D, n);
        this.drawCateOrPercentageLabel(graphics2D, n);
        this.drawValueLabel(graphics2D, n);
    }

    private void drawThermometer(Graphics2D graphics2D) {
        graphics2D.setColor(GaugeGlyphHelper.getColor(this.gaugeDetailStyle.getSlotBackgroundColor()));
        graphics2D.fill(this.thermometerBounds);
        ThermometerTopDownShadeStyle thermometerTopDownShadeStyle = new ThermometerTopDownShadeStyle(this.valueColor, this.seriesBounds, !this.isVertical());
        thermometerTopDownShadeStyle.paintStyle(graphics2D);
        GaugeGlyphHelper.drawCircle(graphics2D, this.valuePoint, 6.0, this.getDarkerValueColor(this.valueColor));
        GaugeGlyphHelper.drawCircle(graphics2D, this.valuePoint, 3.0, this.gaugeDetailStyle.getNeedleColor());
    }

    private Color getDarkerValueColor(Color color) {
        color = color == null ? new Color(255, 255, 255, 0) : color;
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return Color.getHSBColor(fArray[0], Math.min(1.0f, (float)((double)fArray[1] * 1.1)), Math.max(0.0f, (float)((double)fArray[2] * 0.9)));
    }

    private void drawTicksAndAxisLabel(Graphics2D graphics2D, int n) {
        double d = this.gaugeAxisGlyph.getMaxValue();
        double d2 = this.gaugeAxisGlyph.getMinValue();
        double d3 = this.gaugeAxisGlyph.getMainUnit();
        double d4 = this.gaugeAxisGlyph.getSecUnit();
        Color color = this.gaugeAxisGlyph.getMainTickColor();
        Color color2 = this.gaugeAxisGlyph.getSecTickColor();
        TextAttr textAttr = this.gaugeAxisGlyph.getTextAttr();
        double d5 = (this.isVertical() ? this.thermometerBounds.getHeight() : this.thermometerBounds.getWidth()) - 10.0;
        double d6 = d5 / (d - d2) * d3;
        double d7 = d5 / (d - d2) * d4;
        if (this.isVertical()) {
            double d8;
            double d9 = this.thermometerBounds.getMaxX() + 4.0;
            double d10 = this.thermometerBounds.getY() + 5.0;
            double d11 = d9 + 4.0;
            double d12 = d11 + 4.0;
            for (d8 = d; d8 >= d2; d8 -= d4) {
                this.drawTickLine(graphics2D, color2, d9, d10, d11, d10);
                d10 += d7;
            }
            d11 = d9 + 6.0;
            d10 = this.thermometerBounds.getY() + 5.0;
            for (d8 = d; d8 >= d2 - 1.0E-10; d8 -= d3) {
                this.drawTickLine(graphics2D, color, d9, d10, d11, d10);
                this.drawTickLabel4Vertical(graphics2D, n, textAttr, d8, d10, d12);
                d10 += d6;
            }
        } else {
            double d13;
            double d14 = this.thermometerBounds.getY() - 4.0;
            double d15 = this.thermometerBounds.getX() + 5.0;
            double d16 = d14 - 4.0;
            double d17 = d16 - 4.0;
            for (d13 = d2; d13 <= d; d13 += d4) {
                this.drawTickLine(graphics2D, color2, d15, d16, d15, d14);
                d15 += d7;
            }
            d15 = this.thermometerBounds.getX() + 5.0;
            d16 = d14 - 6.0;
            for (d13 = d2; d13 <= d + 1.0E-10; d13 += d3) {
                this.drawTickLine(graphics2D, color, d15, d16, d15, d14);
                this.drawTickLabel4Horizontal(graphics2D, n, textAttr, d13, d15, d17);
                d15 += d6;
            }
        }
    }

    private void drawTickLine(Graphics2D graphics2D, Color color, double d, double d2, double d3, double d4) {
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics2D.setColor(GaugeGlyphHelper.getColor(color));
        graphics2D.draw(new Line2D.Double(d3, d4, d, d2));
    }

    private void drawTickLabel4Horizontal(Graphics2D graphics2D, int n, TextAttr textAttr, double d, double d2, double d3) {
        if (this.gaugeAxisGlyph.isShowAxisLabel()) {
            String string = GaugeGlyphHelper.value2String(d, this.gaugeAxisGlyph.getFormat());
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)textAttr, (int)n);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - dimension2D.getWidth() / 2.0, d3 - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
            GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)textAttr, (Rectangle2D)double_, (int)n);
        }
    }

    private void drawTickLabel4Vertical(Graphics2D graphics2D, int n, TextAttr textAttr, double d, double d2, double d3) {
        if (this.gaugeAxisGlyph.isShowAxisLabel()) {
            String string = GaugeGlyphHelper.value2String(d, this.gaugeAxisGlyph.getFormat());
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)textAttr, (int)n);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d2 - dimension2D.getHeight() / 2.0 - 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)textAttr, (Rectangle2D)double_, (int)n);
        }
    }

    @Override
    protected Rectangle2D getCateOrPercentLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.percentLabelCenterPoint.getX() - dimension2D.getWidth() / 2.0;
        double d2 = this.percentLabelCenterPoint.getY() - dimension2D.getHeight() / 2.0;
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected Rectangle2D getValueLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.valueLabelCenterPoint.getX() - dimension2D.getWidth() / 2.0;
        double d2 = this.valueLabelCenterPoint.getY() - dimension2D.getHeight() / 2.0;
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    private class ThermometerTopDownShadeStyle
    extends ColumnTopDownShadeStyle {
        private ThermometerTopDownShadeStyle(Color color, RectangularShape rectangularShape, boolean bl) {
            super(color, rectangularShape, bl);
        }

        @Override
        protected Color getStartColor() {
            return this.baseColor;
        }

        @Override
        protected Color getEndColor() {
            this.baseColor = this.baseColor == null ? new Color(255, 255, 255, 0) : this.baseColor;
            float[] fArray = new float[3];
            Color.RGBtoHSB(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), fArray);
            return Color.getHSBColor(fArray[0], Math.max(0.0f, (float)((double)fArray[1] * 0.9)), Math.min(1.0f, (float)((double)fArray[2] * 1.1)));
        }
    }
}

