/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge;

import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.general.FRFont;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.GaugeStyle;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.gauge.glyph.PointerGaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.RingGaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.SemiPointerGaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.SlotGaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.ThermometerGaugeGlyph;
import com.fr.plugin.chart.glyph.VanChartAxisPlotGlyphInterface;
import com.fr.plugin.chart.glyph.VanChartPlotGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class VanChartGaugePlotGlyph
extends VanChartPlotGlyph
implements VanChartAxisPlotGlyphInterface {
    private static final long serialVersionUID = 8281521012356811258L;
    private static final FRFont PERCENT_LABEL_AUTO_FONT = FRFont.getInstance((String)"verdana", (int)1, (float)27.0f, (Color)Color.black);
    public static final int DEFAULT_COLOR_NUMBER = 3;
    private GaugeStyle gaugeStyle = GaugeStyle.POINTER;
    private GaugeDetailStyle gaugeDetailStyle;
    private VanChartGaugeAxisGlyph gaugeAxisGlyph = new VanChartGaugeAxisGlyph();
    private AttrLabel attrLabel;
    private List<GaugeGlyph> gaugeGlyphs = new ArrayList<GaugeGlyph>();

    public GaugeStyle getGaugeStyle() {
        return this.gaugeStyle;
    }

    public void setGaugeStyle(GaugeStyle gaugeStyle) {
        this.gaugeStyle = gaugeStyle;
    }

    public void setGaugeDetailStyle(GaugeDetailStyle gaugeDetailStyle) {
        this.gaugeDetailStyle = gaugeDetailStyle;
    }

    public GaugeDetailStyle getGaugeDetailStyle() {
        return this.gaugeDetailStyle;
    }

    public void setGaugeAxisGlyph(VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph) {
        this.gaugeAxisGlyph = vanChartGaugeAxisGlyph;
    }

    public VanChartGaugeAxisGlyph getGaugeAxisGlyph() {
        return this.gaugeAxisGlyph;
    }

    public void setAttrLabel(AttrLabel attrLabel) {
        this.attrLabel = attrLabel;
    }

    public boolean isMultiPointer() {
        switch (this.gaugeStyle) {
            case POINTER: {
                return true;
            }
            case POINTER_SEMI: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void layoutAxisGlyph(int n) {
        double[] dArray = this.getMinMaxValue();
        this.gaugeAxisGlyph.initMinMaxValue(dArray[0], dArray[1]);
    }

    private int getRealCategoryCount() {
        int n = this.getCategoryCount();
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            int n3 = this.getSeriesSize();
            for (int j = 0; j < n3; ++j) {
                DataPoint dataPoint = this.getSeries(j).getDataPoint(i);
                if (dataPoint.isValueIsNull()) continue;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    @Override
    public void layoutDataSeriesGlyph(int n) {
        super.layoutDataSeriesGlyph(n);
        int n2 = this.getRealCategoryCount();
        if (n2 < 1 || this.getSeriesSize() < 1) {
            return;
        }
        double d = this.getEachWidth(n2);
        double d2 = this.getEachHeight(n2);
        double d3 = this.getCategoryLabelHeight(n);
        Color[] colorArray = ChartBaseUtils.createFillColorArray((AttrFillStyle)this.getPlotFillStyle(), (int)3);
        int n3 = 0;
        int n4 = this.getCategoryCount();
        for (int i = 0; i < n4; ++i) {
            Rectangle2D.Double double_ = this.gaugeDetailStyle.isHorizontalLayout() ? new Rectangle2D.Double((double)n3 * d, 0.0, d, d2) : new Rectangle2D.Double(0.0, (double)n3 * d2, d, d2);
            boolean bl = this.initEachCategoryShape(i, double_, d3, colorArray, n);
            if (!bl) continue;
            ++n3;
        }
    }

    private double getEachWidth(int n) {
        Rectangle2D rectangle2D = this.getBounds();
        if (this.gaugeDetailStyle.isHorizontalLayout()) {
            return rectangle2D.getWidth() / (double)n;
        }
        return rectangle2D.getWidth();
    }

    private double getEachHeight(int n) {
        Rectangle2D rectangle2D = this.getBounds();
        if (this.gaugeDetailStyle.isHorizontalLayout()) {
            return rectangle2D.getHeight();
        }
        return rectangle2D.getHeight() / (double)n;
    }

    private double getCategoryLabelHeight(int n) {
        if (this.attrLabel == null || !this.attrLabel.isEnable()) {
            return 0.0;
        }
        AttrLabelDetail attrLabelDetail = this.attrLabel.getAttrLabelDetail();
        String string = this.isMultiPointer() ? VanChartAttrHelper.getCategoryName(attrLabelDetail.getContent(), this.getSeries(0).getDataPoint(0)) : VanChartAttrHelper.getPercent(attrLabelDetail.getContent(), this.getSeries(0).getDataPoint(0));
        FRFont fRFont = attrLabelDetail.isCustom() ? attrLabelDetail.getTextAttr().getFRFont() : PERCENT_LABEL_AUTO_FONT;
        return GaugeGlyphHelper.calculateTextDimension(string, fRFont, n).getHeight();
    }

    private boolean initEachCategoryShape(int n, Rectangle2D rectangle2D, double d, Color[] colorArray, int n2) {
        GaugeGlyph gaugeGlyph = this.createGaugeGlyph(rectangle2D);
        gaugeGlyph.setDefaultColors(colorArray);
        MapHotAreaColor mapHotAreaColor = this.getGaugeDetailStyle().getHotAreaColor();
        if (mapHotAreaColor.getUseType() != 0) {
            gaugeGlyph.setColorList(mapHotAreaColor.getAreaColorList());
        }
        String string = "";
        boolean bl = false;
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            String string2;
            DataPoint dataPoint = this.getSeries(i).getDataPoint(n);
            if (dataPoint.isValueIsNull()) continue;
            gaugeGlyph.addValue(dataPoint.getValue());
            bl = true;
            if (this.attrLabel == null || !this.attrLabel.isEnable() || !StringUtils.isNotEmpty((String)(string2 = gaugeGlyph.getValueLabelWithDataPoint(dataPoint)))) continue;
            if (StringUtils.isNotEmpty((String)string)) {
                string = string + "\n";
            }
            string = string + string2;
        }
        if (!bl) {
            return false;
        }
        this.gaugeGlyphs.add(gaugeGlyph);
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            DataPoint dataPoint = this.getSeries(0).getDataPoint(n);
            gaugeGlyph.setCateOrPercentLabelString(dataPoint);
            gaugeGlyph.setValueLabelString(string);
        }
        gaugeGlyph.doLayout(d, n2);
        return true;
    }

    private GaugeGlyph createGaugeGlyph(Rectangle2D rectangle2D) {
        switch (this.gaugeStyle) {
            case POINTER: {
                return new PointerGaugeGlyph(rectangle2D, this.attrLabel, this.gaugeDetailStyle, this.gaugeAxisGlyph);
            }
            case POINTER_SEMI: {
                return new SemiPointerGaugeGlyph(rectangle2D, this.attrLabel, this.gaugeDetailStyle, this.gaugeAxisGlyph);
            }
            case RING: {
                return new RingGaugeGlyph(rectangle2D, this.attrLabel, this.gaugeDetailStyle, this.gaugeAxisGlyph);
            }
            case SLOT: {
                return new SlotGaugeGlyph(rectangle2D, this.attrLabel, this.gaugeDetailStyle, this.gaugeAxisGlyph);
            }
        }
        return new ThermometerGaugeGlyph(rectangle2D, this.attrLabel, this.gaugeDetailStyle, this.gaugeAxisGlyph);
    }

    public void calculateDataPointPercentValue() {
        double d = this.gaugeAxisGlyph.getMinValue();
        double d2 = this.gaugeAxisGlyph.getMaxValue();
        int n = this.getSeriesSize();
        int n2 = this.getCategoryCount();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; j < n2; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                double d3 = dataPoint.getValue();
                if (dataPoint.isValueIsNull()) continue;
                if (d2 == d) {
                    dataPoint.setPercentValue(0.0);
                    continue;
                }
                dataPoint.setPercentValue((d3 - d) / (d2 - d));
            }
        }
    }

    @Override
    public void draw(Graphics graphics, int n) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        if (shape == null) {
            this.resetClip(graphics2D);
        }
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        for (GaugeGlyph gaugeGlyph : this.gaugeGlyphs) {
            gaugeGlyph.draw(graphics, n);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        graphics2D.setClip(shape);
    }

    public String getChartType() {
        return "gauge";
    }

    @Override
    public void addXAxisJSON(JSONObject jSONObject, Repository repository) throws JSONException {
    }

    @Override
    public void addYAxisJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)this.getGaugeAxisGlyph().toJSONObject(repository));
        jSONObject.put("yAxis", (Object)jSONArray);
    }

    public Color[] createColors4Series() {
        if (this.getPlotFillStyle().getColorStyle() == 2) {
            return ChartBaseUtils.createFillColorArray((AttrFillStyle)this.getPlotFillStyle(), (int)3);
        }
        return ChartBaseUtils.createFillColorArray((AttrFillStyle)this.getPlotFillStyle(), (int)3);
    }

    @Override
    public void addSeriesJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        this.addSeriesJSONWithCate2Series(jSONObject, repository);
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        jSONObject.put("style", (Object)this.getGaugeStyle().getStyle());
        jSONObject.put("layout", (Object)(this.getGaugeDetailStyle().isHorizontalLayout() ? "horizontal" : "vertical"));
        MapHotAreaColor mapHotAreaColor = this.getGaugeDetailStyle().getHotAreaColor();
        if (mapHotAreaColor.getUseType() != 0) {
            jSONObject.put("bands", (Object)this.getGaugeDetailStyle().getBandsArray());
        }
        this.getGaugeDetailStyle().addDetailStyleJSON(jSONObject, this.getGaugeStyle());
        return jSONObject;
    }

    @Override
    protected void addLabelJSON(JSONObject jSONObject, AttrLabel attrLabel, Repository repository) throws JSONException {
        if (this.isMultiPointer()) {
            jSONObject.put("seriesLabel", (Object)attrLabel.toJSONObject(repository));
        } else {
            jSONObject.put("percentageLabel", (Object)attrLabel.toJSONObject(repository));
        }
        jSONObject.put("valueLabel", (Object)attrLabel.toGaugeValueLabelJSONObject());
    }

    @Override
    protected void addNullLabelJSON(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("enabled", false);
        if (this.isMultiPointer()) {
            jSONObject.put("seriesLabel", (Object)jSONObject2);
        } else {
            jSONObject.put("percentageLabel", (Object)jSONObject2);
        }
        jSONObject.put("valueLabel", (Object)jSONObject2);
    }
}

