/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.bubble;

import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.TextAttr;
import com.fr.data.condition.CommonCondition;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.bubble.attr.VanChartAttrBubble;
import com.fr.plugin.chart.bubble.utils.DisplayType;
import com.fr.plugin.chart.scatter.VanChartScatterDataPoint;
import com.fr.stable.ArrayUtils;
import com.fr.stable.web.Repository;
import java.awt.Graphics;

public class VanChartBubbleDataPoint
extends VanChartScatterDataPoint {
    private VanChartAttrBubble attrBubble;
    private boolean forceBubble = false;
    private double posX;
    private double posY;
    private double px;
    private double py;
    private double radius;
    private DisplayType bubbleDisplay = DisplayType.IN_ALL;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public DisplayType getBubbleDisplay() {
        return this.bubbleDisplay;
    }

    public void setBubbleDisplay(DisplayType displayType) {
        this.bubbleDisplay = displayType;
    }

    public double getPosX() {
        return this.posX;
    }

    public void setPosX(double d) {
        this.posX = d;
    }

    public double getPosY() {
        return this.posY;
    }

    public void setPosY(double d) {
        this.posY = d;
    }

    public double getPx() {
        return this.px;
    }

    public void setPx(double d) {
        this.px = d;
    }

    public double getPy() {
        return this.py;
    }

    public void setPy(double d) {
        this.py = d;
    }

    public VanChartAttrBubble getAttrBubble() {
        return this.attrBubble;
    }

    public void setAttrBubble(VanChartAttrBubble vanChartAttrBubble) {
        this.attrBubble = vanChartAttrBubble;
    }

    public boolean isForceBubble() {
        return this.forceBubble;
    }

    public void setForceBubble(boolean bl) {
        this.forceBubble = bl;
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.attrBubble != null) {
            this.attrBubble.toJSONObject(jSONObject, repository);
        }
        return jSONObject;
    }

    @Override
    public void drawAutoFontLabelText(Graphics graphics, int n) {
        String string = this.getDataLabel().getText();
        TextAttr textAttr = this.getDataLabel().getTextAttr();
        if (this.isForceBubble()) {
            this.drawLabelText(graphics, n, string);
        } else {
            this.drawScatterLabelText(graphics, n, string);
        }
        this.getDataLabel().setTextAttr(textAttr);
    }

    private void drawLabelText(Graphics graphics, int n, String string) {
        String string2 = VanChartAttrHelper.getCateAndSeries(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        String string3 = VanChartAttrHelper.getValueAndPercent(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        TextAttr textAttr = new TextAttr();
        this.getDataLabel().setTextAttr(textAttr);
        FRFont fRFont = this.isOutside() ? this.getOutSideCateAndSeriesFont() : this.getInSideCateAndSeriesFont();
        FRFont fRFont2 = this.isOutside() ? this.getOutSideValueAndPercentFont() : this.getInSideValueAndPercentFont();
        this.drawTextWithFont(string, textAttr, string2, fRFont, graphics, n);
        this.drawTextWithFont(string, textAttr, string3, fRFont2, graphics, n);
    }

    private void drawScatterLabelText(Graphics graphics, int n, String string) {
        String string2 = VanChartAttrHelper.getScatterSeries(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        String string3 = VanChartAttrHelper.getScatterXAndYAndSize(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        TextAttr textAttr = new TextAttr();
        this.getDataLabel().setTextAttr(textAttr);
        FRFont fRFont = this.isOutside() ? this.getOutSideCateAndSeriesFont() : this.getInSideCateAndSeriesFont();
        FRFont fRFont2 = this.isOutside() ? this.getOutSideValueAndPercentFont() : this.getInSideValueAndPercentFont();
        this.drawTextWithFont(string, textAttr, string2, fRFont, graphics, n);
        this.drawTextWithFont(string, textAttr, string3, fRFont2, graphics, n);
    }

    @Override
    public Object toResult(CommonCondition commonCondition) {
        if (this.isForceBubble()) {
            String string = commonCondition.getColumnName();
            if (ComparatorUtils.equals((Object)string, (Object)ChartConstants.CATEGORY_INDEX) || ArrayUtils.contains((Object[])ChartConstants.CAGORY_INDEX_KEYS, (Object)string)) {
                return this.getCategoryIndex() + 1;
            }
            if (ComparatorUtils.equals((Object)string, (Object)ChartConstants.SERIES_INDEX) || ArrayUtils.contains((Object[])ChartConstants.SERIES_INDEX_KEYS, (Object)string)) {
                return this.getSeriesIndex() + 1;
            }
            if (this.isUseValue(string)) {
                return this.getValue();
            }
            if (this.isUseCateName(string)) {
                return this.getCategoryName();
            }
            if (ComparatorUtils.equals((Object)string, (Object)ChartConstants.SERIES_NAME) || ArrayUtils.contains((Object[])ChartConstants.SERIES_NAME_KEYS, (Object)string)) {
                return this.getSeriesName();
            }
            return this;
        }
        return super.toResult(commonCondition);
    }

    private boolean isUseCateName(String string) {
        return ComparatorUtils.equals((Object)string, (Object)ChartConstants.CATEGORY_NAME) || ArrayUtils.contains((Object[])ChartConstants.CATEGORY_NAME_KEYS, (Object)string);
    }

    @Override
    public boolean isOutside() {
        return false;
    }
}

