/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.mgr.mem;

import java.util.HashMap;
import java.util.Map;
import org.openwebflow.assign.permission.ActivityPermissionEntity;
import org.openwebflow.assign.permission.ActivityPermissionManager;
import org.openwebflow.mgr.common.SimpleActivityPermissionEntity;
import org.openwebflow.mgr.ext.ActivityPermissionManagerEx;

public class InMemoryActivityPermissionManager
implements ActivityPermissionManager,
ActivityPermissionManagerEx {
    Map<String, ActivityPermissionEntity> _entryMap = new HashMap<String, ActivityPermissionEntity>();

    private String getKey(String processDefId, String taskDefinitionKey) {
        return processDefId + "--" + taskDefinitionKey;
    }

    public ActivityPermissionEntity load(String processDefinitionId, String taskDefinitionKey, boolean addOrRemove) {
        if (addOrRemove) {
            return this._entryMap.get(this.getKey(processDefinitionId, taskDefinitionKey));
        }
        return null;
    }

    public void removeAll() {
        this._entryMap.clear();
    }

    public void save(String processDefId, String taskDefinitionKey, String assignee, String[] candidateGroupIds, String[] candidateUserIds) throws Exception {
        SimpleActivityPermissionEntity entry = new SimpleActivityPermissionEntity();
        entry.setAssignee(assignee);
        entry.setGrantedGroupIds(candidateGroupIds);
        entry.setGrantedUserIds(candidateUserIds);
        this._entryMap.put(this.getKey(processDefId, taskDefinitionKey), entry);
    }
}

