/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.alarm.impl;

import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.task.Task;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.openwebflow.alarm.MessageNotifier;
import org.openwebflow.alarm.TaskAlarmService;
import org.openwebflow.alarm.TaskNotificationManager;
import org.openwebflow.identity.IdentityMembershipManager;
import org.openwebflow.identity.UserDetailsEntity;
import org.openwebflow.identity.UserDetailsManager;
import org.openwebflow.util.IdentityUtils;
import org.springframework.beans.factory.DisposableBean;

public class TaskAlarmServiceImpl
implements TaskAlarmService,
DisposableBean {
    long _checkInterval = 10000L;
    IdentityMembershipManager _membershipManager;
    MessageNotifier _messageNotifier;
    private Timer _monitorTimer = new Timer(true);
    TaskNotificationManager _taskNotificationManager;
    String _periodInAdvance;
    ProcessEngine _processEngine;
    UserDetailsManager _userDetailsManager;

    public TaskNotificationManager getTaskNotificationManager() {
        return this._taskNotificationManager;
    }

    public void setTaskNotificationManager(TaskNotificationManager taskNotificationManager) {
        this._taskNotificationManager = taskNotificationManager;
    }

    public void destroy() throws Exception {
        this._monitorTimer.cancel();
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public IdentityMembershipManager getMembershipManager() {
        return this._membershipManager;
    }

    public MessageNotifier getMessageNotifier() {
        return this._messageNotifier;
    }

    public String getPeriodInAdvance() {
        return this._periodInAdvance;
    }

    public UserDetailsManager getUserDetailsManager() {
        return this._userDetailsManager;
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval;
    }

    public void setMembershipManager(IdentityMembershipManager membershipManager) {
        this._membershipManager = membershipManager;
    }

    public void setMessageNotifier(MessageNotifier messageNotifier) {
        this._messageNotifier = messageNotifier;
    }

    public void setPeriodInAdvance(String periodInAdvance) {
        this._periodInAdvance = periodInAdvance;
    }

    public void setUserDetailsManager(UserDetailsManager userDetailsManager) {
        this._userDetailsManager = userDetailsManager;
    }

    public void start(ProcessEngine processEngine) throws Exception {
        this._processEngine = processEngine;
        this._monitorTimer.schedule((TimerTask)new MonitorTask(), this._checkInterval, this._checkInterval);
    }

    class MonitorTask
    extends TimerTask {
        Period _parsedPeriodInAdvance;

        public MonitorTask() {
            this._parsedPeriodInAdvance = Period.parse((String)TaskAlarmServiceImpl.this._periodInAdvance);
        }

        private void checkAndNotify() throws Exception {
            Date dueDate = DateTime.now().minus((ReadablePeriod)this._parsedPeriodInAdvance).toDate();
            for (Task task : TaskAlarmServiceImpl.this._processEngine.getTaskService().createTaskQuery().active().dueAfter(dueDate).list()) {
                if (TaskAlarmServiceImpl.this._taskNotificationManager.isNotified(task.getId())) continue;
                List<UserDetailsEntity> involvedUsers = IdentityUtils.getUserDetailsFromIds(IdentityUtils.getInvolvedUsers(TaskAlarmServiceImpl.this._processEngine.getTaskService(), task, TaskAlarmServiceImpl.this._membershipManager), TaskAlarmServiceImpl.this._userDetailsManager);
                if (!involvedUsers.isEmpty()) {
                    TaskAlarmServiceImpl.this._messageNotifier.notify(involvedUsers.toArray(new UserDetailsEntity[0]), task);
                }
                TaskAlarmServiceImpl.this._taskNotificationManager.setNotified(task.getId());
                Logger.getLogger(this.getClass()).debug((Object)String.format("notified %s", involvedUsers));
            }
        }

        public void run() {
            try {
                this.checkAndNotify();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

