/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.IJEventListener;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;

public class EventListener
implements PlugIn,
IJEventListener,
ImageListener,
CommandListener {
    public void run(String arg) {
        IJ.addEventListener(this);
        Executer.addCommandListener(this);
        ImagePlus.addImageListener(this);
        IJ.log("EventListener started");
    }

    public void eventOccurred(int eventID) {
        switch (eventID) {
            case 0: {
                String c = Integer.toHexString(Toolbar.getForegroundColor().getRGB());
                c = "#" + c.substring(2);
                IJ.log("Changed foreground color to " + c);
                break;
            }
            case 1: {
                String c = Integer.toHexString(Toolbar.getBackgroundColor().getRGB());
                c = "#" + c.substring(2);
                IJ.log("Changed background color to " + c);
                break;
            }
            case 4: {
                String name = IJ.getToolName();
                IJ.log("Switched to the " + name + (name.endsWith("Tool") ? "" : " tool"));
                break;
            }
            case 2: {
                IJ.log("Color picker closed");
                break;
            }
            case 3: {
                IJ.removeEventListener(this);
                Executer.removeCommandListener(this);
                ImagePlus.removeImageListener(this);
                IJ.showStatus("Log window closed; EventListener stopped");
            }
        }
    }

    public void imageOpened(ImagePlus imp) {
        IJ.log("Opened \"" + imp.getTitle() + "\"");
    }

    public void imageClosed(ImagePlus imp) {
        IJ.log("Closed \"" + imp.getTitle() + "\"");
    }

    public void imageUpdated(ImagePlus imp) {
        IJ.log("Updated \"" + imp.getTitle() + "\"");
    }

    public String commandExecuting(String command) {
        IJ.log("Executed \"" + command + "\" command");
        return command;
    }
}

